/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.rnsh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.io.NInputContentProvider;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathChildStringDigestInfo;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.net.DefaultNConnectionString;
import net.thevpc.nuts.net.DefaultNConnectionStringBuilder;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.net.NConnectionStringBuilder;
import net.thevpc.nuts.net.NHttpCode;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.net.NWebRequest;
import net.thevpc.nuts.net.NWebResponse;
import net.thevpc.nuts.net.NWebResponseException;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgCode;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NMapBuilder;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUtils;

public class RnshHttpClient {
    public static final String CONTEXT_PATH_PARAM = "context";
    private NConnectionString connectionString;
    private LoginResult loginResult;
    private int accessTokenSafePeriod = 5000;
    private int refreshTokenSafePeriod = 30000;

    public NConnectionString getConnectionString() {
        return this.connectionString;
    }

    public RnshHttpClient setConnectionString(NConnectionString connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String version() {
        return NWebCli.of().POST(this.resolveUrl("version")).doWith(this::prepareSecurity).run().getContentAsString();
    }

    public NInputSource getFile(String remotePath) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("get-file")).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).build()).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        return run.getContent();
    }

    public void getFile(String remotePath, String localPath) {
        NFileInfo u = this.getFileInfo(remotePath);
        if (u != null) {
            switch (NUtils.firstNonNull(u.getPathType(), NPathType.NOT_FOUND)) {
                case DIRECTORY: {
                    NPath.of(localPath).mkdirs();
                    for (String s : this.listNames(u.getPath())) {
                        this.getFile(NStringUtils.pjoin("/", u.getPath(), s), NStringUtils.pjoin("/", localPath, s));
                    }
                    break;
                }
                case FILE: {
                    NPath.of(localPath).mkParentDirs().copyFromInputStreamProvider(this.getFile(remotePath), new NPathOption[0]);
                }
            }
        }
    }

    public void putFile(String localPath, String remotePath) {
        NPath fromPathObj = NPath.of(localPath);
        NPath toPathObj = NPath.of(remotePath);
        if (!fromPathObj.isDirectory()) {
            ArrayList directories = new ArrayList();
            fromPathObj.walk().filter(x -> x.isDirectory()).forEach(x -> {
                boolean found = false;
                for (NPath directory : directories) {
                    if (!x.isEqOrDeepChildOf(directory)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    directories.add(x);
                }
            });
            for (NPath directory : directories) {
                NPath v = this.translate(directory, fromPathObj, toPathObj);
                v.mkdirs();
            }
            fromPathObj.walk().filter(x -> x.isRegularFile()).forEach(x -> {
                NPath toStr = this.translate((NPath)x, fromPathObj, toPathObj);
                NWebCli.of().POST(this.resolveUrl("put-file")).addFormData("content", x.toString()).addFormData("path", toStr.toString()).doWith(this::prepareSecurity).run().getContent();
            });
        } else if (fromPathObj.isRegularFile()) {
            NWebCli.of().POST(this.resolveUrl("put-file")).addFormData("content", fromPathObj.toString()).addFormData("path", toPathObj.toString()).doWith(this::prepareSecurity).run().getContent();
        }
    }

    private NPath translate(NPath fromBase, NPath toBase, NPath fromPath) {
        String u = fromPath.toRelative(fromBase).get();
        NPath v = toBase.resolve(u);
        return v;
    }

    public void putFile(NInputContentProvider localPath, String remotePath) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("put-file")).addFormData("content", localPath).addFormData("path", remotePath).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        run.getContent();
    }

    private void rethrowError(NWebResponse run) {
        NHttpCode statusCode = run.getCode();
        if (statusCode.getCode() >= 400) {
            String appError = run.getHeader("X-APP-ERROR").orNull();
            NMsgCode code = null;
            try {
                Map parsedMap;
                if (!NBlankable.isBlank(appError)) {
                    appError = new String(Base64.getDecoder().decode(appError), "UTF-8");
                }
                if (appError != null && (parsedMap = NElementParser.ofJson().parse(appError, Map.class)) != null) {
                    List params = (List)parsedMap.get("params");
                    code = NMsgCode.ofMessage((String)parsedMap.get("message"), (String)parsedMap.get("code"), params == null ? new String[]{} : params.toArray(new String[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (code == null && !NBlankable.isBlank(appError)) {
                code = NMsgCode.ofMessage(appError, "error", new String[0]);
            }
            if (code != null) {
                throw new NWebResponseException(NMsg.ofC("%s", code.getMessage()), code, statusCode);
            }
            throw new NWebResponseException(NMsg.ofC("%s", "unexpected error"), NMsgCode.ofMessage("unexpected error", "ERROR", new String[0]), statusCode);
        }
    }

    public boolean ensureConnectedSafely() {
        if (this.isValidAccessToken()) {
            if (this.isWarningRefreshToken()) {
                try {
                    this.refreshToken();
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        if (this.isValidRefreshToken()) {
            try {
                this.refreshToken();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.login(this.connectionString.getUserName(), this.connectionString.getPassword());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RnshHttpClient ensureConnected() {
        if (this.isValidAccessToken()) {
            if (this.isWarningRefreshToken()) {
                try {
                    this.refreshToken();
                    return this;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this;
        }
        if (this.isValidRefreshToken()) {
            try {
                this.refreshToken();
                return this;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.login(this.connectionString.getUserName(), this.connectionString.getPassword());
        return this;
    }

    private NConnectionString toSafeConnectionString(NConnectionString connectionString) {
        if (connectionString == null) {
            return new DefaultNConnectionString();
        }
        return connectionString.builder().setPassword("***").build();
    }

    public boolean isValidAccessToken() {
        return this.loginResult != null && this.loginResult.accessToken != null && this.loginResult.accessTokenLastValidityTime != 0L && new Date(this.loginResult.accessTokenLastValidityTime - (long)this.accessTokenSafePeriod).compareTo(new Date()) >= 0;
    }

    public boolean isWarningRefreshToken() {
        Date now;
        return this.loginResult != null && this.loginResult.refreshToken != null && this.loginResult.refreshTokenLastValidityTime != 0L && new Date(this.loginResult.refreshTokenLastValidityTime - (long)this.accessTokenSafePeriod).compareTo(now = new Date()) >= 0 && new Date(this.loginResult.refreshTokenLastValidityTime - (long)this.refreshTokenSafePeriod).compareTo(now) < 0;
    }

    public boolean isValidRefreshToken() {
        return this.loginResult != null && this.loginResult.refreshToken != null && this.loginResult.refreshTokenLastValidityTime != 0L && new Date(this.loginResult.refreshTokenLastValidityTime - (long)this.accessTokenSafePeriod).compareTo(new Date()) >= 0;
    }

    private void refreshToken(String refreshToken) {
        if (NBlankable.isBlank(refreshToken)) {
            throw new NIllegalArgumentException(NMsg.ofC("missing refresh token"));
        }
        NWebResponse response = NWebCli.of().POST(this.resolveUrl("refresh-token")).setJsonRequestBody(NMapBuilder.ofLinked().put("token", this.loginResult.refreshToken).build()).run();
        if (response.isOk()) {
            LoginResult rr = response.getContentAsJson(LoginResult.class);
            if (rr != null && !NBlankable.isBlank(rr.accessToken)) {
                this.loginResult = rr;
                return;
            }
        } else {
            throw new NIllegalArgumentException(NMsg.ofC("unable to login to %s", this.toSafeConnectionString(this.resolveConnectionString())));
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to login to %s", this.toSafeConnectionString(this.resolveConnectionString())));
    }

    private void refreshToken() {
        if (this.loginResult == null || NBlankable.isBlank(this.loginResult.refreshToken) || this.loginResult.refreshTokenLastValidityTime == 0L || new Date(this.loginResult.accessTokenLastValidityTime).compareTo(new Date()) <= 0) {
            throw new NIllegalArgumentException(NMsg.ofC("missing refresh token"));
        }
        this.refreshToken(this.loginResult.refreshToken);
    }

    public void login(String login, String password) {
        NWebResponse response = NWebCli.of().POST(this.resolveUrl("login")).setJsonRequestBody(NMapBuilder.ofLinked().put("userName", login).put("password", password).build()).run();
        if (response.isOk()) {
            LoginResult rr = response.getContentAsJson(LoginResult.class);
            if (rr != null && !NBlankable.isBlank(rr.accessToken)) {
                this.loginResult = rr;
                return;
            }
        } else {
            throw new NIllegalArgumentException(NMsg.ofC("unable to login to %s", this.toSafeConnectionString(this.resolveConnectionString())));
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to login to %s", this.toSafeConnectionString(this.resolveConnectionString())));
    }

    private void prepareSecurity(NWebRequest r) {
        if (this.loginResult != null && !NBlankable.isBlank(this.loginResult.accessToken) && !NBlankable.isBlank(this.loginResult.accessToken)) {
            r.setAuthorizationBearer(this.loginResult.accessToken);
        }
    }

    private NConnectionString resolveConnectionString() {
        LinkedHashMap<String, List<String>> qm;
        String context;
        NConnectionStringBuilder c;
        NConnectionStringBuilder nConnectionStringBuilder = c = this.connectionString == null ? new DefaultNConnectionStringBuilder() : this.connectionString.builder();
        if (NBlankable.isBlank(c.getHost())) {
            c.setHost("localhost");
        }
        if (NBlankable.isBlank(c.getPort())) {
            c.setPort("8899");
        }
        if (NBlankable.isBlank(context = (String)NOptional.ofFirst((Collection)(qm = new LinkedHashMap<String, List<String>>(c.getQueryMap().orElse(new HashMap()))).get(CONTEXT_PATH_PARAM)).orElse(null))) {
            qm.put(CONTEXT_PATH_PARAM, new ArrayList<String>(Arrays.asList("/")));
        } else {
            qm.put(CONTEXT_PATH_PARAM, new ArrayList<String>(Arrays.asList(context)));
        }
        c.setQueryMap(qm);
        return c.build();
    }

    private String resolveUrl(String extra) {
        NConnectionString c = this.resolveConnectionString();
        DefaultNConnectionStringBuilder c2 = new DefaultNConnectionStringBuilder();
        String context = NOptional.ofFirst((Collection)((Map)c.getQueryMap().orElse(new HashMap())).get(CONTEXT_PATH_PARAM)).orElse("/");
        c2.setProtocol("https");
        switch (c.getProtocol()) {
            case "rnsh": 
            case "rnsh-http": {
                c2.setProtocol("http");
                break;
            }
            case "rnshs": 
            case "rnsh-https": {
                c2.setProtocol("https");
            }
        }
        c2.setHost(c.getHost());
        c2.setPort(c.getPort());
        c2.setPath(NStringUtils.pjoin("/", context, extra));
        return c2.toString();
    }

    public ExecResult exec(String ... command) {
        return this.exec(command, (NInputContentProvider)null);
    }

    public ExecResult exec(String[] command, NInputContentProvider inputSource) {
        if (NBlankable.isBlank(command)) {
            return new ExecResult(254, NInputSource.of(NInputSource.of(new byte[0])), NInputSource.of(NI18n.of("missing command").getBytes()));
        }
        String cmdString = command.length == 1 ? command[0] : NCmdLine.of(command).toString();
        NWebResponse r = NWebCli.of().POST(this.resolveUrl("exec")).setFormData("command", cmdString).setFormData(inputSource == null ? null : "in", inputSource).doWith(this::prepareSecurity).run();
        this.rethrowError(r);
        NInputSource content = r.getContent();
        return new ExecResult(r.getHeader("X-EXEC-CODE").flatMap(x -> NLiteral.of(x).asInt()).orElse(0), content, NInputSource.of(NInputSource.of(new byte[0])));
    }

    public NFileInfo getFileInfo(String remotePath) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("file-info")).doWith(this::prepareSecurity).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).build()).run();
        this.rethrowError(run);
        return run.getContentAsJson(NFileInfo.class);
    }

    public String[] listNames(String remotePath) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("directory-list-names")).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).build()).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        return run.getContentAsJson(String[].class);
    }

    public String digest(String remotePath, String algo) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("file-digest")).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).put("algo", algo).build()).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        Map path = run.getContentAsJson(Map.class);
        return path == null ? null : (String)path.get("hash");
    }

    public List<NPathChildStringDigestInfo> directoryListDigest(String remotePath, String algo) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("directory-list-digest")).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).put("algo", algo).build()).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        Map[] res = run.getContentAsJson(Map[].class);
        if (res == null) {
            return new ArrayList<NPathChildStringDigestInfo>();
        }
        return Arrays.stream(res).map(x -> new NPathChildStringDigestInfo().setName((String)x.get("name")).setDigest((String)x.get("digest"))).collect(Collectors.toList());
    }

    public NFileInfo[] listFileInfos(String remotePath) {
        NWebResponse run = NWebCli.of().POST(this.resolveUrl("directory-list-infos")).setJsonRequestBody(NMapBuilder.ofLinked().put("path", remotePath).build()).doWith(this::prepareSecurity).run();
        this.rethrowError(run);
        return run.getContentAsJson(NFileInfo[].class);
    }

    public static class NFileInfo {
        private String path;
        private long contentLength;
        private String contentType;
        private NPathType pathType;
        private int directoryChildrenCount;

        public int getDirectoryChildrenCount() {
            return this.directoryChildrenCount;
        }

        public NFileInfo setDirectoryChildrenCount(int directoryChildrenCount) {
            this.directoryChildrenCount = directoryChildrenCount;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public NFileInfo setPath(String path) {
            this.path = path;
            return this;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public NFileInfo setContentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public String getContentType() {
            return this.contentType;
        }

        public NFileInfo setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public NPathType getPathType() {
            return this.pathType;
        }

        public NFileInfo setPathType(NPathType pathType) {
            this.pathType = pathType;
            return this;
        }
    }

    public static class LoginResult {
        public String userId;
        public String userName;
        public String accessToken;
        public String refreshToken;
        public long accessTokenLastValidityTime;
        public long refreshTokenLastValidityTime;
    }

    public static class ExecResult {
        private int code;
        private NInputSource out;
        private NInputSource err;

        public ExecResult(int code, NInputSource out, NInputSource err) {
            this.code = code;
            this.out = out;
            this.err = err;
        }

        public int getCode() {
            return this.code;
        }

        public NInputSource getOut() {
            return this.out;
        }

        public NInputSource getErr() {
            return this.err;
        }
    }
}

