/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.rnsh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.net.DefaultNConnectionStringBuilder;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.net.NConnectionStringBuilder;
import net.thevpc.nuts.runtime.standalone.xtra.rnsh.RnshHttpClient;
import net.thevpc.nuts.spi.NExecTargetCommandContext;
import net.thevpc.nuts.spi.NExecTargetInfoContext;
import net.thevpc.nuts.spi.NExecTargetInfoRunner;
import net.thevpc.nuts.spi.NExecTargetSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class RnshExecTargetSPI
implements NExecTargetSPI {
    private Map<NConnectionString, RnshHttpClient> clients = new HashMap<NConnectionString, RnshHttpClient>();

    @Override
    public NExecTargetInfo getTargetInfo(NExecTargetInfoContext context) {
        return context.createDefaultTargetInfo(new NExecTargetInfoRunner(){

            @Override
            public String run(String command, NConnectionString connectionString) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                int x = RnshExecTargetSPI.this.exec(connectionString, new String[]{command}, true, NullInputStream.INSTANCE, out, err);
                return out.toString();
            }
        });
    }

    @Override
    public int exec(NExecTargetCommandContext context) {
        return this.exec(context.getConnectionString(), context.getCommand(), context.isRawCommand(), context.in(), context.out(), context.err());
    }

    public int exec(NConnectionString connectionString, String[] command, boolean rawCommand, InputStream in, OutputStream out0, OutputStream err) {
        InputStream ins;
        if (command.length == 0) {
            throw new NIllegalArgumentException(NMsg.ofC("missing arguments"));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int av;
            while ((av = in.available()) > 0) {
                byte[] b = new byte[av];
                int a = in.read(b);
                out.write(b, 0, a);
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        RnshHttpClient.ExecResult is = this.resolveRnshHttpClient(connectionString).ensureConnected().exec(command, NInputSource.of(new ByteArrayInputStream(out.toByteArray()), (NContentMetadata)new DefaultNContentMetadata().setName("in").setContentType("octet-stream")));
        try {
            ins = is.getOut().getInputStream();
            try {
                NIOUtils.copy(ins, out);
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        try {
            ins = is.getErr().getInputStream();
            try {
                NIOUtils.copy(ins, err);
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return is.getCode();
    }

    private RnshHttpClient resolveRnshHttpClient(NConnectionString cnx) {
        HashMap<String, List<String>> qm2;
        NConnectionStringBuilder cb = cnx.builder();
        String v = NStringUtils.trimToNull(cb.getPath());
        Map qm = cb.getQueryMap().orElse(new HashMap());
        String context = NOptional.ofFirst((Collection)qm.get("context")).orElse(null);
        if (NBlankable.isBlank(context)) {
            qm2 = new HashMap<String, List<String>>(qm);
            qm2.put("context", new ArrayList<String>(Arrays.asList(NStringUtils.firstNonBlank(v, "/"))));
            cb.setQueryMap(qm2);
            cb.setPath("/");
        } else {
            qm2 = new HashMap(qm);
            qm2.put("context", new ArrayList<String>(Arrays.asList(NStringUtils.firstNonBlank(context, v))));
            cb.setQueryMap(qm2);
            cb.setPath("/");
        }
        NConnectionString c00 = cb.build();
        RnshHttpClient client = this.clients.get(c00);
        if (client == null) {
            client = new RnshHttpClient().setConnectionString(c00);
            this.clients.put(c00, client);
        }
        return client;
    }

    @Override
    public int getScore(NScorableContext context) {
        Object z;
        Object c = context.getCriteria();
        if (c instanceof String && (z = DefaultNConnectionStringBuilder.of((String)c).orNull()) != null && this.isSupportedProtocol(z.getProtocol())) {
            return 10;
        }
        if (c instanceof NConnectionStringBuilder && this.isSupportedProtocol((z = (NConnectionStringBuilder)c).getProtocol())) {
            return 10;
        }
        if (c instanceof NConnectionString && this.isSupportedProtocol((z = (NConnectionString)c).getProtocol())) {
            return 10;
        }
        return -1;
    }

    private boolean isSupportedProtocol(String protocol) {
        return "rnsh".equals(protocol) || "rnsh-http".equals(protocol) || "rnsh-https".equals(protocol) || "rnshs".equals(protocol);
    }
}

