/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.io.NpsStatus;
import net.thevpc.nuts.io.NpsType;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNPsInfoBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class WindowsPs1Parser {
    public NStream<NPsInfo> parse(Reader reader) {
        final BufferedReader br = new BufferedReader(reader);
        return NStream.ofIterator(new Iterator<NPsInfo>(){
            NPsInfo last = null;

            @Override
            public boolean hasNext() {
                this.last = WindowsPs1Parser.this.readNext(br);
                return this.last != null;
            }

            @Override
            public NPsInfo next() {
                return this.last;
            }
        });
    }

    private String[] readLine(BufferedReader r) {
        String line = null;
        try {
            line = r.readLine();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        if (line == null) {
            return null;
        }
        String normalized = this.normalizeLine(line).trim();
        return new String[]{normalized, line};
    }

    private NPsInfo readNext(BufferedReader r) {
        String[] unsafeLine;
        DefaultNPsInfoBuilder v = new DefaultNPsInfoBuilder();
        boolean empty = true;
        while ((unsafeLine = this.readLine(r)) != null) {
            String line = unsafeLine[0];
            if (NBlankable.isBlank(line) && !empty) {
                return this._build(v);
            }
            int x = line.indexOf(":");
            if (x <= 0) continue;
            String key = line.substring(0, x).trim();
            String value = line.substring(x + 1).trim();
            switch (key) {
                case "VSZ": {
                    v.setVirtualMemorySize(NLiteral.of(value).asLong().orElse(0L));
                    empty = false;
                    break;
                }
                case "RSS": {
                    v.setResidentSetSize(NLiteral.of(value).asLong().orElse(0L));
                    empty = false;
                    break;
                }
                case "PID": {
                    v.setId(value);
                    empty = false;
                    break;
                }
                case "TIME": {
                    String normalized = value.replace(',', '.');
                    BigDecimal seconds = new BigDecimal(normalized);
                    long millis = seconds.multiply(BigDecimal.valueOf(1000L)).longValueExact();
                    v.setTime(millis);
                    empty = false;
                    break;
                }
                case "STAT": {
                    switch (NStringUtils.trim(value).toLowerCase()) {
                        case "suspended": {
                            v.setStatus(NpsStatus.SUSPENDED);
                            break;
                        }
                        case "sleeping": {
                            v.setStatus(NpsStatus.WAITING_FOR_EVENT);
                            break;
                        }
                        case "running": {
                            v.setStatus(NpsStatus.RUNNING);
                            break;
                        }
                        case "idle": {
                            v.setStatus(NpsStatus.IDLE);
                            break;
                        }
                        default: {
                            v.setStatus(NpsStatus.UNKNOWN);
                        }
                    }
                    empty = false;
                    break;
                }
                case "MEM": {
                    v.setPercentMem(NLiteral.of(value.replace(",", ".")).asDouble().orElse(0.0));
                    empty = false;
                    break;
                }
                case "USER": {
                    v.setUser(value);
                    empty = false;
                    break;
                }
                case "TTY": {
                    if ("N/A".equals(value)) {
                        // empty if block
                    }
                    empty = false;
                    break;
                }
                case "START": {
                    if (!"N/A".equals(value)) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
                        LocalDateTime localDateTime = LocalDateTime.parse(value, formatter);
                        v.setStartTime(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                    }
                    empty = false;
                    break;
                }
                case "COMMAND": {
                    StringBuilder sb = new StringBuilder();
                    sb.append(value);
                    while ((unsafeLine = this.readLine(r)) != null && !NBlankable.isBlank(line = unsafeLine[0])) {
                        sb.append(line);
                    }
                    this.setCommand(v, sb.toString());
                    empty = false;
                    break;
                }
            }
        }
        if (empty) {
            return null;
        }
        return this._build(v);
    }

    private NPsInfo _build(DefaultNPsInfoBuilder v) {
        v.setType(NpsType.PROCESS);
        return v.build();
    }

    private void setCommand(DefaultNPsInfoBuilder v, String line) {
        block11: {
            v.setCmdLine(line);
            NCmdLines nCmdLines = NCmdLines.of().setShellFamily(NShellFamily.WIN_CMD).setLenient(true);
            try {
                v.setCmdLineArgs(nCmdLines.parseCmdLine(line).map(NCmdLine::toStringArray).orElse(null));
            }
            catch (Exception ex) {
                if (line.indexOf("\"\"") < 0) break block11;
                line = line.replace("\"\"", "\"");
                try {
                    v.setCmdLineArgs(nCmdLines.parseCmdLine(line).map(NCmdLine::toStringArray).orElse(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (v.getCmdLineArgs() != null && v.getCmdLineArgs().length > 0) {
            String[] a = v.getCmdLineArgs();
            if (a.length > 0) {
                int x = Math.max(a[0].lastIndexOf("/"), a[0].lastIndexOf("\\"));
                if (x >= 0) {
                    v.setName(NStringUtils.trimToNull(a[0].substring(x + 1)));
                } else {
                    v.setName(NStringUtils.trimToNull(a[0]));
                }
            }
        } else {
            int x = Math.max(v.getCmdLine().lastIndexOf("/"), v.getCmdLine().lastIndexOf("\\"));
            if (x >= 0) {
                v.setName(NStringUtils.trimToNull(v.getCmdLine().substring(x + 1)));
            } else {
                v.setName(NStringUtils.trimToNull(v.getCmdLine()));
            }
        }
    }

    private String normalizeLine(String line) {
        String line0 = line;
        if ((line = line.trim()).isEmpty()) {
            return "";
        }
        line = line.replaceAll("\\p{C}", "");
        line = line.replaceAll("\\s+", " ");
        StringBuilder sb = new StringBuilder();
        for (char c : line.toCharArray()) {
            if (c == '\u0000') continue;
            sb.append(c);
        }
        String ss = sb.toString();
        int v = 0;
        for (char c : ss.toCharArray()) {
            if (c != ':') continue;
            ++v;
        }
        if (v >= 2) {
            // empty if block
        }
        return ss;
    }
}

