/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.io.NpsStatus;
import net.thevpc.nuts.io.NpsType;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNPsInfo;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPsInfoBuilder
implements NBlankable {
    private String id;
    private String name;
    private String user;
    private String title;
    private String cmdLine;
    private double percentCpu;
    private double percentMem;
    private long virtualMemorySize;
    private long residentSetSize;
    private String terminal;
    private String[] cmdLineArgs;
    private Instant startTime;
    private long time;
    private NpsStatus status;
    private NpsType type;
    private Set<String> statusFlags;

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.id)) {
            return false;
        }
        if (!NBlankable.isBlank(this.name)) {
            return false;
        }
        if (!NBlankable.isBlank(this.user)) {
            return false;
        }
        if (!NBlankable.isBlank(this.title)) {
            return false;
        }
        if (!NBlankable.isBlank(this.cmdLine)) {
            return false;
        }
        if (this.percentCpu != 0.0) {
            return false;
        }
        if (this.percentMem != 0.0) {
            return false;
        }
        if (this.residentSetSize != 0L) {
            return false;
        }
        if (this.virtualMemorySize != 0L) {
            return false;
        }
        if (this.time != 0L) {
            return false;
        }
        if (!NBlankable.isBlank(this.terminal)) {
            return false;
        }
        if (this.cmdLineArgs != null) {
            return false;
        }
        if (this.startTime != null) {
            return false;
        }
        if (this.status != null) {
            return false;
        }
        if (this.type != null) {
            return false;
        }
        return this.statusFlags == null;
    }

    public String getPid() {
        return this.id;
    }

    public NpsType getType() {
        return this.type;
    }

    public DefaultNPsInfoBuilder setType(NpsType type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCmdLine() {
        return this.cmdLine;
    }

    public String[] getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public String getId() {
        return this.id;
    }

    public NpsStatus getStatus() {
        return this.status;
    }

    public DefaultNPsInfoBuilder setStatus(NpsStatus status) {
        this.status = status;
        return this;
    }

    public Set<String> getStatusFlags() {
        return this.statusFlags;
    }

    public DefaultNPsInfoBuilder setStatusFlags(Set<String> statusFlags) {
        this.statusFlags = statusFlags;
        return this;
    }

    public DefaultNPsInfoBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public DefaultNPsInfoBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public DefaultNPsInfoBuilder setUser(String user) {
        this.user = user;
        return this;
    }

    public DefaultNPsInfoBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public DefaultNPsInfoBuilder setCmdLine(String cmdLine) {
        this.cmdLine = cmdLine;
        return this;
    }

    public double getPercentCpu() {
        return this.percentCpu;
    }

    public DefaultNPsInfoBuilder setPercentCpu(double percentCpu) {
        this.percentCpu = percentCpu;
        return this;
    }

    public double getPercentMem() {
        return this.percentMem;
    }

    public DefaultNPsInfoBuilder setPercentMem(double percentMem) {
        this.percentMem = percentMem;
        return this;
    }

    public long getVirtualMemorySize() {
        return this.virtualMemorySize;
    }

    public DefaultNPsInfoBuilder setVirtualMemorySize(long virtualMemorySize) {
        this.virtualMemorySize = virtualMemorySize;
        return this;
    }

    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    public DefaultNPsInfoBuilder setResidentSetSize(long residentSetSize) {
        this.residentSetSize = residentSetSize;
        return this;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public DefaultNPsInfoBuilder setTerminal(String terminal) {
        this.terminal = terminal;
        return this;
    }

    public DefaultNPsInfoBuilder setCmdLineArgs(String[] cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
        return this;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public DefaultNPsInfoBuilder setStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTime() {
        return this.time;
    }

    public DefaultNPsInfoBuilder setTime(long time) {
        this.time = time;
        return this;
    }

    public NPsInfo build() {
        return new DefaultNPsInfo(this.id, NStringUtils.trimToNull(this.name), this.user, this.title, this.cmdLine, this.cmdLineArgs, this.status == null ? NpsStatus.UNKNOWN : this.status, this.type == null ? NpsType.UNKNOWN : this.type, this.statusFlags == null ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet(this.statusFlags.stream().filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet()))), this.percentCpu, this.percentMem, this.virtualMemorySize, this.residentSetSize, this.terminal, this.startTime, this.time);
    }

    public String toString() {
        return "DefaultNPsInfoBuilder{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", user='" + this.user + '\'' + ", title='" + this.title + '\'' + ", cmdLine='" + this.cmdLine + '\'' + ", percentCpu=" + this.percentCpu + ", percentMem=" + this.percentMem + ", virtualMemorySize=" + this.virtualMemorySize + ", residentSetSize=" + this.residentSetSize + ", terminal='" + this.terminal + '\'' + ", cmdLineArgs=" + Arrays.toString(this.cmdLineArgs) + ", startTime=" + this.startTime + ", time=" + this.time + ", status=" + this.status + ", flags=" + this.statusFlags + '}';
    }
}

