/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.io.NpsStatus;
import net.thevpc.nuts.io.NpsType;
import net.thevpc.nuts.util.NLiteral;

public class DefaultNPsInfo
implements NPsInfo {
    private String id;
    private String name;
    private String user;
    private String title;
    private String cmdLine;
    private NpsStatus status;
    private Set<String> statusFlags;
    private double percentCpu;
    private double percentMem;
    private long virtualMemorySize;
    private long residentSetSize;
    private String terminal;
    private String[] cmdLineArgs;
    private Instant startTime;
    private long time;
    private NpsType type;

    public DefaultNPsInfo(String id, String name, String user, String title, String cmdLine, String[] cmdLineArgs, NpsStatus status, NpsType type, Set<String> statusFlags, double percentCpu, double percentMem, long virtualMemorySize, long residentSetSize, String terminal, Instant startTime, long time) {
        this.id = id;
        this.name = name;
        this.user = user;
        this.title = title;
        this.cmdLine = cmdLine;
        this.percentCpu = percentCpu;
        this.percentMem = percentMem;
        this.virtualMemorySize = virtualMemorySize;
        this.residentSetSize = residentSetSize;
        this.terminal = terminal;
        this.cmdLineArgs = cmdLineArgs;
        this.startTime = startTime;
        this.time = time;
        this.status = status;
        this.statusFlags = statusFlags;
        this.type = type;
    }

    @Override
    public NpsType getType() {
        return this.type;
    }

    @Override
    public NpsStatus getStatus() {
        return this.status;
    }

    @Override
    public Set<String> getStatusFlags() {
        return this.statusFlags;
    }

    @Override
    public String getPid() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getCmdLine() {
        return this.cmdLine;
    }

    @Override
    public String[] getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public double getPercentCpu() {
        return this.percentCpu;
    }

    @Override
    public double getPercentMem() {
        return this.percentMem;
    }

    @Override
    public long getVirtualMemorySize() {
        return this.virtualMemorySize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public String getTerminal() {
        return this.terminal;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public String toString() {
        return "NPsInfo{id=" + NLiteral.of(this.id).toStringLiteral() + ", name=" + NLiteral.of(this.name).toStringLiteral() + ", user=" + NLiteral.of(this.user).toStringLiteral() + ", title=" + NLiteral.of(this.title).toStringLiteral() + ", cmdLine=" + NLiteral.of(this.cmdLine).toStringLiteral() + ", type=" + this.type + ", status=" + this.status + ", flags=" + this.statusFlags + ", percentCpu=" + this.percentCpu + ", percentMem=" + this.percentMem + ", virtualMemorySize=" + this.virtualMemorySize + ", residentSetSize=" + this.residentSetSize + ", terminal=" + NLiteral.of(this.terminal).toStringLiteral() + ", cmdLineArgs=" + Arrays.toString(this.cmdLineArgs) + ", startTime=" + this.startTime + ", time=" + this.time + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNPsInfo that = (DefaultNPsInfo)o;
        return Double.compare(this.percentCpu, that.percentCpu) == 0 && Double.compare(this.percentMem, that.percentMem) == 0 && this.virtualMemorySize == that.virtualMemorySize && this.residentSetSize == that.residentSetSize && this.time == that.time && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.user, that.user) && Objects.equals(this.title, that.title) && Objects.equals(this.cmdLine, that.cmdLine) && this.status == that.status && Objects.equals(this.statusFlags, that.statusFlags) && Objects.equals(this.terminal, that.terminal) && Objects.deepEquals(this.cmdLineArgs, that.cmdLineArgs) && Objects.equals(this.startTime, that.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.user, this.title, this.cmdLine, this.status, this.statusFlags, this.percentCpu, this.percentMem, this.virtualMemorySize, this.residentSetSize, this.terminal, Arrays.hashCode(this.cmdLineArgs), this.startTime, this.time);
    }
}

