/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBFieldIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForBean;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForNullable;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.util.NBlankable;

public class NanoDBTableDefinitionBuilderFromBean<T> {
    private final NanoDB db;
    private final Class<T> cls;
    private boolean addAllFields;
    private Map<String, Field> currFields;
    private final Set<String> serializedFields = new LinkedHashSet<String>();
    private final Set<String> indexFields = new LinkedHashSet<String>();
    private boolean nullable = true;
    private String name;

    public NanoDBTableDefinitionBuilderFromBean(Class<T> cls, NanoDB db) {
        this.cls = cls;
        this.db = db;
    }

    private Map<String, Field> getCurrFields() {
        if (this.currFields == null) {
            LinkedHashMap<String, Field> currFields = new LinkedHashMap<String, Field>();
            for (Class<T> cc = this.cls; cc != null && cc != Object.class; cc = cc.getSuperclass()) {
                for (Field f : cc.getDeclaredFields()) {
                    int m;
                    if (currFields.containsKey(f.getName()) || Modifier.isFinal(m = f.getModifiers()) || Modifier.isStatic(m) || Modifier.isTransient(m)) continue;
                    f.setAccessible(true);
                    currFields.put(f.getName(), f);
                }
            }
            this.currFields = currFields;
        }
        return this.currFields;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public NanoDBTableDefinitionBuilderFromBean<T> setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public NanoDBTableDefinitionBuilderFromBean<T> addIndices(String ... fields) {
        this.indexFields.addAll(Arrays.asList(fields));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NanoDBTableDefinitionBuilderFromBean<T> setName(String name) {
        this.name = name;
        return this;
    }

    public NanoDBTableStore<T> getOrCreate() {
        NanoDBTableStore t;
        String name = this.name;
        if (NBlankable.isBlank(name)) {
            name = this.cls.getSimpleName();
        }
        if ((t = this.db.findTable(name)) != null) {
            return t;
        }
        return this.create();
    }

    public NanoDBTableStore<T> create() {
        NanoDBTableDefinition<T> t = this.build();
        return this.db.createTable(t);
    }

    public NanoDBTableDefinition<T> build() {
        String name;
        Map<String, Field> currFields = this.getCurrFields();
        LinkedHashSet<String> serializedFields = new LinkedHashSet<String>();
        serializedFields.addAll(this.serializedFields);
        if (this.addAllFields || serializedFields.isEmpty()) {
            serializedFields.addAll(currFields.keySet());
        }
        if (NBlankable.isBlank(name = this.name)) {
            name = this.cls.getSimpleName();
        }
        NanoDBSerializerForBean<T> s = new NanoDBSerializerForBean<T>(this.cls, this.db.getSerializers(), serializedFields);
        ArrayList defs = new ArrayList();
        for (String field : this.indexFields) {
            if (!currFields.containsKey(field)) continue;
            Field f = currFields.get(field);
            defs.add(new NanoDBFieldIndexDefinition(f));
        }
        return new NanoDBTableDefinition<T>(name, this.cls, this.nullable ? new NanoDBSerializerForNullable<T>(s) : s, defs.toArray(new NanoDBIndexDefinition[0]));
    }

    public NanoDBTableDefinitionBuilderFromBean<T> addAllFields() {
        this.addAllFields = true;
        return this;
    }
}

