/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.time.Instant;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBNonNullSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;

class NanoDBSerializerForInstant
extends NanoDBNonNullSerializer<Instant> {
    public NanoDBSerializerForInstant() {
        super(Instant.class);
    }

    @Override
    public void write(Instant obj, NanoDBOutputStream out) {
        out.writeLong(obj.getEpochSecond());
        out.writeLong(obj.getNano());
    }

    @Override
    public Instant read(NanoDBInputStream in, Class expectedType) {
        long epochSecond = in.readLong();
        long nanoAdjustment = in.readLong();
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }
}

