/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBNonNullSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializers;

public class NanoDBSerializerForBean<T>
extends NanoDBNonNullSerializer<T> {
    private LinkedHashMap<String, FieldInfo> fields;
    private NanoDBSerializers serializers;
    private Set<String> acceptedFields;

    public NanoDBSerializerForBean(Class<T> type, NanoDBSerializers serializers, Set<String> acceptedFields) {
        super(type);
        this.serializers = serializers;
        this.acceptedFields = acceptedFields == null ? Collections.emptySet() : acceptedFields;
        this.fields = NanoDBSerializerForBean.buildFields(type, acceptedFields, serializers);
    }

    @Override
    public void write(T obj, NanoDBOutputStream out) {
        NanoDBSerializerForBean.writeNonNullHelper(obj, this.getSupportedType(), out, this.fields);
    }

    @Override
    public T read(NanoDBInputStream in, Class expectedType) {
        return NanoDBSerializerForBean.readNonNullHelper(in, this.getSupportedType(), this.fields);
    }

    private static <T> LinkedHashMap<String, FieldInfo> buildFields(Class<T> type, Set<String> acceptedFields, NanoDBSerializers serializers) {
        acceptedFields = acceptedFields == null ? Collections.emptySet() : acceptedFields;
        LinkedHashMap<String, FieldInfo> fields = new LinkedHashMap<String, FieldInfo>();
        for (Class<Object> c = type; c != null; c = c.getDeclaringClass()) {
            for (Field declaredField : c.getDeclaredFields()) {
                int m;
                String name = declaredField.getName();
                if (!acceptedFields.isEmpty() && !acceptedFields.contains(name) || Modifier.isFinal(m = declaredField.getModifiers()) || Modifier.isStatic(m) || Modifier.isTransient(m)) continue;
                declaredField.setAccessible(true);
                fields.put(name, new FieldInfo(name, declaredField, serializers.of(declaredField.getType(), true)));
            }
        }
        return fields;
    }

    private static <T> void writeNonNullHelper(T obj, Class<T> supportedType, NanoDBOutputStream out, Map<String, FieldInfo> fields) {
        for (FieldInfo value : fields.values()) {
            Object u = null;
            try {
                u = value.field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            value.ser.write(u, out);
        }
    }

    private static <T> T readNonNullHelper(NanoDBInputStream in, Class<T> supportedType, Map<String, FieldInfo> fields) {
        try {
            T newInstance = supportedType.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (FieldInfo value : fields.values()) {
                try {
                    value.field.set(newInstance, value.ser.read(in, value.field.getType()));
                }
                catch (UncheckedIOException | NIOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("error loading field " + supportedType.getSimpleName() + "." + value.name + ": " + ex.getMessage(), ex);
                }
            }
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class FieldInfo {
        String name;
        Field field;
        NanoDBSerializer ser;

        public FieldInfo(String name, Field field, NanoDBSerializer ser) {
            this.name = name;
            this.field = field;
            this.ser = ser;
        }
    }
}

