/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStoreDefaultFactory;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializers;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinitionBuilderFromBean;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.file.NanoDBDefaultIndex;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;

public abstract class AbstractNanoDB
implements NanoDB {
    protected Map<String, NanoDBTableStore> tables = new HashMap<String, NanoDBTableStore>();
    protected NanoDBSerializers serializers = new NanoDBSerializers();

    @Override
    public void flush() {
        for (NanoDBTableStore value : this.tables.values()) {
            value.flush();
        }
    }

    @Override
    public void close() {
        for (NanoDBTableStore value : this.tables.values()) {
            value.close();
        }
    }

    @Override
    public NanoDBSerializers getSerializers() {
        return this.serializers;
    }

    @Override
    public NanoDBTableStore findTable(String name) {
        return this.tables.get(name);
    }

    @Override
    public NanoDBTableStore getTable(String name) {
        NanoDBTableStore tableFile = this.tables.get(name);
        if (tableFile == null) {
            throw new NIllegalArgumentException(NMsg.ofC("table does not exists: %s", name));
        }
        return tableFile;
    }

    @Override
    public <T> NanoDBTableDefinitionBuilderFromBean<T> tableBuilder(Class<T> type) {
        return new NanoDBTableDefinitionBuilderFromBean<T>(type, this);
    }

    @Override
    public <T> NanoDBTableStore<T> createTable(NanoDBTableDefinition<T> def) {
        return this.createTable(def, false);
    }

    @Override
    public <T> NanoDBTableStore<T> getOrCreateTable(NanoDBTableDefinition<T> def) {
        return this.createTable(def, true);
    }

    @Override
    public <T> NanoDBTableStore<T> createTable(NanoDBTableDefinition<T> def, boolean getOrCreate) {
        if (def == null) {
            throw new IllegalArgumentException("null table definition");
        }
        String name = def.getName();
        if (getOrCreate) {
            NanoDBTableStore oldTable = this.tables.get(name);
            if (this.tables.containsKey(name)) {
                return oldTable;
            }
        }
        if (NBlankable.isBlank(name)) {
            throw new IllegalArgumentException("invalid table definition: null name");
        }
        NanoDBSerializer serializer = def.getSerializer();
        Class<T> serSupportedType = serializer != null ? serializer.getSupportedType() : null;
        Class<T> defType = def.getType();
        if (defType == null) {
            defType = serSupportedType;
        }
        if (serSupportedType == null) {
            serSupportedType = defType;
        }
        if (defType == null || serSupportedType == null) {
            throw new IllegalArgumentException("invalid table definition: invalid type");
        }
        if (serializer == null) {
            serializer = this.getSerializers().of(defType, true);
        }
        if (!serSupportedType.isAssignableFrom(defType)) {
            throw new IllegalArgumentException("invalid table definition: invalid type: " + defType.getName() + "; unsupported by a serializer for " + serSupportedType.getName());
        }
        if (this.tables.containsKey(name)) {
            throw new IllegalArgumentException("table already defined: " + name);
        }
        NanoDBIndexDefinition<T>[] indices = def.getIndices();
        if (indices == null) {
            indices = new NanoDBIndexDefinition[]{};
        }
        for (NanoDBIndexDefinition<T> index : indices) {
            if (index != null) continue;
            throw new IllegalArgumentException("invalid table definition: null index");
        }
        NanoDBTableStore<T> f = this.createNanoDBTableStore(def.getType(), name, serializer, indices);
        this.tables.put(name, f);
        return f;
    }

    protected abstract <T> NanoDBTableStore<T> createNanoDBTableStore(Class<T> var1, String var2, NanoDBSerializer<T> var3, NanoDBIndexDefinition<T>[] var4);

    @Override
    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName);
    }

    @Override
    public <T> NanoDBIndex<T> createIndexFor(Class<T> type, NanoDBSerializer<T> ser, File file) {
        return new NanoDBDefaultIndex<T>(type, ser, new DBIndexValueStoreDefaultFactory(), new HashMap(), file);
    }
}

