/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.mon;

import net.thevpc.nuts.time.NProgressHandler;
import net.thevpc.nuts.time.NProgressHandlerEvent;
import net.thevpc.nuts.time.NProgressMonitor;
import net.thevpc.nuts.util.NAssert;

public class ProgressMonitorTranslator
implements NProgressHandler {
    private double start;
    private double factor;
    private NProgressMonitor delegate;

    public ProgressMonitorTranslator(NProgressMonitor baseMonitor, double factor, double start) {
        this.delegate = baseMonitor;
        NAssert.requireNonNull(baseMonitor, "baseMonitor");
        this.factor = factor;
        this.start = start;
    }

    public NProgressMonitor getDelegate() {
        return this.delegate;
    }

    @Override
    public void onEvent(NProgressHandlerEvent event) {
        double translatedProgress;
        double progress = event.getModel().getProgress();
        double d = translatedProgress = Double.isNaN(progress) ? progress : progress * this.factor + this.start;
        if (!Double.isNaN(progress) && (translatedProgress < 0.0 || translatedProgress > 1.0) && translatedProgress > 1.0 && translatedProgress < 1.1) {
            translatedProgress = 1.0;
        }
        this.getDelegate().setProgress(translatedProgress, event.getModel().getMessage());
    }
}

