/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.hashname;

import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NDigestName;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NNames;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNDigestName
implements NDigestName {
    private Object source;
    private String sourceType;

    @Override
    public String getDigestName(Object source) {
        if (source == null) {
            return "default";
        }
        if (source instanceof String) {
            return this.getDigestNameString((String)source);
        }
        if (source instanceof NPath) {
            return this.getDigestNameString(source.toString());
        }
        if (source instanceof NWorkspace) {
            NPath location = ((NWorkspace)source).getLocation();
            if (location == null) {
                return this.getDigestNameString("default");
            }
            return this.getDigestNameString(location.toString());
        }
        if (source instanceof NSession) {
            NPath location = ((NSession)source).getWorkspace().getLocation();
            if (location == null) {
                return this.getDigestNameString("default");
            }
            return this.getDigestNameString(location.toString());
        }
        if (source instanceof Integer) {
            return this.getDigestNameInt((Integer)source);
        }
        return this.getDigestNameInt(source.hashCode());
    }

    private String getDigestNameInt(int source) {
        return NNames.pickName(source, 2, 3, NNameFormat.CLASS_NAME);
    }

    private String getDigestNameString(String source) {
        if (source == null || source.isEmpty()) {
            return "empty";
        }
        return this.getDigestNameInt(source.hashCode());
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

