/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.io.IOException;
import net.thevpc.nuts.io.NCharReader;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagStreamProcessor;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagToken;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagTokenType;

public class TagTokenReader {
    String startTag;
    String endTag;
    String escape;
    NCharReader br;
    TagToken pushBack;
    boolean startOfLine;

    public TagTokenReader(String startTag, String endTag, String escape, NCharReader br) {
        this.startTag = startTag;
        this.endTag = endTag;
        this.escape = escape;
        this.br = br;
    }

    public void pushBack(TagToken t) {
        this.pushBack = t;
    }

    public TagToken peek() {
        if (this.pushBack != null) {
            return this.pushBack;
        }
        TagToken u = this.next();
        this.pushBack(u);
        return u;
    }

    public TagToken next() {
        try {
            if (this.pushBack != null) {
                TagToken c = this.pushBack;
                this.pushBack = null;
                return c;
            }
            StringBuilder plain = new StringBuilder();
            while (true) {
                if (this.br.read(this.escape)) {
                    plain.append(this.startTag);
                    continue;
                }
                if (this.br.peek(this.startTag)) {
                    if (plain.length() > 0) {
                        String t = plain.toString();
                        this.startOfLine = t.endsWith("\n");
                        plain.setLength(0);
                        return new TagToken(TagTokenType.PLAIN, t);
                    }
                    return this.readSpecialToken();
                }
                int rr = this.br.read();
                if (rr < 0) break;
                plain.append((char)rr);
            }
            if (plain.length() == 0) {
                return null;
            }
            String t = plain.toString();
            this.startOfLine = t.endsWith("\n");
            return new TagToken(TagTokenType.PLAIN, t);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TagToken readSpecialToken() throws IOException {
        int c;
        int brackets = 0;
        if (!this.br.read(this.startTag)) {
            throw new IllegalArgumentException("expected " + this.startTag);
        }
        StringBuilderImage buffer = new StringBuilderImage();
        buffer.appendImageOnly(this.startTag);
        boolean end = false;
        block8: while (!end && (c = this.br.peek()) >= 0) {
            block0 : switch (c) {
                case 47: {
                    int cc;
                    if (this.br.read("//")) {
                        buffer.append("//");
                        while ((cc = this.br.read()) >= 0) {
                            if (cc == 10) {
                                buffer.append((char)cc);
                                break block0;
                            }
                            buffer.append((char)cc);
                        }
                        continue block8;
                    }
                    buffer.append((char)c);
                    break;
                }
                case 34: {
                    int cc;
                    buffer.append(this.br.readChar());
                    while ((cc = this.br.read()) >= 0) {
                        if (cc == 34) {
                            buffer.append((char)cc);
                            break block0;
                        }
                        if (cc == 92) {
                            buffer.append((char)cc);
                            cc = this.br.read();
                            if (cc < 0) continue;
                            buffer.append((char)cc);
                            continue;
                        }
                        buffer.append((char)cc);
                    }
                    break;
                }
                case 39: {
                    int cc;
                    buffer.append(this.br.readChar());
                    while ((cc = this.br.read()) >= 0) {
                        if (cc == 39) {
                            buffer.append((char)cc);
                            break block0;
                        }
                        if (cc == 92) {
                            buffer.append((char)cc);
                            cc = this.br.read();
                            if (cc < 0) continue;
                            buffer.append((char)cc);
                            continue;
                        }
                        buffer.append((char)cc);
                    }
                    break;
                }
                case 96: {
                    int cc;
                    buffer.append(this.br.readChar());
                    while ((cc = this.br.read()) >= 0) {
                        if (cc == 96) {
                            buffer.append((char)cc);
                            break block0;
                        }
                        if (cc == 92) {
                            buffer.append((char)cc);
                            cc = this.br.read();
                            if (cc < 0) continue;
                            buffer.append((char)cc);
                            continue;
                        }
                        buffer.append((char)cc);
                    }
                    break;
                }
                case 123: {
                    ++brackets;
                    if (this.isReadEndOfTag(buffer)) {
                        end = true;
                        break;
                    }
                    buffer.append(this.br.readChar());
                    break;
                }
                case 125: {
                    boolean peek = this.br.peek(this.endTag);
                    if (--brackets <= 0) {
                        if (this.isReadEndOfTag(buffer)) {
                            end = true;
                            break;
                        }
                        buffer.append(this.br.readChar());
                        break;
                    }
                    buffer.append(this.br.readChar());
                    break;
                }
                default: {
                    buffer.append(this.br.readChar());
                }
            }
        }
        String ss = buffer.buffer.toString().trim();
        if (ss.startsWith(":")) {
            if (TagStreamProcessor.startsWithWord(ss, ":if")) {
                return new TagToken(TagTokenType.IF, ss.substring(":if".length()).trim());
            }
            if (TagStreamProcessor.startsWithWord(ss, ":else if")) {
                return new TagToken(TagTokenType.CTRL_ELSE_IF, ss.substring(":else if".length()).trim());
            }
            if (TagStreamProcessor.startsWithWord(ss, ":else")) {
                return new TagToken(TagTokenType.CTRL_ELSE, ss.substring(":else".length()).trim());
            }
            if (TagStreamProcessor.startsWithWord(ss, ":for")) {
                return new TagToken(TagTokenType.FOR, ss.substring(":for".length()).trim());
            }
            if (TagStreamProcessor.startsWithWord(ss, ":include")) {
                return new TagToken(TagTokenType.INCLUDE, ss.substring(":include".length()).trim());
            }
            if (TagStreamProcessor.startsWithWord(ss, ":end")) {
                return new TagToken(TagTokenType.CTRL_END, ss.substring(":end".length()).trim());
            }
            if (ss.startsWith("::")) {
                return new TagToken(TagTokenType.STATEMENT, ss.substring(2));
            }
            if (ss.startsWith(":")) {
                return new TagToken(TagTokenType.STATEMENT, ss.substring(1));
            }
            return new TagToken(TagTokenType.CTRL_OTHER, ss);
        }
        return new TagToken(TagTokenType.EXPR, ss);
    }

    private boolean isReadEndOfTag(StringBuilderImage image) {
        try {
            if (this.startOfLine && this.br.read(this.endTag + "\r\n")) {
                image.appendImageOnly(this.endTag + "\r\n");
                return true;
            }
            if (this.startOfLine && this.br.read(this.endTag + "\n")) {
                image.appendImageOnly(this.endTag + "\n");
                return true;
            }
            if (this.br.read(this.endTag)) {
                image.appendImageOnly(this.endTag);
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static class StringBuilderImage {
        StringBuilder buffer = new StringBuilder();
        StringBuilder image = new StringBuilder();

        private StringBuilderImage() {
        }

        public StringBuilderImage append(char c) {
            this.buffer.append(c);
            this.image.append(c);
            return this;
        }

        public StringBuilderImage appendImageOnly(char c) {
            this.image.append(c);
            return this;
        }

        public StringBuilderImage append(String c) {
            this.buffer.append(c);
            this.image.append(c);
            return this;
        }

        public StringBuilderImage appendImageOnly(String c) {
            this.image.append(c);
            return this;
        }
    }
}

