/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.util.ArrayList;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ExpressionTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ForTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.IfTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.IncludeNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ListTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.PlainTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.StatementTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagToken;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagTokenReader;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagTokenType;
import net.thevpc.nuts.util.NBlankable;

public class TagNodeReader {
    private TagTokenReader tr;
    private NExprDeclarations context;

    public TagNodeReader(TagTokenReader tr, NExprDeclarations context) {
        this.tr = tr;
        this.context = context;
    }

    public TagNode next() {
        TagToken t = this.tr.peek();
        if (t == null) {
            return null;
        }
        switch (t.type) {
            case PLAIN: {
                t = this.tr.next();
                return new PlainTagNode(t.value);
            }
            case EXPR: {
                t = this.tr.next();
                return new ExpressionTagNode(this.parseExpression(t.value));
            }
            case STATEMENT: {
                t = this.tr.next();
                return new StatementTagNode(this.parseExpression(t.value));
            }
            case INCLUDE: {
                t = this.tr.next();
                return new IncludeNode(this.parseExpression(t.value));
            }
            case IF: {
                return this._nextCtrlIf();
            }
            case FOR: {
                return this._nextCtrlFor();
            }
        }
        throw new IllegalArgumentException("unexpected token: " + t);
    }

    private NExprNode parseExpression(String s) {
        if (NBlankable.isBlank(s)) {
            return null;
        }
        return this.context.parse(s).get();
    }

    private TagNode _nextCtrlIf() {
        TagToken t2;
        TagToken t = this.tr.next();
        IfTagNode nn = new IfTagNode(this.parseExpression(t.value));
        ArrayList<TagNode> ifBody = new ArrayList<TagNode>();
        while ((t2 = this.tr.peek()) != null) {
            TagToken t3;
            ArrayList<TagNode> all;
            if (t2.type == TagTokenType.CTRL_ELSE_IF) {
                t2 = this.tr.next();
                all = new ArrayList<TagNode>();
                while ((t3 = this.tr.peek()) != null && t3.type != TagTokenType.CTRL_ELSE_IF && t3.type != TagTokenType.CTRL_ELSE && t3.type != TagTokenType.CTRL_END) {
                    all.add(this.next());
                }
                nn.elseIfBranches.add(new IfTagNode.ElseIf(this.parseExpression(t2.value), ListTagNode.of(all)));
                continue;
            }
            if (t2.type == TagTokenType.CTRL_ELSE) {
                t2 = this.tr.next();
                all = new ArrayList();
                while ((t3 = this.tr.peek()) != null && t3.type != TagTokenType.CTRL_END) {
                    all.add(this.next());
                }
                nn.elseExpr = ListTagNode.of(all);
                continue;
            }
            if (t2.type == TagTokenType.CTRL_END) {
                this.tr.next();
                break;
            }
            ifBody.add(this.next());
        }
        nn.elseIfBranches.get((int)0).body = ListTagNode.of(ifBody);
        return nn;
    }

    private TagNode _nextCtrlFor() {
        TagToken t3;
        TagToken t = this.tr.next();
        ForTagNode nn = new ForTagNode(t.value);
        ArrayList<TagNode> all = new ArrayList<TagNode>();
        while ((t3 = this.tr.peek()) != null) {
            if (t3.type == TagTokenType.CTRL_END) {
                this.tr.next();
                break;
            }
            all.add(this.next());
        }
        nn.body = ListTagNode.of(all);
        return nn;
    }
}

