/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.io.NCharReader;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.io.NullReader;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ListTagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagNodeReader;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagStreamProcessor;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagTokenReader;

public class ProcessStreamContext
implements Cloneable {
    TagStreamProcessor tagStreamProcessor;
    TagTokenReader tr;
    TagNodeReader nr;
    NExprDeclarations context;
    Writer out;

    public ProcessStreamContext copy() {
        try {
            return (ProcessStreamContext)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ProcessStreamContext(TagStreamProcessor tagStreamProcessor, InputStream source, NExprDeclarations context) {
        this.context = context;
        this.tagStreamProcessor = tagStreamProcessor;
        this.tr = new TagTokenReader(tagStreamProcessor.startTag, tagStreamProcessor.endTag, tagStreamProcessor.escape, new NCharReader(new InputStreamReader(source == null ? NullInputStream.INSTANCE : source)));
        this.nr = new TagNodeReader(this.tr, context);
    }

    public ProcessStreamContext(TagStreamProcessor tagStreamProcessor, Reader source, NExprDeclarations context) {
        this.context = context;
        this.tagStreamProcessor = tagStreamProcessor;
        this.tr = new TagTokenReader(tagStreamProcessor.startTag, tagStreamProcessor.endTag, tagStreamProcessor.escape, new NCharReader(source == null ? NullReader.INSTANCE : source));
        this.nr = new TagNodeReader(this.tr, context);
    }

    public TagStreamProcessor getStreamProcessor() {
        return this.tagStreamProcessor;
    }

    public TagNode next() throws IOException {
        TagNode u;
        ArrayList<TagNode> r = new ArrayList<TagNode>();
        while ((u = this.nr.next()) != null) {
            r.add(u);
        }
        return ListTagNode.of(r);
    }

    public void setVar(String varName, Object v) {
        this.context.getVar(varName).get().set(v, this.context);
    }

    public Object eval(String expr) {
        return this.context.parse(expr).get().eval(this.context).get();
    }

    public Object eval(NExprNode expr) {
        if (expr == null) {
            return null;
        }
        return expr.eval(this.context).get();
    }
}

