/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import net.thevpc.nuts.expr.NExprCompiledTemplate;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprTemplate;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagStreamProcessor;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NExprDeclarationsTemplateImpl
implements NExprTemplate {
    private String start;
    private String stop;
    private String escape;
    protected TagStreamProcessor processor;
    protected NExprDeclarations declarations;

    public NExprDeclarationsTemplateImpl(NExprDeclarations declarations) {
        this.declarations = declarations;
        this.withMoustacheStyle();
    }

    @Override
    public NExprTemplate withJspStyle() {
        return this.withBoundaries("<%", "%>");
    }

    @Override
    public NExprTemplate withMoustacheStyle() {
        return this.withBoundaries("{{", "}}");
    }

    @Override
    public NExprTemplate withBashStyle() {
        return this.withBoundaries("${", "}");
    }

    @Override
    public NExprTemplate withBoundaries(String start, String stop) {
        return this.configureBoundaries(start, stop, null);
    }

    public NExprTemplate configureBoundaries(String start, String stop, String escape) {
        if (escape == null) {
            escape = "\\" + stop;
        }
        this.start = NAssert.requireNonBlank(NStringUtils.trim(start), "start");
        this.stop = NAssert.requireNonBlank(NStringUtils.trim(stop), "stop");
        this.escape = NStringUtils.trimToNull(escape);
        this.processor = null;
        return this;
    }

    private TagStreamProcessor processorRequired() {
        TagStreamProcessor p = this.processor();
        if (p == null) {
            throw new IllegalArgumentException("invalid processor " + this.start + " ..." + this.stop);
        }
        return p;
    }

    private TagStreamProcessor processor() {
        if (this.processor == null) {
            if (NBlankable.isBlank(this.start)) {
                return null;
            }
            if (NBlankable.isBlank(this.stop)) {
                return null;
            }
            this.processor = new TagStreamProcessor(this.start, this.stop, this.escape);
            return this.processor;
        }
        return this.processor;
    }

    @Override
    public NExprTemplate process(InputStream inputStream, OutputStream outputStream) {
        this.processorRequired().processStream(inputStream, outputStream, this.declarations);
        return this;
    }

    @Override
    public NExprTemplate process(Reader inputStream, Writer outputStream) {
        this.processorRequired().processStream(inputStream, outputStream, this.declarations);
        return this;
    }

    @Override
    public NExprTemplate process(Reader inputStream, PrintStream outputStream) {
        this.processorRequired().processStream(inputStream, new OutputStreamWriter(outputStream), this.declarations);
        return this;
    }

    @Override
    public NExprCompiledTemplate compile(InputStream inputStream) {
        return this.processorRequired().compile(inputStream, this.declarations);
    }

    @Override
    public NExprCompiledTemplate compile(Reader inputStream) {
        return this.processorRequired().compile(inputStream, this.declarations);
    }

    @Override
    public NExprCompiledTemplate compile(String string) {
        return this.compile(new StringReader(string == null ? "" : string));
    }

    @Override
    public NExprCompiledTemplate compile(NInputSource source) {
        NExprCompiledTemplate nExprCompiledTemplate;
        block8: {
            BufferedReader r = source.getBufferedReader();
            try {
                nExprCompiledTemplate = this.compile(source.getBufferedReader());
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            r.close();
        }
        return nExprCompiledTemplate;
    }

    @Override
    public String processString(String string) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.process((Reader)new StringReader(string == null ? "" : string), writer);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return out.toString();
    }
}

