/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ProcessStreamContext;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagNode;
import net.thevpc.nuts.util.NLiteral;

class IfTagNode
extends TagNode {
    List<ElseIf> elseIfBranches = new ArrayList<ElseIf>();
    TagNode elseExpr;

    public IfTagNode(NExprNode expr) {
        this.elseIfBranches.add(new ElseIf(expr, null));
    }

    @Override
    public void run(ProcessStreamContext ctx) throws IOException {
        for (ElseIf e : this.elseIfBranches) {
            Object exprResult = ctx.eval(e.expr);
            if (!NLiteral.of(exprResult).asBoolean().orElse(false).booleanValue()) continue;
            if (e.body != null) {
                e.body.run(ctx);
            }
            return;
        }
        if (this.elseExpr != null) {
            this.elseExpr.run(ctx);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.elseIfBranches.size(); ++i) {
            ElseIf elseIfBranch = this.elseIfBranches.get(i);
            if (i > 0) {
                sb.append("\n else if ");
            } else {
                sb.append("if ");
            }
            sb.append(elseIfBranch.expr);
        }
        if (this.elseExpr != null) {
            sb.append("\nelse ").append(this.elseExpr);
        }
        sb.append("\nend");
        return sb.toString();
    }

    static class ElseIf {
        NExprNode expr;
        TagNode body;

        public ElseIf(NExprNode expr, TagNode body) {
            this.expr = expr;
            this.body = body;
        }
    }
}

