/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class StringTokenizerUtils {
    private StringTokenizerUtils() {
    }

    public static List<String> split(String str, String separators, boolean trim) {
        if (str == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(str, separators);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (trim) {
                s = s.trim();
            }
            result.add(s);
        }
        return result;
    }

    public static List<String> splitDefault(String str) {
        return StringTokenizerUtils.split(str, " ;,\n\r\t|");
    }

    public static List<String> splitSpace(String str) {
        return StringTokenizerUtils.split(str, " ");
    }

    public static List<String> splitColon(String str) {
        return StringTokenizerUtils.split(str, " ");
    }

    public static List<String> splitNewLine(String str) {
        return StringTokenizerUtils.split(str, "\r\n");
    }

    public static List<String> split(String str, String separators) {
        if (str == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer st = new StringTokenizer(str, separators);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreElements()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static List<String> splitSemiColon(String str) {
        return StringTokenizerUtils.split(str, ";");
    }

    public static List<String> splitFileSlash(String str) {
        return StringTokenizerUtils.split(str, "/\\");
    }
}

