/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringPlaceHolderParser {
    public static final Pattern DOLLAR_PLACE_HOLDER_PATTERN = Pattern.compile("(?<braces>[$][{](?<bname>([^}]+))[}])|(?<dollar>[$](?<dname>[a-zA-Z0-9_-]+))");

    private StringPlaceHolderParser() {
    }

    public static <T> String replaceDollarPlaceHolders(String s, T context, PlaceHolderProvider<T> provider) {
        return StringPlaceHolderParser.replaceDollarPlaceHolders(s, x -> provider.get((String)x, context));
    }

    public static String replaceDollarPlaceHolders(String s, Function<String, String> provider) {
        Matcher matcher = DOLLAR_PLACE_HOLDER_PATTERN.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String x;
            String bname = matcher.group("bname");
            if (bname != null) {
                int colon = bname.indexOf(58);
                if (colon >= 0) {
                    String x2;
                    String n = bname.substring(0, colon);
                    String string = x2 = provider == null ? null : provider.apply(n);
                    if (x2 == null) {
                        x2 = bname.substring(colon + 1);
                    }
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(x2));
                    continue;
                }
                String string = x = provider == null ? null : provider.apply(bname);
                if (x == null) {
                    x = "${" + bname + "}";
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(x));
                continue;
            }
            String dname = matcher.group("dname");
            String string = x = provider == null ? null : provider.apply(dname);
            if (x == null) {
                x = "$" + dname;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(x));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static interface PlaceHolderProvider<T> {
        public String get(String var1, T var2);
    }
}

