/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.expr.NExprCommonOp;
import net.thevpc.nuts.expr.NExprConstructDeclaration;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprEvaluator;
import net.thevpc.nuts.expr.NExprFctDeclaration;
import net.thevpc.nuts.expr.NExprInterpolatedStrNode;
import net.thevpc.nuts.expr.NExprLiteralNode;
import net.thevpc.nuts.expr.NExprMutableDeclarations;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeValue;
import net.thevpc.nuts.expr.NExprOpDeclaration;
import net.thevpc.nuts.expr.NExprOpType;
import net.thevpc.nuts.expr.NExprTemplate;
import net.thevpc.nuts.expr.NExprVar;
import net.thevpc.nuts.expr.NExprVarDeclaration;
import net.thevpc.nuts.expr.NExprWordNode;
import net.thevpc.nuts.expr.NExprs;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultDeclarationMutableContext;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultLiteralNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprInterpolatedStrNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprNodeValue;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultWordNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprEvaluatorAsContext;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprWithCache;
import net.thevpc.nuts.runtime.standalone.xtra.expr.SyntaxParser;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.NExprDeclarationsTemplateImpl;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NFunction2;
import net.thevpc.nuts.util.NOptional;

public abstract class NExprDeclarationsBase
implements NExprDeclarations {
    protected NExprs exprs;

    public NExprDeclarationsBase(NExprs exprs) {
        this.exprs = exprs;
    }

    @Override
    public NOptional<Object> evalFunction(String fctName, NExprNodeValue ... args) {
        return this.getFunction(fctName, args).flatMap(x -> NOptional.ofNullable(x.eval(Arrays.asList(args), this)));
    }

    @Override
    public NOptional<Object> evalConstruct(String constructName, NExprNodeValue ... args) {
        return this.getConstruct(constructName, args).flatMap(x -> NOptional.ofNullable(x.eval(Arrays.asList(args), this)));
    }

    @Override
    public NOptional<Object> evalOperator(String opName, NExprOpType type, NExprNodeValue ... args) {
        return this.getOperator(opName, type, args).flatMap(x -> NOptional.ofNullable(x.eval(Arrays.asList(args), this)));
    }

    @Override
    public NOptional<Object> evalInfixOperator(String opName, NExprNodeValue first, NExprNodeValue second) {
        return this.evalOperator(opName, NExprOpType.INFIX, first, second);
    }

    @Override
    public NOptional<Object> evalPrefixOperator(String opName, NExprNodeValue arg) {
        return this.evalOperator(opName, NExprOpType.PREFIX, arg);
    }

    @Override
    public NOptional<Object> evalPostfixOperator(String opName, NExprNodeValue arg) {
        return this.evalOperator(opName, NExprOpType.POSTFIX, arg);
    }

    @Override
    public NOptional<Object> setVarValue(String varName, Object value) {
        return NOptional.of(this.getVar(varName).get().set(value, this));
    }

    @Override
    public NOptional<Object> getVarValue(String varName) {
        NOptional<NExprVarDeclaration> var = this.getVar(varName);
        if (!var.isPresent()) {
            return var.map(x -> null);
        }
        return NOptional.ofNullable(var.get().get(this));
    }

    @Override
    public NExprDeclarations newDeclarations(NExprEvaluator evaluator) {
        return new NExprEvaluatorAsContext(this.exprs, evaluator, this);
    }

    @Override
    public NExprMutableDeclarations newMutableDeclarations() {
        return new DefaultDeclarationMutableContext(this.exprs, this);
    }

    @Override
    public NOptional<NExprNode> parse(String expression) {
        return new SyntaxParser(expression, new NExprWithCache(this)).parse();
    }

    @Override
    public NExprNodeValue literalAsValue(Object any) {
        return this.nodeAsValue(this.literalAsNode(any));
    }

    @Override
    public NExprNode literalAsNode(Object any) {
        return new DefaultLiteralNode(any);
    }

    @Override
    public NExprNodeValue nodeAsValue(NExprNode any) {
        return new DefaultNExprNodeValue(any, this);
    }

    @Override
    public <A, B> NOptional<NFunction2<A, B, ?>> findCommonInfixOp(NExprCommonOp op, Class<? extends A> firstArgType, Class<? extends B> secondArgType) {
        return this.exprs.findCommonInfixOp(op, firstArgType, secondArgType);
    }

    @Override
    public <A> NOptional<NFunction<A, ?>> findCommonPrefixOp(NExprCommonOp op, Class<? extends A> argType) {
        return this.exprs.findCommonPrefixOp(op, argType);
    }

    @Override
    public <A> NOptional<NFunction<A, ?>> findCommonPostfixOp(NExprCommonOp op, Class<? extends A> argType) {
        return this.exprs.findCommonPostfixOp(op, argType);
    }

    @Override
    public NExprWordNode ofWord(String a) {
        return new DefaultWordNode(a);
    }

    @Override
    public NExprLiteralNode ofLiteral(Object a) {
        return new DefaultLiteralNode(a);
    }

    @Override
    public NExprVar ofConst(String name, Object a) {
        return this.exprs.newConst(name, a);
    }

    @Override
    public NExprVar ofVar(String name, Object a) {
        return this.exprs.newVar(name, a);
    }

    @Override
    public NExprVar getOrDeclareVar(String name, Object a) {
        return null;
    }

    @Override
    public NOptional<NExprFctDeclaration> getFunction(String fctName, NExprNodeValue ... args) {
        return null;
    }

    @Override
    public NOptional<NExprConstructDeclaration> getConstruct(String constructName, NExprNodeValue ... args) {
        return null;
    }

    @Override
    public NOptional<NExprOpDeclaration> getOperator(String opName, NExprOpType type, NExprNodeValue ... args) {
        return null;
    }

    @Override
    public List<NExprOpDeclaration> getOperators() {
        return Collections.emptyList();
    }

    @Override
    public NOptional<NExprVarDeclaration> getVar(String varName) {
        return null;
    }

    @Override
    public NExprInterpolatedStrNode ofInterpolatedStr(String a) {
        return new DefaultNExprInterpolatedStrNode(a);
    }

    @Override
    public NExprTemplate ofTemplate() {
        return new NExprDeclarationsTemplateImpl(this);
    }
}

