/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.expr.NExprCommonOp;
import net.thevpc.nuts.expr.NExprConstructDeclaration;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprFct;
import net.thevpc.nuts.expr.NExprFctDeclaration;
import net.thevpc.nuts.expr.NExprFunctionNode;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeType;
import net.thevpc.nuts.expr.NExprNodeValue;
import net.thevpc.nuts.expr.NExprOpAssociativity;
import net.thevpc.nuts.expr.NExprOpDeclaration;
import net.thevpc.nuts.expr.NExprOpPrecedence;
import net.thevpc.nuts.expr.NExprOpType;
import net.thevpc.nuts.expr.NExprVarDeclaration;
import net.thevpc.nuts.expr.NExprWordNode;
import net.thevpc.nuts.expr.NExprs;
import net.thevpc.nuts.reflect.NReflectMethod;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NSignature;
import net.thevpc.nuts.runtime.standalone.xtra.expr.AbstractOp;
import net.thevpc.nuts.runtime.standalone.xtra.expr.BracesFctNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.BracketsFctNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprFctDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprOpDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprDeclarationsBase;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprOpNameAndType;
import net.thevpc.nuts.runtime.standalone.xtra.expr.ParsFctNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.SemiCommaFctNode;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NFunction2;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class DefaultRootDeclarations
extends NExprDeclarationsBase {
    final Map<String, NExprFctDeclaration> defaultFunctions = new HashMap<String, NExprFctDeclaration>();
    final Map<String, NExprConstructDeclaration> defaultConstructs = new HashMap<String, NExprConstructDeclaration>();
    final Map<NExprOpNameAndType, NExprOpDeclaration> ops = new HashMap<NExprOpNameAndType, NExprOpDeclaration>();
    final Map<String, NExprVarDeclaration> defaultVars = new HashMap<String, NExprVarDeclaration>();
    private NReflectRepository reflectRepository = NReflectRepository.of();

    public DefaultRootDeclarations(NExprs exprs) {
        super(exprs);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.AND, 400, NExprOpAssociativity.LEFT), "&");
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.OR, 300, NExprOpAssociativity.LEFT), "|");
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.LT, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.LTE, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.GT, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.GTE, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.EQ, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.NE, 900, NExprOpAssociativity.LEFT), "!=", "!==", "<>");
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.PLUS, NExprOpPrecedence.PLUS, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.MINUS, NExprOpPrecedence.PLUS, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.MUL, NExprOpPrecedence.MUL, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.DIV, NExprOpPrecedence.MUL, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.REM, 900, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.XOR, 300, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeInfix(NExprCommonOp.POW, 1250, NExprOpAssociativity.LEFT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeBase(NExprCommonOp.DOT, 1600, NExprOpAssociativity.LEFT, NExprOpType.INFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNodeValue a = args.get(0);
                NExprNodeValue b = args.get(1);
                Object instance = a.eval(context).orNull();
                if (instance == null) {
                    return null;
                }
                switch (b.getType()) {
                    case WORD: {
                        NExprWordNode w = (NExprWordNode)b.getNode();
                        String n = w.getName();
                        NReflectType t = DefaultRootDeclarations.this.reflectRepository.getType(instance.getClass());
                        NOptional<NReflectProperty> property = t.getProperty(n);
                        if (property.isPresent() && property.get().isRead()) {
                            return property.get().read(instance);
                        }
                        NOptional<NReflectMethod> method = t.getMethod(n, NSignature.of(new NReflectType[0]));
                        if (method.isPresent() && method.get().isAccessible()) {
                            return method.get().invoke(instance, new Object[0]);
                        }
                        throw new NIllegalArgumentException(NMsg.ofC("property not found %s", instance + "." + b));
                    }
                    case FUNCTION: {
                        NExprFunctionNode w = (NExprFunctionNode)b.getNode();
                        String n = w.getName();
                        NReflectType t = DefaultRootDeclarations.this.reflectRepository.getType(instance.getClass());
                        if (w.getArguments().size() == 0) {
                            NOptional<NReflectMethod> method = t.getMethod(n, NSignature.of(new NReflectType[0]));
                            if (method.isPresent() && method.get().isAccessible()) {
                                return method.get().invoke(instance, new Object[0]);
                            }
                            NOptional<NReflectProperty> property = t.getProperty(n);
                            if (property.isPresent() && property.get().isRead()) {
                                return property.get().read(instance);
                            }
                            throw new NIllegalArgumentException(NMsg.ofC("property not found %s", instance + "." + b));
                        }
                        List methodsByName = t.getMethods().stream().filter(x -> x.getName().equals(n)).collect(Collectors.toList());
                        List found1 = methodsByName.stream().filter(x -> x.getSignature().size() == w.getArguments().size() || x.getSignature().isVarArgs() && x.getSignature().size() > w.getArguments().size()).collect(Collectors.toList());
                        NReflectMethod goodMethod = null;
                        if (found1.size() == 1) {
                            goodMethod = (NReflectMethod)found1.get(0);
                        } else if (found1.size() > 1) {
                            throw new NIllegalArgumentException(NMsg.ofC("too many methods to match %s", w));
                        }
                        if (goodMethod == null) {
                            throw new NIllegalArgumentException(NMsg.ofC("method not found to match  %s", w));
                        }
                        List values = w.getArguments().stream().map(x -> x.eval(context)).collect(Collectors.toList());
                        NOptional<NReflectMethod> matchingMethod = t.getMatchingMethod(n, NSignature.of((NReflectType[])values.stream().map(x -> x == null ? null : DefaultRootDeclarations.this.reflectRepository.getType(x.getClass())).toArray(NReflectType[]::new)));
                        goodMethod = matchingMethod.get();
                        return goodMethod.invoke(instance, values.toArray());
                    }
                }
                throw new IllegalArgumentException("unsupported " + instance + "." + b);
            }
        }, new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodePrefix(NExprCommonOp.MINUS, 1300, NExprOpAssociativity.RIGHT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodePrefix(NExprCommonOp.NOT, 1300, NExprOpAssociativity.RIGHT), new String[0]);
        this.addDefaultOp(new NExprCommonOpFctNodeBase(NExprCommonOp.ASSIGN, 100, NExprOpAssociativity.RIGHT, NExprOpType.INFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNode a = args.get(0);
                if (a.getType() == NExprNodeType.WORD) {
                    String varName = a.getName();
                    NExprVarDeclaration v = context.getVar(varName).get();
                    Object newValue = args.get(1).eval(context).get();
                    v.set(newValue, context);
                    return newValue;
                }
                throw new IllegalArgumentException("cannot assign to non valid variable " + name);
            }
        }, new String[0]);
        for (final String relOp : new String[]{"+", "-", "*", "/", "%", "^", "**"}) {
            this.addDefaultOp(new AbstractOp(relOp + "=", 100, NExprOpAssociativity.RIGHT, NExprOpType.INFIX){

                @Override
                public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                    NExprNode a = args.get(0);
                    if (a.getType() == NExprNodeType.WORD) {
                        String varName = a.getName();
                        NExprVarDeclaration v = context.getVar(varName).get();
                        Object oldValue = v.get(context);
                        Object partValue = args.get(1).eval(context).get();
                        Object newValue = context.evalInfixOperator(relOp, context.literalAsValue(oldValue), context.literalAsValue(partValue)).get();
                        v.set(newValue, context);
                        return newValue;
                    }
                    throw new IllegalArgumentException("cannot assign to non valid variable " + name);
                }
            }, new String[0]);
        }
        this.addDefaultOp(new AbstractOp("++", 1300, NExprOpAssociativity.LEFT, NExprOpType.PREFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNode a = args.get(0);
                if (a.getType() == NExprNodeType.WORD) {
                    String varName = a.getName();
                    NExprVarDeclaration v = context.getVar(varName).get();
                    Object oldValue = v.get(context);
                    Object newValue = context.evalInfixOperator("+", context.literalAsValue(oldValue), context.literalAsValue((byte)1)).get();
                    v.set(newValue, context);
                    return newValue;
                }
                throw new IllegalArgumentException("cannot assign to non valid variable " + name);
            }
        }, new String[0]);
        this.addDefaultOp(new AbstractOp("++", 1300, NExprOpAssociativity.LEFT, NExprOpType.POSTFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNode a = args.get(0);
                if (a.getType() == NExprNodeType.WORD) {
                    String varName = a.getName();
                    NExprVarDeclaration v = context.getVar(varName).get();
                    Object oldValue = v.get(context);
                    Object newValue = context.evalInfixOperator("+", context.literalAsValue(oldValue), context.literalAsValue((byte)1)).get();
                    v.set(newValue, context);
                    return oldValue;
                }
                throw new IllegalArgumentException("cannot assign to non valid variable " + name);
            }
        }, new String[0]);
        this.addDefaultOp(new AbstractOp("--", 1300, NExprOpAssociativity.LEFT, NExprOpType.PREFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNode a = args.get(0);
                if (a.getType() == NExprNodeType.WORD) {
                    String varName = a.getName();
                    NExprVarDeclaration v = context.getVar(varName).get();
                    Object oldValue = v.get(context);
                    Object newValue = context.evalInfixOperator("-", context.literalAsValue(oldValue), context.literalAsValue((byte)1)).get();
                    v.set(newValue, context);
                    return newValue;
                }
                throw new IllegalArgumentException("cannot assign to non valid variable " + name);
            }
        }, new String[0]);
        this.addDefaultOp(new AbstractOp("--", 1300, NExprOpAssociativity.LEFT, NExprOpType.POSTFIX){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NExprNode a = args.get(0);
                if (a.getType() == NExprNodeType.WORD) {
                    String varName = a.getName();
                    NExprVarDeclaration v = context.getVar(varName).get();
                    Object oldValue = v.get(context);
                    Object newValue = context.evalInfixOperator("-", context.literalAsValue(oldValue), context.literalAsValue((byte)1)).get();
                    v.set(newValue, context);
                    return oldValue;
                }
                throw new IllegalArgumentException("cannot assign to non valid variable " + name);
            }
        }, new String[0]);
        this.addDefaultOp(new SemiCommaFctNode(";", 50), ";");
        this.addDefaultOp(new ParsFctNode(), "(");
        this.addDefaultOp(new BracketsFctNode(), "[");
        this.addDefaultOp(new BracesFctNode(), "{");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asShort().orNull();
            }
        }, "string");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asBoolean().orNull();
            }
        }, "boolean");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asDouble().orNull();
            }
        }, "double");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asLong().orNull();
            }
        }, "long");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asInt().orNull();
            }
        }, "int");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asFloat().orNull();
            }
        }, "float");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asNumber().isPresent();
            }
        }, "isNumber");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                return NLiteral.of(args.get(0).getValue().orNull()).asBoolean().isPresent();
            }
        }, "isBoolean");
        this.addDefaultFct(new NExprFct(){

            @Override
            public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                NLiteral v = NLiteral.of(args.get(0).getValue().orNull());
                if (v.asNumber().isPresent()) {
                    if (v.isBigDecimal()) {
                        return v.asBigDecimal().get().abs();
                    }
                    if (v.isBigInt()) {
                        return v.asBigInt().get().abs();
                    }
                    if (v.isDouble()) {
                        return Math.abs(v.asDouble().get());
                    }
                    if (v.isFloat()) {
                        return Float.valueOf(Math.abs(v.asFloat().get().floatValue()));
                    }
                    if (v.isInt()) {
                        return Math.abs(v.asInt().get());
                    }
                    if (v.isShort()) {
                        short a = v.asShort().get();
                        return (int)(a < 0 ? -a : a);
                    }
                    if (v.isByte()) {
                        byte a = v.asByte().get();
                        return (int)(a < 0 ? -a : a);
                    }
                    return v.asBigDecimal().get().abs();
                }
                return v.asBoolean().isPresent();
            }
        }, "abs");
    }

    private void addDefaultFct(NExprFct fct, String ... names) {
        for (String name : names) {
            this.defaultFunctions.put(name, new DefaultNExprFctDeclaration(name, fct));
        }
    }

    private void addDefaultOp(AbstractOp op, String ... names) {
        LinkedHashSet<String> allNames = new LinkedHashSet<String>(Arrays.asList(names));
        allNames.add(op.getName());
        if (op instanceof NExprCommonOpFctNodeBase) {
            allNames.add(((NExprCommonOpFctNodeBase)op).op.id());
            allNames.add(((NExprCommonOpFctNodeBase)op).op.image());
        }
        for (String name : allNames) {
            DefaultNExprOpDeclaration opImpl = new DefaultNExprOpDeclaration(name, op);
            this.ops.put(new NExprOpNameAndType(name, op.getType()), opImpl);
        }
    }

    @Override
    public NOptional<NExprFctDeclaration> getFunction(String fctName, NExprNodeValue ... args) {
        return NOptional.of(this.defaultFunctions.get(fctName), () -> NMsg.ofC("function not found %s", fctName));
    }

    @Override
    public NOptional<NExprConstructDeclaration> getConstruct(String constructName, NExprNodeValue ... args) {
        return NOptional.of(this.defaultConstructs.get(constructName), () -> NMsg.ofC("construct not found %s", constructName));
    }

    @Override
    public NOptional<NExprOpDeclaration> getOperator(String opName, NExprOpType type, NExprNodeValue ... args) {
        return NOptional.of(this.ops.get(new NExprOpNameAndType(opName, type)), () -> NMsg.ofC("operator not found %s", opName));
    }

    @Override
    public NOptional<NExprVarDeclaration> getVar(String varName) {
        return NOptional.of(this.defaultVars.get(varName), () -> NMsg.ofC("var not found %s", varName));
    }

    @Override
    public List<NExprOpDeclaration> getOperators() {
        ArrayList<NExprOpDeclaration> all = new ArrayList<NExprOpDeclaration>();
        all.addAll(this.ops.values());
        return all;
    }

    private class NExprCommonOpFctNodeInfix
    extends NExprCommonOpFctNodeBase {
        public NExprCommonOpFctNodeInfix(NExprCommonOp op, int precedence, NExprOpAssociativity acc) {
            super(op, precedence, acc, NExprOpType.INFIX);
        }

        @Override
        public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations e) {
            Object b;
            Class<?> bClass;
            Object a = args.get(0).eval(e).get();
            Class<?> aClass = a == null ? null : a.getClass();
            NFunction2<?, ?, ?> f = e.findCommonInfixOp(this.op, aClass, bClass = (b = args.get(1).eval(e).get()) == null ? null : b.getClass()).orNull();
            if (f != null) {
                return f.apply(a, b);
            }
            throw new IllegalArgumentException("not found infix operator '" + name + "'");
        }
    }

    private class NExprCommonOpFctNodePrefix
    extends NExprCommonOpFctNodeBase {
        public NExprCommonOpFctNodePrefix(NExprCommonOp op, int precedence, NExprOpAssociativity acc) {
            super(op, precedence, acc, NExprOpType.PREFIX);
        }

        @Override
        public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations e) {
            Object a;
            NFunction<?, ?> f = e.findCommonPrefixOp(NExprCommonOp.parse(this.getName()).get(), (a = args.get(0).eval(e).get()) == null ? null : a.getClass()).orNull();
            if (f != null) {
                return f.apply(a);
            }
            throw new IllegalArgumentException("not found prefix operator '" + name + "'");
        }
    }

    private abstract class NExprCommonOpFctNodeBase
    extends AbstractOp {
        protected NExprCommonOp op;

        public NExprCommonOpFctNodeBase(NExprCommonOp op, int precedence, NExprOpAssociativity acc, NExprOpType type) {
            super(op.id(), precedence, acc, type);
            this.op = op;
        }

        public String toString() {
            return "NExprCommonOpFctNode{name=" + this.getName() + ",op=" + this.op + ",type=" + this.getType() + ",precedence=" + this.getPrecedence() + ",associativity=" + this.getAssociativity() + '}';
        }
    }

    private class NExprCommonOpFctNodePostfix
    extends NExprCommonOpFctNodeBase {
        public NExprCommonOpFctNodePostfix(NExprCommonOp op, int precedence, NExprOpAssociativity acc) {
            super(op, precedence, acc, NExprOpType.POSTFIX);
        }

        @Override
        public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations e) {
            Object a;
            NFunction<?, ?> f = e.findCommonPrefixOp(NExprCommonOp.parse(this.getName()).get(), (a = args.get(0).eval(e).get()) == null ? null : a.getClass()).orNull();
            if (f != null) {
                return f.apply(a);
            }
            throw new IllegalArgumentException("not found postfix operator '" + name + "'");
        }
    }
}

