/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeType;
import net.thevpc.nuts.expr.NExprNodeValue;
import net.thevpc.nuts.expr.NExprOpNode;
import net.thevpc.nuts.expr.NExprOpType;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.xtra.expr.EvalUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class DefaultOpNode
implements NExprOpNode {
    private final String name;
    private final String uniformName;
    private final List<NExprNode> args;
    private final NExprOpType opType;
    private final int precedence;

    public DefaultOpNode(String name, String uniformName, NExprOpType type, int precedence, List<NExprNode> args) {
        this.opType = type;
        this.name = name;
        this.uniformName = uniformName;
        this.precedence = precedence;
        this.args = args;
    }

    @Override
    public NExprNode getOperand(int index) {
        if (index >= this.args.size()) {
            throw new IllegalArgumentException("Missing argument " + (index + 1) + " for " + this.name);
        }
        return this.args.get(index);
    }

    @Override
    public List<NExprNode> getOperands() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public NExprNodeType getType() {
        return NExprNodeType.OPERATOR;
    }

    @Override
    public List<NExprNode> getChildren() {
        return this.args;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniformName() {
        return this.uniformName;
    }

    private String toParString(String start, String end) {
        int size = this.args.size();
        if (size == 0) {
            return start + end;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        sb.append(EvalUtils.wrapPars(this.args.get(0)));
        for (int i = 1; i < size; ++i) {
            sb.append(",");
            sb.append(EvalUtils.wrapPars(this.args.get(i)));
        }
        sb.append(end);
        return sb.toString();
    }

    public String toString() {
        switch (this.opType) {
            case PREFIX: {
                switch (this.name) {
                    case "[": {
                        return this.toParString("[", "]");
                    }
                    case "(": {
                        return this.toParString("(", ")");
                    }
                    case "{": {
                        return this.toParString("{", "}");
                    }
                    case "<": {
                        return this.toParString("<", ">");
                    }
                }
                return this.name + " " + EvalUtils.wrapPars(this.args.get(0));
            }
            case POSTFIX: {
                return EvalUtils.wrapPars(this.args.get(0)) + this.name;
            }
            case INFIX: {
                if (this.args.size() == 2) {
                    return EvalUtils.wrapPars(this.args.get(0)) + " " + this.name + " " + EvalUtils.wrapPars(this.args.get(1));
                }
                if (this.args.size() <= 2) break;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.args.size(); ++i) {
                    if (i > 0) {
                        sb.append(" ").append(this.name).append(" ");
                    }
                    sb.append(EvalUtils.wrapPars(this.args.get(i)));
                }
                return sb.toString();
            }
        }
        return this.name + "(" + this.args.stream().map(NComplexExpressionString::toString).collect(Collectors.joining(",")) + ')';
    }

    @Override
    public NOptional<Object> eval(NExprDeclarations context) {
        switch (this.name) {
            case "()": 
            case "(": {
                if (this.getChildren().size() != 1) break;
                return this.getChildren().get(0).eval(context);
            }
        }
        try {
            return context.evalOperator(this.getName(), this.opType, (NExprNodeValue[])this.args.stream().map(context::nodeAsValue).toArray(NExprNodeValue[]::new));
        }
        catch (Exception ex) {
            return NOptional.ofError(() -> NMsg.ofC("error : %s", ex));
        }
    }
}

