/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprIfNode;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class DefaultIfNode
implements NExprIfNode {
    private final NExprNode conditionNode;
    private final NExprNode trueNode;
    private final NExprNode falseNode;

    @Override
    public NExprNodeType getType() {
        return NExprNodeType.IF;
    }

    @Override
    public List<NExprNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return "if";
    }

    public DefaultIfNode(NExprNode conditionNode, NExprNode trueNode, NExprNode falseNode) {
        this.conditionNode = conditionNode;
        this.trueNode = trueNode;
        this.falseNode = falseNode;
    }

    @Override
    public NExprNode getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public NExprNode getTrueNode() {
        return this.trueNode;
    }

    @Override
    public NExprNode getFalseNode() {
        return this.falseNode;
    }

    @Override
    public NOptional<Object> eval(NExprDeclarations context) {
        try {
            Object y;
            NOptional<Object> c = this.conditionNode.eval(context);
            boolean bc = false;
            bc = c.isPresent() ? ((y = c.get()) instanceof Boolean ? (Boolean)y : y != null) : false;
            if (bc) {
                if (this.trueNode != null) {
                    return this.trueNode.eval(context);
                }
                return NOptional.of(null);
            }
            if (this.falseNode != null) {
                return this.falseNode.eval(context);
            }
            return NOptional.of(null);
        }
        catch (Exception ex) {
            return NOptional.ofError(() -> NMsg.ofC("error %s ", ex));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if");
        sb.append("(").append(this.conditionNode == null ? "false" : this.conditionNode.toString()).append(")");
        sb.append("{ ");
        if (this.trueNode != null) {
            sb.append(this.trueNode);
        }
        sb.append("}");
        if (this.falseNode != null) {
            sb.append(" else { ");
            sb.append(this.falseNode);
            sb.append("}");
        }
        return sb.toString();
    }
}

