/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprFunctionNode;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeType;
import net.thevpc.nuts.expr.NExprNodeValue;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class DefaultFunctionNode
implements NExprFunctionNode {
    private final String name;
    private final NExprNode[] args;

    public DefaultFunctionNode(String name, NExprNode[] args) {
        this.name = name;
        this.args = args;
    }

    @Override
    public NExprNode getArgument(int index) {
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument " + (index + 1) + " for " + this.name);
        }
        return this.args[index];
    }

    @Override
    public List<NExprNode> getArguments() {
        return Arrays.asList(this.args);
    }

    @Override
    public NExprNodeType getType() {
        return NExprNodeType.FUNCTION;
    }

    @Override
    public List<NExprNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + Arrays.stream(this.args).map(NComplexExpressionString::toString).collect(Collectors.joining(",")) + ')';
    }

    @Override
    public NOptional<Object> eval(NExprDeclarations context) {
        try {
            return context.evalFunction(this.getName(), (NExprNodeValue[])Arrays.stream(this.args).map(context::nodeAsValue).toArray(NExprNodeValue[]::new));
        }
        catch (Exception ex) {
            return NOptional.ofError(() -> NMsg.ofC("error %s ", ex).asError(ex));
        }
    }
}

