/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.expr.NExprConstruct;
import net.thevpc.nuts.expr.NExprConstructDeclaration;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprFct;
import net.thevpc.nuts.expr.NExprFctDeclaration;
import net.thevpc.nuts.expr.NExprMutableDeclarations;
import net.thevpc.nuts.expr.NExprNodeValue;
import net.thevpc.nuts.expr.NExprOp;
import net.thevpc.nuts.expr.NExprOpAssociativity;
import net.thevpc.nuts.expr.NExprOpDeclaration;
import net.thevpc.nuts.expr.NExprOpPrecedence;
import net.thevpc.nuts.expr.NExprOpType;
import net.thevpc.nuts.expr.NExprVar;
import net.thevpc.nuts.expr.NExprVarDeclaration;
import net.thevpc.nuts.expr.NExprs;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprConstructDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprFctDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprOpDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprVarDeclaration;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprDeclarationsBase;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprOpNameAndType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class DefaultDeclarationMutableContext
extends NExprDeclarationsBase
implements NExprMutableDeclarations {
    private static DecInfo REMOVED = new DecInfo<Object>(null);
    private final Map<String, DecInfo<NExprFctDeclaration>> userFunctions = new LinkedHashMap<String, DecInfo<NExprFctDeclaration>>();
    private final Map<String, DecInfo<NExprConstructDeclaration>> userConstructs = new LinkedHashMap<String, DecInfo<NExprConstructDeclaration>>();
    private final Map<NExprOpNameAndType, DecInfo<NExprOpDeclaration>> ops = new LinkedHashMap<NExprOpNameAndType, DecInfo<NExprOpDeclaration>>();
    private final Map<String, DecInfo<NExprVarDeclaration>> userVars = new LinkedHashMap<String, DecInfo<NExprVarDeclaration>>();
    private NExprDeclarations parent;

    public DefaultDeclarationMutableContext(NExprs exprs, NExprDeclarations parent) {
        super(exprs);
        this.parent = parent;
    }

    @Override
    public NOptional<NExprVarDeclaration> getVar(String name) {
        DecInfo<NExprVarDeclaration> f = this.userVars.get(name);
        if (f != null) {
            if (f.value != null) {
                return NOptional.of((NExprVarDeclaration)f.value);
            }
        } else if (this.parent != null) {
            return this.parent.getVar(name);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("var not found %s", name));
    }

    @Override
    public NExprVar getOrDeclareVar(String name, Object value) {
        NExprVarDeclaration o = this.getVar(name).orNull();
        if (o != null) {
            return o.asVar();
        }
        NExprVarDeclaration e = this.declareVar(name);
        e.set(value, this);
        return e.asVar();
    }

    @Override
    public NOptional<NExprFctDeclaration> getFunction(String name, NExprNodeValue ... args) {
        DecInfo<NExprFctDeclaration> f = this.userFunctions.get(name);
        if (f != null) {
            if (f.value != null) {
                return NOptional.of((NExprFctDeclaration)f.value);
            }
        } else if (this.parent != null) {
            return this.parent.getFunction(name, args);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("function not found %s", name));
    }

    @Override
    public NOptional<NExprConstructDeclaration> getConstruct(String name, NExprNodeValue ... args) {
        DecInfo<NExprConstructDeclaration> f = this.userConstructs.get(name);
        if (f != null) {
            if (f.value != null) {
                return NOptional.of((NExprConstructDeclaration)f.value);
            }
        } else if (this.parent != null) {
            return this.parent.getConstruct(name, args);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("construct not found %s", name));
    }

    @Override
    public NExprVarDeclaration declareVar(String name, NExprVar varImpl) {
        if (!NBlankable.isBlank(name)) {
            if (varImpl == null) {
                this.userFunctions.put(name, REMOVED);
            } else {
                DefaultNExprVarDeclaration r = new DefaultNExprVarDeclaration(name, varImpl);
                this.userVars.put(name, new DecInfo<DefaultNExprVarDeclaration>(r));
                return r;
            }
        }
        return null;
    }

    @Override
    public NExprVarDeclaration declareVar(String name) {
        return this.declareVar(name, new DefaultNExprVarImpl());
    }

    @Override
    public NExprVarDeclaration declareConstant(String name, Object value) {
        return this.declareVar(name, this.ofConst(name, value));
    }

    @Override
    public NExprFctDeclaration declareFunction(String name, NExprFct fctImpl) {
        if (!NBlankable.isBlank(name)) {
            if (fctImpl == null) {
                this.userFunctions.put(name, REMOVED);
            } else {
                DefaultNExprFctDeclaration r = new DefaultNExprFctDeclaration(name, fctImpl);
                this.userFunctions.put(name, new DecInfo<DefaultNExprFctDeclaration>(r));
                return r;
            }
        }
        return null;
    }

    @Override
    public NExprConstructDeclaration declareConstruct(String name, NExprConstruct constructImpl) {
        if (!NBlankable.isBlank(name)) {
            if (constructImpl == null) {
                this.userConstructs.put(name, REMOVED);
            } else {
                DefaultNExprConstructDeclaration r = new DefaultNExprConstructDeclaration(name, constructImpl);
                this.userConstructs.put(name, new DecInfo<DefaultNExprConstructDeclaration>(r));
                return r;
            }
        }
        return null;
    }

    @Override
    public NExprOpDeclaration declareOperator(String name, NExprConstruct impl) {
        return this.declareOperator(name, null, impl);
    }

    @Override
    public NExprOpDeclaration declareOperator(String name, NExprOpType type, NExprConstruct impl) {
        switch (name) {
            case "+": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.PLUS, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "-": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.MINUS, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "*": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.MUL, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "/": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.DIV, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "%": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.MOD, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "(": 
            case "()": {
                if (type == null) {
                    type = NExprOpType.POSTFIX;
                }
                switch (type) {
                    case POSTFIX: {
                        return this.declareOperator(name, type, 1600, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "[": 
            case "[]": {
                if (type == null) {
                    type = NExprOpType.POSTFIX;
                }
                switch (type) {
                    case POSTFIX: {
                        return this.declareOperator(name, type, 1600, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "{": 
            case "{}": {
                if (type == null) {
                    type = NExprOpType.POSTFIX;
                }
                switch (type) {
                    case POSTFIX: {
                        return this.declareOperator(name, type, 1600, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case ".": 
            case "?.": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 1600, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "<<": 
            case ">>": 
            case ">>>": 
            case "<<<": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 1000, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "<": 
            case ">": 
            case "<=": 
            case ">=": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 900, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "=": 
            case "==": 
            case "!=": 
            case "<>": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 800, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "&&": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 400, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "&": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 700, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "||": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 300, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "|": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, 500, NExprOpAssociativity.LEFT, impl);
                    }
                }
                break;
            }
            case "??": {
                if (type == null) {
                    type = NExprOpType.INFIX;
                }
                switch (type) {
                    case INFIX: {
                        return this.declareOperator(name, type, NExprOpPrecedence.COALESCE, NExprOpAssociativity.LEFT, impl);
                    }
                }
            }
        }
        throw new IllegalArgumentException("unsupported operator " + name);
    }

    @Override
    public NExprOpDeclaration declareOperator(String name, final NExprOpType type, final int precedence, final NExprOpAssociativity associativity, final NExprConstruct impl) {
        if (!NBlankable.isBlank(name) && type != null) {
            if (impl == null) {
                this.ops.put(new NExprOpNameAndType(name, type), REMOVED);
            } else {
                DefaultNExprOpDeclaration r = new DefaultNExprOpDeclaration(name, new NExprOp(){

                    @Override
                    public NExprOpAssociativity getAssociativity() {
                        return associativity;
                    }

                    @Override
                    public NExprOpType getType() {
                        return type;
                    }

                    @Override
                    public int getPrecedence() {
                        return precedence;
                    }

                    @Override
                    public Object eval(String name, List<NExprNodeValue> args, NExprDeclarations context) {
                        return impl.eval(name, args, context);
                    }
                });
                this.ops.put(new NExprOpNameAndType(name, type), new DecInfo<DefaultNExprOpDeclaration>(r));
                return r;
            }
        }
        return null;
    }

    @Override
    public NOptional<NExprOpDeclaration> getOperator(String opName, NExprOpType type, NExprNodeValue ... nodes) {
        DecInfo<NExprOpDeclaration> f = this.ops.get(new NExprOpNameAndType(opName, type));
        if (f != null) {
            if (f.value != null) {
                return NOptional.of((NExprOpDeclaration)f.value);
            }
        } else if (this.parent != null) {
            return this.parent.getOperator(opName, type, new NExprNodeValue[0]);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("operator not found %s", opName));
    }

    @Override
    public void resetDeclaration(NExprVarDeclaration member) {
        if (member != null) {
            this.userVars.remove(member.getName());
        }
    }

    @Override
    public void removeDeclaration(NExprVarDeclaration member) {
        if (member != null) {
            this.userVars.put(member.getName(), REMOVED);
        }
    }

    @Override
    public void resetDeclaration(NExprFctDeclaration member) {
        if (member != null) {
            this.userFunctions.remove(member.getName());
        }
    }

    @Override
    public void removeDeclaration(NExprFctDeclaration member) {
        if (member != null) {
            this.userFunctions.put(member.getName(), REMOVED);
        }
    }

    @Override
    public void resetDeclaration(NExprConstructDeclaration member) {
        if (member != null) {
            this.userConstructs.remove(member.getName());
        }
    }

    @Override
    public void removeDeclaration(NExprConstructDeclaration member) {
        if (member != null) {
            this.userConstructs.put(member.getName(), REMOVED);
        }
    }

    @Override
    public void resetDeclaration(NExprOpDeclaration member) {
        if (member != null) {
            this.ops.remove(this.t(member));
        }
    }

    @Override
    public void removeDeclaration(NExprOpDeclaration member) {
        if (member != null) {
            this.ops.put(this.t(member), REMOVED);
        }
    }

    private NExprOpNameAndType t(NExprOpDeclaration member) {
        return new NExprOpNameAndType(member.getName(), member.getType());
    }

    @Override
    public List<NExprOpDeclaration> getOperators() {
        ArrayList<NExprOpDeclaration> all = new ArrayList<NExprOpDeclaration>();
        if (this.parent != null) {
            for (NExprOpDeclaration o : this.parent.getOperators()) {
                DecInfo<NExprOpDeclaration> y = this.ops.get(new NExprOpNameAndType(o.getName(), o.getType()));
                if (y != null) continue;
                all.add(o);
            }
        }
        for (NExprOpType t : NExprOpType.values()) {
            for (DecInfo<NExprOpDeclaration> value : this.ops.values()) {
                if (value.value == null) continue;
                all.add((NExprOpDeclaration)value.value);
            }
        }
        return all;
    }

    private static class DecInfo<T> {
        final T value;

        public DecInfo(T value) {
            this.value = value;
        }
    }

    private static class DefaultNExprVarImpl
    implements NExprVar {
        private Object value;

        private DefaultNExprVarImpl() {
        }

        @Override
        public Object get(String name, NExprDeclarations context) {
            return this.value;
        }

        @Override
        public Object set(String name, Object value, NExprDeclarations context) {
            Object old = this.value;
            this.value = value;
            return old;
        }
    }
}

