/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.util.AbstractMultiReadNInputSource;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTreeVisitResult;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNDigest
implements NDigest {
    private final NWorkspace workspace;
    private List<NInputSource> sources;
    private String algorithm;

    public DefaultNDigest(NWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public NDigest addSource(NInputSource source) {
        return this.addSource0(source);
    }

    private NDigest addSource0(NInputSource source) {
        if (source != null) {
            if (this.sources == null) {
                this.sources = new ArrayList<NInputSource>();
            }
            this.sources.add(source);
        }
        return this;
    }

    private NDigest setSource0(NInputSource source) {
        this.sources = source == null ? new ArrayList<NInputSource>() : new ArrayList<NInputSource>(Arrays.asList(source));
        return this;
    }

    @Override
    public NDigest setSource(NInputSource source) {
        this.setSource0(source);
        return this;
    }

    @Override
    public List<NInputSource> getSource() {
        return this.sources;
    }

    @Override
    public NDigest setSource(InputStream source) {
        this.setSource0(source == null ? null : NInputSource.of(source));
        return this;
    }

    @Override
    public NDigest setSource(File source) {
        this.setSource0(source == null ? null : NPath.of(source));
        return this;
    }

    @Override
    public NDigest setSource(Path source) {
        this.setSource0(source == null ? null : NPath.of(source));
        return this;
    }

    @Override
    public NDigest setSource(URL url) {
        this.setSource0(url == null ? null : NPath.of(url));
        return this;
    }

    @Override
    public NDigest setSource(NPath source) {
        this.setSource0(source);
        return this;
    }

    @Override
    public NDigest setSource(byte[] source) {
        this.setSource0(source == null ? null : NInputSource.of(source));
        return this;
    }

    @Override
    public NDigest setSource(NDescriptor source) {
        this.setSource0(source == null ? null : new NDescriptorInputSource(source));
        return this;
    }

    @Override
    public NDigest addSource(InputStream source) {
        this.setSource0(source == null ? null : NInputSource.of(source));
        return this;
    }

    @Override
    public NDigest addSource(File source) {
        this.setSource0(source == null ? null : NPath.of(source));
        return this;
    }

    @Override
    public NDigest addSource(Path source) {
        this.setSource0(source == null ? null : NPath.of(source));
        return this;
    }

    @Override
    public NDigest addSource(URL url) {
        this.setSource0(url == null ? null : NPath.of(url));
        return this;
    }

    @Override
    public NDigest addSource(NPath source) {
        this.setSource0(source);
        return this;
    }

    @Override
    public NDigest addSource(byte[] source) {
        this.setSource0(source == null ? null : NInputSource.of(source));
        return this;
    }

    @Override
    public NDigest addSource(NDescriptor source) {
        this.setSource0(source == null ? null : new NDescriptorInputSource(source));
        return this;
    }

    @Override
    public String computeString() {
        return NHex.fromBytes(this.computeBytes());
    }

    @Override
    public byte[] computeBytes() {
        MessageDigest md;
        NAssert.requireTrue(this.sources != null && !this.sources.isEmpty(), "source");
        String algo = this.getValidAlgo();
        try {
            md = MessageDigest.getInstance(algo);
            for (NInputSource source : this.sources) {
                this.incrementalUpdateFileDigestInputSource(source, md);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new NIOException(new IOException(e));
        }
        return md.digest();
    }

    private void incrementalUpdateFileDigestPath(NPath file, final MessageDigest md) {
        if (file.isDirectory()) {
            file.walkDfs(new NTreeVisitor<NPath>(){

                @Override
                public NTreeVisitResult visitFile(NPath file) {
                    DefaultNDigest.this.incrementalUpdateFileDigestInputStream(new ByteArrayInputStream(file.toString().getBytes()), md);
                    try (InputStream is = file.getInputStream();){
                        DefaultNDigest.this.incrementalUpdateFileDigestInputStream(is, md);
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                    return NTreeVisitResult.CONTINUE;
                }

                @Override
                public NTreeVisitResult preVisitDirectory(NPath dir) {
                    DefaultNDigest.this.incrementalUpdateFileDigestInputStream(new ByteArrayInputStream(dir.toString().getBytes()), md);
                    return NTreeVisitResult.CONTINUE;
                }
            }, new NPathOption[0]);
        } else if (file.isFile()) {
            try (InputStream is = file.getInputStream();){
                this.incrementalUpdateFileDigestInputStream(is, md);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    private void incrementalUpdateFileDigestInputSource(NInputSource source, MessageDigest md) {
        if (source instanceof NPath) {
            NPath file = (NPath)source;
            this.incrementalUpdateFileDigestPath(file, md);
            return;
        }
        try (InputStream is = source.getInputStream();){
            this.incrementalUpdateFileDigestInputStream(is, md);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private void incrementalUpdateFileDigestInputStream(InputStream inputStream, MessageDigest md) {
        try (BufferedInputStream is = new BufferedInputStream(inputStream);){
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = ((InputStream)is).read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = ((InputStream)is).read(buffer);
                }
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public NDigest writeHash(OutputStream out) {
        try {
            out.write(this.computeBytes());
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return this;
    }

    @Override
    public NDigest md5() {
        return this.setAlgorithm("MD5");
    }

    @Override
    public NDigest sha1() {
        return this.setAlgorithm("SHA1");
    }

    @Override
    public NDigest sha256() {
        return this.setAlgorithm("SHA256");
    }

    @Override
    public NDigest algorithm(String algorithm) {
        return this.setAlgorithm(algorithm);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public NDigest setAlgorithm(String algorithm) {
        if (NBlankable.isBlank(algorithm)) {
            algorithm = null;
        }
        try {
            MessageDigest.getInstance(algorithm);
            this.algorithm = algorithm;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NIllegalArgumentException(NMsg.ofC("unable to resolve algo: %s", algorithm), (Throwable)ex);
        }
        return this;
    }

    protected String getValidAlgo() {
        if (this.algorithm == null) {
            return "SHA1";
        }
        return this.algorithm;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public class NDescriptorInputSource
    extends AbstractMultiReadNInputSource {
        private final NDescriptor source;

        public NDescriptorInputSource(NDescriptor source) {
            this.source = source;
        }

        private byte[] getBytes() {
            return NDescriptorFormat.of(this.source).setNtf(false).format().filteredText().getBytes();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public boolean isKnownContentLength() {
            return true;
        }

        @Override
        public long getContentLength() {
            return NDescriptorFormat.of(this.source).setNtf(false).format().filteredText().getBytes().length;
        }

        @Override
        public NContentMetadata getMetaData() {
            NId id = this.source.getId();
            NText str = id != null ? NFormats.of(id).get().format() : NText.ofStyled("<empty-descriptor>", NTextStyle.path());
            return new DefaultNContentMetadata(NMsg.ofNtf(str), null, null, null, null);
        }

        @Override
        public boolean isMultiRead() {
            return true;
        }

        public String toString() {
            NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.FILTERED);
            NOptional<NMsg> m = this.getMetaData().getMessage();
            if (m.isPresent()) {
                out.print(m.get());
            } else {
                out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
            }
            return out.toString();
        }
    }
}

