/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NUncompress;
import net.thevpc.nuts.io.NUncompressVisitor;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.xtra.compress.NUncompressGzip;
import net.thevpc.nuts.runtime.standalone.xtra.compress.NUncompressZip;
import net.thevpc.nuts.runtime.standalone.xtra.time.SingletonNInputStreamProgressFactory;
import net.thevpc.nuts.spi.NUncompressPackaging;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class DefaultNUncompress
implements NUncompress {
    private NLog LOG;
    private boolean skipRoot = false;
    private boolean safe = true;
    private String packaging = "zip";
    private NInputSource source;
    private NOutputTarget target;
    private NProgressFactory progressFactory;
    private Set<NPathOption> options = new LinkedHashSet<NPathOption>();
    private NUncompressVisitor visitor;
    private NUncompressPackaging packagingImpl;

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    protected NLog _LOG() {
        if (this.LOG == null) {
            this.LOG = NLog.of(DefaultNUncompress.class);
        }
        return this.LOG;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public NUncompress setPackaging(String packaging) {
        this.packagingImpl = NExtensions.of().createComponent(NUncompressPackaging.class, this).get();
        return this;
    }

    @Override
    public NInputSource getSource() {
        return this.source;
    }

    @Override
    public NUncompress setSource(NInputSource source) {
        this.source = source;
        return this;
    }

    @Override
    public NUncompress setTarget(NOutputTarget target) {
        this.target = target;
        return this;
    }

    @Override
    public NUncompress setSource(InputStream source) {
        this.source = source == null ? null : NInputSource.of(source);
        return this;
    }

    @Override
    public NUncompress setSource(NPath source) {
        this.source = source;
        return this;
    }

    @Override
    public NUncompress setSource(File source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NUncompress setSource(Path source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NUncompress setSource(URL source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NUncompress setTarget(Path target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NUncompress setTarget(File target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NUncompress setTarget(NPath target) {
        this.target = target;
        return this;
    }

    @Override
    public NUncompress from(NPath source) {
        this.source = source;
        return this;
    }

    @Override
    public NUncompress to(NPath target) {
        this.target = target;
        return this;
    }

    @Override
    public NOutputTarget getTarget() {
        return this.target;
    }

    @Override
    public NUncompress from(InputStream source) {
        return this.setSource(source);
    }

    @Override
    public NUncompress from(File source) {
        return this.setSource(source);
    }

    @Override
    public NUncompress from(Path source) {
        return this.setSource(source);
    }

    @Override
    public NUncompress from(URL source) {
        return this.setSource(source);
    }

    @Override
    public NUncompress to(File target) {
        return this.setTarget(target);
    }

    @Override
    public NUncompress to(Path target) {
        return this.setTarget(target);
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public DefaultNUncompress setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    @Override
    public NUncompress run() {
        CompressType compressType = this.toCompressType(this.getPackaging());
        NAssert.requireNonNull(this.source, "source");
        NInputSource _source = this.source;
        if (this.options.contains(NPathOption.LOG) || this.options.contains(NPathOption.TRACE) || this.getProgressFactory() != null) {
            NInputStreamMonitor monitor = NInputStreamMonitor.of();
            monitor.setOrigin(this.source);
            monitor.setLogProgress(this.options.contains(NPathOption.LOG));
            monitor.setTraceProgress(this.options.contains(NPathOption.TRACE));
            monitor.setProgressFactory(this.getProgressFactory());
            monitor.setSource(this.source);
            _source = NInputSource.of(monitor.create());
        }
        if (this.visitor == null && this.target == null) {
            NAssert.requireNonNull(this.target, "target");
        } else {
            if (this.visitor != null && this.target != null) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid target %s when visitor is specified", this.target));
            }
            if (this.visitor != null) {
                return this.runVisitor(_source, compressType);
            }
        }
        this._LOG().log(NMsg.ofC("uncompress %s to %s", _source, this.target).asFine().withIntent(NMsgIntent.START).withLevel(Level.FINEST).withIntent(NMsgIntent.START));
        if (this.packagingImpl == null) {
            this.packagingImpl = NExtensions.of().createComponent(NUncompressPackaging.class, this).get();
        }
        this.packagingImpl.uncompressPackage(this, _source);
        return this;
    }

    @Override
    public NUncompress visit(NUncompressVisitor visitor) {
        this.visitor = visitor;
        return this;
    }

    private CompressType toCompressType(String format) {
        if (NBlankable.isBlank(format)) {
            format = "zip";
        }
        switch (format) {
            case "zip": {
                return CompressType.ZIP;
            }
            case "gzip": 
            case "gz": {
                return CompressType.GZIP;
            }
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("unsupported format %s", format));
    }

    private NUncompress runVisitor(NInputSource source, CompressType format) {
        switch (format.ordinal()) {
            case 0: {
                new NUncompressZip().visitPackage(this, source, this.visitor);
                break;
            }
            case 1: {
                new NUncompressGzip().visitPackage(this, source, this.visitor);
                break;
            }
            default: {
                throw new NUnsupportedArgumentException(NMsg.ofC("unsupported format %s", new Object[]{format}));
            }
        }
        return this;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NUncompress setProgressFactory(NProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    @Override
    public NUncompress setProgressMonitor(NProgressListener value) {
        this.progressFactory = value == null ? null : new SingletonNInputStreamProgressFactory(value);
        return this;
    }

    @Override
    public NUncompress progressMonitor(NProgressListener value) {
        return this.setProgressMonitor(value);
    }

    @Override
    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    @Override
    public NUncompress setSkipRoot(boolean value) {
        this.skipRoot = value;
        return this;
    }

    @Override
    public NUncompress setFormatOption(String option, Object value) {
        return this;
    }

    @Override
    public Object getFormatOption(String option) {
        return null;
    }

    @Override
    public NUncompress addOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    @Override
    public NUncompress removeOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    @Override
    public NUncompress clearOptions() {
        this.options.clear();
        return this;
    }

    @Override
    public Set<NPathOption> getOptions() {
        return new LinkedHashSet<NPathOption>(this.options);
    }

    private static enum CompressType {
        ZIP,
        GZIP;

    }
}

