/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NCompress;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.xtra.time.SingletonNInputStreamProgressFactory;
import net.thevpc.nuts.spi.NCompressPackaging;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNCompress
implements NCompress {
    private final List<NInputSource> sources = new ArrayList<NInputSource>();
    private final NWorkspace ws;
    private NLog LOG;
    private boolean safe = true;
    private NOutputTarget target;
    private boolean skipRoot;
    private NProgressFactory progressFactory;
    private String packaging = "zip";
    private NCompressPackaging packagingImpl;
    private Set<NPathOption> options = new LinkedHashSet<NPathOption>();

    public DefaultNCompress(NWorkspace ws) {
        this.ws = ws;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    protected NLog _LOG() {
        if (this.LOG == null) {
            this.LOG = NLog.of(DefaultNCompress.class);
        }
        return this.LOG;
    }

    @Override
    public NCompress setFormatOption(String option, Object value) {
        return this;
    }

    @Override
    public Object getFormatOption(String option) {
        return null;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public NCompress setPackaging(String packaging) {
        if (NBlankable.isBlank(packaging)) {
            packaging = "zip";
        }
        this.packaging = packaging;
        this.packagingImpl = NExtensions.of().createComponent(NCompressPackaging.class, this).get();
        return this;
    }

    @Override
    public List<NInputSource> getSources() {
        return this.sources;
    }

    @Override
    public NCompress addSource(NInputSource source) {
        if (source != null) {
            this.sources.add(source);
        }
        return this;
    }

    @Override
    public NCompress addSource(InputStream source) {
        if (source == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("null source"));
        }
        this.sources.add(NInputSource.of(source));
        return this;
    }

    @Override
    public NCompress addSource(File source) {
        if (source == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("null source"));
        }
        this.sources.add(NPath.of(source));
        return this;
    }

    @Override
    public NCompress addSource(Path source) {
        if (source == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("null source"));
        }
        this.sources.add(NPath.of(source));
        return this;
    }

    @Override
    public NCompress addSource(URL source) {
        if (source == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("null source"));
        }
        this.sources.add(NPath.of(source));
        return this;
    }

    @Override
    public NCompress addSource(NPath source) {
        if (source != null) {
            this.sources.add(source);
        }
        return this;
    }

    @Override
    public NOutputTarget getTarget() {
        return this.target;
    }

    @Override
    public NCompress setTarget(OutputStream target) {
        this.target = target == null ? null : NOutputTarget.of(target);
        return this;
    }

    @Override
    public NCompress setTarget(NOutputTarget target) {
        this.target = target;
        return this;
    }

    @Override
    public NCompress setTarget(Path target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NCompress setTarget(File target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NCompress setTarget(String target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NCompress setTarget(NPath target) {
        this.target = target;
        return this;
    }

    @Override
    public NCompress to(NPath target) {
        return this.setTarget(target);
    }

    @Override
    public NCompress to(OutputStream target) {
        return this.setTarget(target);
    }

    @Override
    public NCompress to(String target) {
        return this.setTarget(target);
    }

    @Override
    public NCompress to(Path target) {
        return this.setTarget(target);
    }

    @Override
    public NCompress to(File target) {
        return this.setTarget(target);
    }

    @Override
    public NCompress run() {
        if (this.packagingImpl == null) {
            this.packagingImpl = NExtensions.of().createComponent(NCompressPackaging.class, this).get();
        }
        this.packagingImpl.compressPackage(this);
        return this;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NCompress setProgressFactory(NProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    @Override
    public NCompress setProgressMonitor(NProgressListener value) {
        this.progressFactory = value == null ? null : new SingletonNInputStreamProgressFactory(value);
        return this;
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public NCompress setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    @Override
    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    @Override
    public NCompress setSkipRoot(boolean value) {
        this.skipRoot = value;
        return this;
    }

    @Override
    public NCompress addOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    @Override
    public NCompress removeOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    @Override
    public NCompress clearOptions() {
        this.options.clear();
        return this;
    }

    @Override
    public Set<NPathOption> getOptions() {
        return new LinkedHashSet<NPathOption>(this.options);
    }

    public static class Item {
        private final NInputSource inSource;
        private final NCompress c;

        public Item(NInputSource value, NCompress c) {
            this.inSource = value;
            this.c = c;
        }

        public boolean isSourcePath() {
            return this.inSource instanceof NPath;
        }

        public boolean isSourceDirectory() {
            return this.isSourcePath() && ((NPath)this.inSource).isDirectory();
        }

        public Item[] list() {
            if (this.isSourcePath()) {
                NPath p = (NPath)this.inSource;
                return (Item[])p.stream().map(NFunction.of(x -> new Item((NInputSource)x, this.c)).redescribe((Supplier)NElementDescribables.ofDesc("NutsStreamOrPath::of"))).toArray(Item[]::new);
            }
            return new Item[0];
        }

        public InputStream open() {
            if (this.c.getOptions().contains(NPathOption.LOG) || this.c.getOptions().contains(NPathOption.TRACE) || this.c.getProgressFactory() != null) {
                NInputStreamMonitor monitor = NInputStreamMonitor.of();
                monitor.setOrigin(this.inSource);
                monitor.setLogProgress(this.c.getOptions().contains(NPathOption.LOG));
                monitor.setTraceProgress(this.c.getOptions().contains(NPathOption.TRACE));
                monitor.setProgressFactory(this.c.getProgressFactory());
                monitor.setSource(this.inSource);
                return monitor.create();
            }
            return this.inSource.getInputStream();
        }

        public String getName() {
            return this.inSource.getMetaData().getName().orElse(this.inSource.toString());
        }
    }
}

