/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.list;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NOpenMode;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceList;
import net.thevpc.nuts.core.NWorkspaceListConfig;
import net.thevpc.nuts.core.NWorkspaceLocation;
import net.thevpc.nuts.core.NWorkspaceOptionsBuilder;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNWorkspaceList
implements NWorkspaceList {
    private String name;
    private Map<String, NWorkspaceLocation> workspaces = new LinkedHashMap<String, NWorkspaceLocation>();
    private NWorkspaceListConfig config;

    public DefaultNWorkspaceList() {
        NWorkspace ws = NWorkspace.of();
        this.setName(null);
        NPath file = this.getConfigFile();
        if (file.exists()) {
            this.config = NElementParser.ofJson().parse(file, NWorkspaceListConfig.class);
            for (NWorkspaceLocation var : this.config.getWorkspaces()) {
                this.workspaces.put(var.getUuid(), var);
            }
        } else {
            this.config = new NWorkspaceListConfig().setUuid(UUID.randomUUID().toString()).setName("default-config");
            this.workspaces.put(ws.getUuid(), new NWorkspaceLocation().setUuid(ws.getUuid()).setName("default-workspace").setLocation(NWorkspace.of().getWorkspaceLocation().toString()));
            this.save();
        }
    }

    @Override
    public DefaultNWorkspaceList setName(String name) {
        if (NBlankable.isBlank(name)) {
            name = "default";
        }
        this.name = name.trim();
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private NPath getConfigFile() {
        return NPath.ofIdStore(NId.getForClass(DefaultNWorkspaceList.class).get(), NStoreType.CONF).resolve(this.name + "-nuts-workspace-list.json");
    }

    @Override
    public List<NWorkspaceLocation> getWorkspaces() {
        return new ArrayList<NWorkspaceLocation>(this.workspaces.values());
    }

    @Override
    public NWorkspaceLocation getWorkspaceLocation(String uuid) {
        return this.workspaces.get(uuid);
    }

    @Override
    public NWorkspaceListConfig getConfig() {
        return this.config;
    }

    @Override
    public DefaultNWorkspaceList setConfig(NWorkspaceListConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public NWorkspace addWorkspace(String path) {
        NWorkspace ss = this.createWorkspace(path);
        NWorkspace workspace = NWorkspace.of();
        NWorkspaceLocation workspaceLocation = new NWorkspaceLocation().setUuid(ss.getUuid()).setName(workspace.getWorkspaceLocation().getName()).setLocation(workspace.getWorkspaceLocation().toString());
        this.workspaces.put(ss.getUuid(), workspaceLocation);
        this.save();
        return ss;
    }

    @Override
    public boolean removeWorkspace(String uuid) {
        boolean b;
        boolean bl = b = this.workspaces.remove(uuid) != null;
        if (b) {
            this.save();
        }
        return b;
    }

    @Override
    public void save() {
        this.config.setWorkspaces((List<NWorkspaceLocation>)(this.workspaces.isEmpty() ? null : new ArrayList<NWorkspaceLocation>(this.workspaces.values())));
        NPath file = this.getConfigFile();
        NElementWriter.ofJson().write((Object)this.config, file);
    }

    public DefaultNWorkspaceList setWorkspaces(Map<String, NWorkspaceLocation> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    private NWorkspace createWorkspace(String path) {
        return Nuts.openWorkspace(NWorkspaceOptionsBuilder.of().setWorkspace(path).setOpenMode(NOpenMode.OPEN_OR_CREATE).setInstallCompanions(false).build());
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

