/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.concurrent.NScopedStack;
import net.thevpc.nuts.concurrent.NScopedValue;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.reflect.NBeanContainer;
import net.thevpc.nuts.reflect.NBeanRef;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.DefaultElementMapperStore;
import net.thevpc.nuts.runtime.standalone.event.DefaultNWorkspaceEventModel;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNExtensions;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.io.cache.CachedSupplier;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLog;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogModel;
import net.thevpc.nuts.runtime.standalone.log.NLogSPIJUL;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepositoryModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNInstalledRepository;
import net.thevpc.nuts.runtime.standalone.security.DefaultNWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStoreInMemory;
import net.thevpc.nuts.runtime.standalone.store.NWorkspaceStoreOnDisk;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.util.NPropertiesHolder;
import net.thevpc.nuts.runtime.standalone.util.filters.DefaultNFilterModel;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.SafeRecommendationConnector;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.SimpleRecommendationConnector;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultCustomCommandsModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNPlatformModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceLocationModel;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressMonitor;
import net.thevpc.nuts.util.NLRUMap;
import net.thevpc.nuts.util.NOptional;

public class NWorkspaceModel {
    public NLog LOG;
    public NWorkspace workspace;
    public NScopedValue<NSession> sessionScopes = new NScopedValue();
    public NSession initSession;
    public DefaultNBootModel bootModel;
    public DefaultNWorkspaceSecurityModel securityModel;
    public DefaultNFilterModel filtersModel;
    public DefaultNWorkspaceConfigModel configModel;
    public DefaultNWorkspaceLocationModel locationsModel;
    public DefaultNRepositoryModel repositoryModel;
    public DefaultNWorkspaceEventModel eventsModel;
    public DefaultNTextManagerModel textModel;
    public String uuid;
    public String location;
    public String name;
    public String hashName;
    public NId apiId;
    public NId runtimeId;
    public DefaultNInstalledRepository installedRepository;
    public final NScopedStack<NBeanContainer> scopedBeanContainerStack = new NScopedStack(null);
    public final NBeanContainer scopedBeanContainer = new StackBasedNBeanContainer();
    public DefaultNLogModel logModel;
    public DefaultNWorkspaceEnvManagerModel envModel;
    public DefaultNPlatformModel sdkModel;
    public DefaultNWorkspaceExtensionModel extensionModel;
    public DefaultCustomCommandsModel commandModel;
    public DefaultImportModel importModel;
    public String apiDigest;
    public String installationDigest;
    public SafeRecommendationConnector recomm;
    public List<String> recommendedCompanions = new ArrayList<String>();
    public NPropertiesHolder properties = new NPropertiesHolder();
    public NVersion askedApiVersion;
    public NId askedRuntimeId;
    public NBootOptions initialBootOptions;
    public NLRUMap<NId, CachedSupplier<NDefinition>> cachedDefs = new NLRUMap(100);
    public DefaultNExtensions extensions;
    public NWorkspaceStore store;
    public DefaultElementMapperStore defaultElementMapperStore = new DefaultElementMapperStore();
    public NScopedValue<NProgressMonitor> currentProgressMonitors = new NScopedValue();

    public NWorkspaceModel(NWorkspace workspace, NBootOptions initialBootOptions) {
        this.workspace = workspace;
        this.logModel = new DefaultNLogModel(workspace);
        this.LOG = new DefaultNLog(DefaultNWorkspace.class.getName(), new NLogSPIJUL(DefaultNWorkspace.class.getName()), this.logModel, false);
        this.store = initialBootOptions.getIsolationLevel().orNull() == NIsolationLevel.MEMORY ? new NWorkspaceStoreInMemory() : new NWorkspaceStoreOnDisk();
        this.recomm = new SafeRecommendationConnector(new SimpleRecommendationConnector());
        this.initialBootOptions = initialBootOptions;
        this.commandModel = new DefaultCustomCommandsModel(workspace);
        this.importModel = new DefaultImportModel(workspace);
        this.eventsModel = new DefaultNWorkspaceEventModel(workspace);
        this.repositoryModel = new DefaultNRepositoryModel(workspace);
        this.extensions = new DefaultNExtensions(this);
        this.bootModel = new DefaultNBootModel(workspace, this, initialBootOptions, this.LOG);
    }

    public void init() {
        this.askedApiVersion = this.initialBootOptions.getApiVersion().orNull();
        this.askedRuntimeId = this.initialBootOptions.getRuntimeId().orNull();
        if (this.askedRuntimeId == null) {
            this.askedRuntimeId = NId.getRuntime("").get();
        }
        this.textModel = new DefaultNTextManagerModel(this.workspace);
        this.apiId = NId.getApi(Nuts.getVersion()).get();
        this.runtimeId = NId.get(this.askedRuntimeId.getGroupId(), this.askedRuntimeId.getArtifactId(), NVersion.get(this.askedRuntimeId.getVersion().toString()).get()).get();
        this.logModel.init(this.bootModel.getBootEffectiveOptions(), this.initialBootOptions);
        this.bootModel.init();
    }

    private class StackBasedNBeanContainer
    implements NBeanContainer {
        private StackBasedNBeanContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> NOptional<T> get(NBeanRef ref) {
            List<NBeanContainer> all;
            NScopedStack<NBeanContainer> nScopedStack = NWorkspaceModel.this.scopedBeanContainerStack;
            synchronized (nScopedStack) {
                all = NWorkspaceModel.this.scopedBeanContainerStack.getStackSnapshot();
            }
            NOptional firstError = null;
            for (int i = all.size() - 1; i >= 0; --i) {
                NBeanContainer e = all.get(i);
                NOptional r = e.get(ref);
                if (r.isPresent()) {
                    return r;
                }
                if (firstError != null) continue;
                firstError = r;
            }
            if (firstError != null) {
                return firstError;
            }
            return NOptional.ofNamedEmpty(NMsg.ofC("bean %s", ref));
        }
    }
}

