/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.core.NConfigItem;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.platform.NPlatformLocation;

public final class NWorkspaceConfigMain
extends NConfigItem
implements Cloneable {
    private static final long serialVersionUID = 4L;
    private List<NRepositoryRef> repositories;
    private boolean enablePreviewRepositories = true;
    private List<NCommandFactoryConfig> commandFactories;
    private Map<String, String> env = new LinkedHashMap<String, String>();
    private List<NPlatformLocation> platforms = new ArrayList<NPlatformLocation>();
    private List<String> imports = new ArrayList<String>();

    public boolean isEnablePreviewRepositories() {
        return this.enablePreviewRepositories;
    }

    public void setEnablePreviewRepositories(boolean enablePreviewRepositories) {
        this.enablePreviewRepositories = enablePreviewRepositories;
    }

    public List<NRepositoryRef> getRepositories() {
        return this.repositories;
    }

    public NWorkspaceConfigMain setRepositories(List<NRepositoryRef> repositories) {
        this.repositories = repositories;
        return this;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public NWorkspaceConfigMain setImports(List<String> imports) {
        this.imports = imports;
        return this;
    }

    public NWorkspaceConfigMain setCommandFactories(List<NCommandFactoryConfig> commandFactories) {
        this.commandFactories = commandFactories;
        return this;
    }

    public NWorkspaceConfigMain setPlatforms(List<NPlatformLocation> platforms) {
        this.platforms = platforms;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NWorkspaceConfigMain setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<NPlatformLocation> getPlatforms() {
        return this.platforms;
    }

    public List<NCommandFactoryConfig> getCommandFactories() {
        return this.commandFactories;
    }

    public NWorkspaceConfigMain copy() {
        try {
            NWorkspaceConfigMain cloned = (NWorkspaceConfigMain)this.clone();
            if (this.repositories != null) {
                cloned.repositories = this.repositories.stream().map(NRepositoryRef::copy).collect(Collectors.toList());
            }
            if (this.commandFactories != null) {
                cloned.commandFactories = this.commandFactories.stream().map(x -> x.copy()).collect(Collectors.toList());
            }
            if (this.env != null) {
                cloned.env = new LinkedHashMap<String, String>(this.env);
            }
            if (this.platforms != null) {
                cloned.platforms = this.platforms.stream().map(x -> x.copy()).collect(Collectors.toList());
            }
            if (this.imports != null) {
                cloned.imports = new ArrayList<String>(this.imports);
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

