/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NConfigItem;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;

public final class NWorkspaceConfigBoot
extends NConfigItem
implements Cloneable {
    private static final long serialVersionUID = 830L;
    private String uuid = null;
    private boolean system;
    private String name = null;
    private String workspace = null;
    private List<String> bootRepositories = null;
    private Map<NStoreType, String> storeLocations = null;
    private Map<NHomeLocation, String> homeLocations = null;
    private NStoreStrategy repositoryStoreStrategy = null;
    private NStoreStrategy storeStrategy = null;
    private NOsFamily storeLayout = null;
    private List<ExtensionConfig> extensions;

    public String getName() {
        return this.name;
    }

    public NWorkspaceConfigBoot setName(String name) {
        this.name = name;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public NWorkspaceConfigBoot setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public NWorkspaceConfigBoot setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<String> getBootRepositories() {
        return this.bootRepositories;
    }

    public NWorkspaceConfigBoot setBootRepositories(List<String> bootRepositories) {
        this.bootRepositories = bootRepositories;
        return this;
    }

    public Map<NStoreType, String> getStoreLocations() {
        return this.storeLocations;
    }

    public NWorkspaceConfigBoot setStoreLocations(Map<NStoreType, String> storeLocations) {
        this.storeLocations = storeLocations;
        return this;
    }

    public Map<NHomeLocation, String> getHomeLocations() {
        return this.homeLocations;
    }

    public NWorkspaceConfigBoot setHomeLocations(Map<NHomeLocation, String> homeLocations) {
        this.homeLocations = homeLocations;
        return this;
    }

    public NStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public NWorkspaceConfigBoot setStoreStrategy(NStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public NOsFamily getStoreLayout() {
        return this.storeLayout;
    }

    public NWorkspaceConfigBoot setStoreLayout(NOsFamily storeLayout) {
        this.storeLayout = storeLayout;
        return this;
    }

    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.repositoryStoreStrategy;
    }

    public NWorkspaceConfigBoot setRepositoryStoreStrategy(NStoreStrategy repositoryStoreStrategy) {
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public NWorkspaceConfigBoot setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public boolean isSystem() {
        return this.system;
    }

    public NWorkspaceConfigBoot setSystem(boolean system) {
        this.system = system;
        return this;
    }

    public NWorkspaceConfigBoot copy() {
        try {
            NWorkspaceConfigBoot cloned = (NWorkspaceConfigBoot)this.clone();
            if (cloned.storeLocations != null) {
                cloned.storeLocations = new LinkedHashMap<NStoreType, String>(cloned.storeLocations);
            }
            if (cloned.homeLocations != null) {
                cloned.homeLocations = new LinkedHashMap<NHomeLocation, String>(cloned.homeLocations);
            }
            if (cloned.extensions != null) {
                cloned.extensions = this.extensions.stream().map(x -> x.copy()).collect(Collectors.toList());
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ExtensionConfig
    extends NConfigItem
    implements Cloneable {
        private NId id;
        private boolean enabled;
        private String dependencies;

        public ExtensionConfig() {
        }

        public ExtensionConfig(NId id, String dependencies, boolean enabled) {
            this.id = id;
            this.enabled = enabled;
            this.dependencies = dependencies;
        }

        public String getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(String dependencies) {
            this.dependencies = dependencies;
        }

        public NId getId() {
            return this.id;
        }

        public void setId(NId id) {
            this.id = id;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.dependencies, this.enabled);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtensionConfig that = (ExtensionConfig)o;
            return this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.dependencies, that.dependencies);
        }

        public ExtensionConfig copy() {
            try {
                return (ExtensionConfig)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

