/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NBlankable;

public class NStoreLocationsMap {
    private Map<NStoreType, String> locations;

    public NStoreLocationsMap(Map<NStoreType, String> locations) {
        this.locations = locations;
    }

    public String get(NStoreType location) {
        if (this.locations != null && location != null) {
            return this.locations.get(location);
        }
        return null;
    }

    public NStoreLocationsMap set(Map<NStoreType, String> locations) {
        this.set(new NStoreLocationsMap(locations));
        return this;
    }

    public NStoreLocationsMap set(NStoreLocationsMap other) {
        if (other != null) {
            for (NStoreType location : NStoreType.values()) {
                String v = other.get(location);
                if (NBlankable.isBlank(v)) continue;
                this.set(location, v);
            }
        }
        return this;
    }

    public NStoreLocationsMap set(NStoreType location, String value) {
        if (location != null) {
            if (NBlankable.isBlank(value)) {
                if (this.locations != null) {
                    this.locations.remove(location);
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<NStoreType, String>();
                }
                this.locations.put(location, value);
            }
        }
        return this;
    }

    public Map<NStoreType, String> toMap() {
        HashMap<NStoreType, String> map = new HashMap<NStoreType, String>();
        if (this.locations != null) {
            for (NStoreType location : NStoreType.values()) {
                String v = this.get(location);
                if (NBlankable.isBlank(v)) continue;
                map.put(location, v);
            }
        }
        return map;
    }

    public Map<NStoreType, String> toMapOrNull() {
        Map<NStoreType, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

