/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NBlankable;

public class NHomeLocationsMap {
    private Map<NHomeLocation, String> locations;

    public NHomeLocationsMap(Map<NHomeLocation, String> locations) {
        this.locations = locations;
    }

    public String get(NHomeLocation location) {
        if (this.locations != null && location != null) {
            return this.locations.get(location);
        }
        return null;
    }

    public NHomeLocationsMap set(Map<NHomeLocation, String> locations) {
        return this.set(new NHomeLocationsMap(locations));
    }

    public NHomeLocationsMap set(NHomeLocationsMap other) {
        if (other != null) {
            for (NStoreType location : NStoreType.values()) {
                String v = other.get(NHomeLocation.of(null, location));
                if (NBlankable.isBlank(v)) continue;
                this.set(NHomeLocation.of(null, location), v);
            }
            for (NStoreType location : NStoreType.values()) {
                for (NOsFamily osFamily : NOsFamily.values()) {
                    String v = other.get(NHomeLocation.of(osFamily, location));
                    if (NBlankable.isBlank(v)) continue;
                    this.set(NHomeLocation.of(osFamily, location), v);
                }
            }
        }
        return this;
    }

    public NHomeLocationsMap set(NHomeLocation type, String value) {
        NStoreType storeLocation = type.getStoreLocation();
        if (storeLocation != null) {
            if (NBlankable.isBlank(value)) {
                if (this.locations != null) {
                    this.locations.remove(type);
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<NHomeLocation, String>();
                }
                this.locations.put(type, value);
            }
        }
        return this;
    }

    public Map<NHomeLocation, String> toMap() {
        HashMap<NHomeLocation, String> map = new HashMap<NHomeLocation, String>();
        if (this.locations != null) {
            for (NStoreType location : NStoreType.values()) {
                String v = this.get(NHomeLocation.of(null, location));
                if (NBlankable.isBlank(v)) continue;
                map.put(NHomeLocation.of(null, location), v);
            }
            for (NStoreType location : NStoreType.values()) {
                for (NOsFamily osFamily : NOsFamily.values()) {
                    String v = this.get(NHomeLocation.of(osFamily, location));
                    if (NBlankable.isBlank(v)) continue;
                    map.put(NHomeLocation.of(osFamily, location), v);
                }
            }
        }
        return map;
    }

    public Map<NHomeLocation, String> toMapOrNull() {
        Map<NHomeLocation, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

