/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.boot.NBootConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.NHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NEnum;

public final class DefaultNWorkspaceCurrentConfig {
    private final Map<NStoreType, String> userStoreLocations = new HashMap<NStoreType, String>();
    private final Map<NStoreType, String> effStoreLocationsMap = new HashMap<NStoreType, String>();
    private final Path[] effStoreLocationPath = new Path[NStoreType.values().length];
    private final Map<NHomeLocation, String> homeLocations = new HashMap<NHomeLocation, String>();
    private final NWorkspace workspace;
    private String name;
    private NId apiId;
    private NId bootRuntime;
    private NDescriptor runtimeBootDescriptor;
    private List<NDescriptor> extensionBootDescriptors;
    private List<String> bootRepositories;
    private String bootJavaCommand;
    private String bootJavaOptions;
    private NStoreStrategy storeStrategy;
    private NStoreStrategy repositoryStoreStrategy;
    private NOsFamily storeLayout;
    private Boolean system;

    public DefaultNWorkspaceCurrentConfig(NWorkspace workspace) {
        this.workspace = workspace;
    }

    public DefaultNWorkspaceCurrentConfig merge(NWorkspaceOptions c) {
        String o;
        if (c.getName() != null) {
            this.name = c.getName().orNull();
        }
        if (c.getRuntimeId().isPresent()) {
            this.setRuntimeId(c.getRuntimeId().get());
        }
        if (c.getJavaCommand().isPresent()) {
            this.bootJavaCommand = c.getJavaCommand().get();
        }
        if (c.getJavaOptions().isPresent()) {
            this.bootJavaOptions = c.getJavaOptions().get();
        }
        if (c.getStoreStrategy().isPresent()) {
            this.storeStrategy = c.getStoreStrategy().get();
        }
        if (c.getRepositoryStoreStrategy().isPresent()) {
            this.repositoryStoreStrategy = c.getRepositoryStoreStrategy().get();
        }
        if (c.getStoreLayout().isPresent()) {
            this.storeLayout = c.getStoreLayout().get();
        }
        for (Map.Entry<NStoreType, String> entry : new NStoreLocationsMap(c.getStoreLocations().orNull()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NEnum, String> entry : new NHomeLocationsMap(c.getHomeLocations().orNull()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.homeLocations.put((NHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.system == null) {
            this.system = c.getSystem().orElse(false);
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig mergeRuntime(NWorkspaceOptions c) {
        if (c.getRuntimeId().isPresent()) {
            this.bootRuntime = c.getRuntimeId().get();
        }
        if (c.getJavaCommand().isPresent()) {
            this.bootJavaCommand = c.getJavaCommand().get();
        }
        if (c.getJavaOptions().isPresent()) {
            this.bootJavaOptions = c.getJavaOptions().get();
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig build(NPath workspaceLocation) {
        if (this.storeStrategy == null) {
            this.storeStrategy = NStoreStrategy.EXPLODED;
        }
        if (this.repositoryStoreStrategy == null) {
            this.repositoryStoreStrategy = NStoreStrategy.EXPLODED;
        }
        Map<NStoreType, String> storeLocations = NPlatformHome.of(this.getStoreLayout(), this.getSystem()).buildLocations(this.storeStrategy, this.getStoreLocations(), this.homeLocations, workspaceLocation == null ? null : workspaceLocation.toString());
        this.effStoreLocationsMap.clear();
        this.effStoreLocationsMap.putAll(storeLocations);
        for (int i = 0; i < this.effStoreLocationPath.length; ++i) {
            this.effStoreLocationPath[i] = Paths.get(this.effStoreLocationsMap.get(NStoreType.values()[i]), new String[0]);
        }
        if (this.apiId == null) {
            this.apiId = NId.getApi(Nuts.getVersion()).get();
        }
        if (this.storeLayout == null) {
            this.storeLayout = NWorkspace.of().getOsFamily();
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig merge(NWorkspaceConfigApi c) {
        if (c.getApiVersion() != null && !c.getApiVersion().isBlank()) {
            this.apiId = NId.getApi(c.getApiVersion()).get();
        }
        if (c.getRuntimeId() != null) {
            this.bootRuntime = c.getRuntimeId();
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig merge(NWorkspaceConfigRuntime c) {
        if (c.getId() != null) {
            this.bootRuntime = c.getId();
        }
        if (c.getDependencies() != null) {
            this.runtimeBootDescriptor = new DefaultNDescriptorBuilder().setId(NId.get(this.bootRuntime.toString()).get()).setDependencies(StringTokenizerUtils.splitSemiColon(c.getDependencies()).stream().map(x -> NDependency.get(x).get()).collect(Collectors.toList())).build();
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig merge(NWorkspaceConfigBoot c) {
        String o;
        if (c.getName() != null) {
            this.name = c.getName();
        }
        if (c.getStoreStrategy() != null) {
            this.storeStrategy = c.getStoreStrategy();
        }
        if (c.getRepositoryStoreStrategy() != null) {
            this.repositoryStoreStrategy = c.getRepositoryStoreStrategy();
        }
        if (c.getStoreLayout() != null) {
            this.storeLayout = c.getStoreLayout();
        }
        for (Map.Entry<NStoreType, String> entry : new NStoreLocationsMap(c.getStoreLocations()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NEnum, String> entry : new NHomeLocationsMap(c.getHomeLocations()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.homeLocations.put((NHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.system == null) {
            this.system = c.isSystem();
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig merge(NBootConfig c) {
        String o;
        this.name = c.getName();
        if (c.getApiVersion() != null) {
            this.apiId = NId.get("net.thevpc.nuts:nuts#" + c.getApiVersion()).get();
        }
        if (c.getRuntimeId() != null) {
            this.bootRuntime = c.getRuntimeId();
        }
        if (c.getRuntimeBootDescriptor() != null) {
            this.runtimeBootDescriptor = c.getRuntimeBootDescriptor();
        }
        if (c.getExtensionBootDescriptors() != null) {
            this.extensionBootDescriptors = c.getExtensionBootDescriptors();
        }
        if (c.getBootRepositories() != null) {
            this.bootRepositories = c.getBootRepositories();
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        if (c.getStoreStrategy() != null) {
            this.storeStrategy = c.getStoreStrategy();
        }
        if (c.getRepositoryStoreStrategy() != null) {
            this.repositoryStoreStrategy = c.getRepositoryStoreStrategy();
        }
        if (c.getStoreLayout() != null) {
            this.storeLayout = c.getStoreLayout();
        }
        for (Map.Entry<NStoreType, String> entry : new NStoreLocationsMap(c.getStoreLocations()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NEnum, String> entry : new NHomeLocationsMap(c.getHomeLocations()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NBlankable.isBlank(o)) continue;
            this.homeLocations.put((NHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.system == null) {
            this.system = c.isSystem();
        }
        return this;
    }

    public List<NDescriptor> getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public DefaultNWorkspaceCurrentConfig setExtensionBootDescriptors(List<NDescriptor> extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DefaultNWorkspaceCurrentConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean getSystem() {
        return this.system;
    }

    public boolean isSystem() {
        return this.system != null && this.system != false;
    }

    public DefaultNWorkspaceCurrentConfig setSystem(boolean system) {
        this.system = system;
        return this;
    }

    public NVersion getApiVersion() {
        return this.getApiId().getVersion();
    }

    public NId getApiId() {
        return this.apiId;
    }

    public DefaultNWorkspaceCurrentConfig setApiId(NId apiId) {
        this.apiId = apiId;
        return this;
    }

    public NId getRuntimeId() {
        return this.bootRuntime;
    }

    public DefaultNWorkspaceCurrentConfig setRuntimeId(NId bootRuntime) {
        this.bootRuntime = bootRuntime;
        return this;
    }

    public NDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public DefaultNWorkspaceCurrentConfig setRuntimeBootDescriptor(NDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public List<String> getBootRepositories() {
        return this.bootRepositories;
    }

    public DefaultNWorkspaceCurrentConfig setBootRepositories(List<String> bootRepositories) {
        this.bootRepositories = bootRepositories;
        return this;
    }

    public String getJavaCommand() {
        return this.bootJavaCommand;
    }

    public String getJavaOptions() {
        return this.bootJavaOptions;
    }

    public NStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public DefaultNWorkspaceCurrentConfig setStoreStrategy(NStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.repositoryStoreStrategy;
    }

    public DefaultNWorkspaceCurrentConfig setRepositoryStoreStrategy(NStoreStrategy repositoryStoreStrategy) {
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        return this;
    }

    public Map<NStoreType, String> getStoreLocations() {
        return new LinkedHashMap<NStoreType, String>(this.effStoreLocationsMap);
    }

    public Map<NHomeLocation, String> getHomeLocations() {
        return new LinkedHashMap<NHomeLocation, String>(this.homeLocations);
    }

    public DefaultNWorkspaceCurrentConfig setHomeLocations(Map<NHomeLocation, String> homeLocations) {
        this.homeLocations.clear();
        if (homeLocations != null) {
            this.homeLocations.putAll(homeLocations);
        }
        return this;
    }

    public NPath getStoreLocation(NStoreType storeType) {
        Path p = this.effStoreLocationPath[storeType.ordinal()];
        return p == null ? null : NPath.of(p);
    }

    public NPath getHomeLocation(NHomeLocation location) {
        String s = new NHomeLocationsMap(this.homeLocations).get(location);
        return s == null ? null : NPath.of(s);
    }

    public NPath getHomeLocation(NStoreType storeType) {
        return NPath.of(Paths.get(NPlatformHome.of(this.getStoreLayout(), this.isSystem()).getWorkspaceLocation(storeType, this.getHomeLocations(), this.getName()), new String[0]));
    }

    public NOsFamily getStoreLayout() {
        return this.storeLayout;
    }

    public DefaultNWorkspaceCurrentConfig setStoreLayout(NOsFamily storeLayout) {
        this.storeLayout = storeLayout;
        return this;
    }

    public DefaultNWorkspaceCurrentConfig setUserStoreLocations(Map<NStoreType, String> userStoreLocations) {
        this.userStoreLocations.clear();
        if (userStoreLocations != null) {
            this.userStoreLocations.putAll(userStoreLocations);
        }
        return this;
    }

    public DefaultNWorkspaceCurrentConfig setBootJavaCommand(String bootJavaCommand) {
        this.bootJavaCommand = bootJavaCommand;
        return this;
    }

    public DefaultNWorkspaceCurrentConfig setBootJavaOptions(String bootJavaOptions) {
        this.bootJavaOptions = bootJavaOptions;
        return this;
    }

    public NPath getStoreLocation(String id, NStoreType storeType) {
        return this.getStoreLocation(NId.get(id).get(), storeType);
    }

    public NPath getStoreLocation(NId id, NStoreType storeType) {
        NPath storeLocation = this.getStoreLocation(storeType);
        if (storeLocation == null) {
            return null;
        }
        switch (storeType) {
            case CACHE: {
                return storeLocation.resolve("id").resolve(NWorkspace.of().getDefaultIdBasedir(id));
            }
            case CONF: {
                return storeLocation.resolve("id").resolve(NWorkspace.of().getDefaultIdBasedir(id));
            }
        }
        return storeLocation.resolve(NWorkspace.of().getDefaultIdBasedir(id));
    }
}

