/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.NBootDescriptor;
import net.thevpc.nuts.command.NCommandFactoryConfig;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.concurrent.NScopedValue;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.core.NWorkspaceStoredConfig;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNInstallInfo;
import net.thevpc.nuts.runtime.standalone.dependency.solver.NDependencySolverUtils;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.event.DefaultNWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.extension.NExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.io.path.NPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.spi.ClassLoaderPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.DotfilefsPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.FilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.GenericFilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.GithubfsPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.InvalidFilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NResourcePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.HtmlfsPath;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractSystemTerminalAdapter;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.UnmodifiableTerminal;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NRepositoryUtils;
import net.thevpc.nuts.runtime.standalone.session.NSessionUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.NBootHelper;
import net.thevpc.nuts.runtime.standalone.util.TimePeriod;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DummyNIndexStoreFactory;
import net.thevpc.nuts.runtime.standalone.workspace.config.NHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.NVersionCompat;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.runtime.standalone.xtra.rnsh.RnshPathFactorySPI;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NDependencySolver;
import net.thevpc.nuts.spi.NDependencySolverFactory;
import net.thevpc.nuts.spi.NIndexStoreFactory;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositorySelectorList;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCaseInsensitiveStringMap;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NMaps;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNWorkspaceConfigModel {
    private static Pattern PRELOAD_EXTENSION_PATH_PATTERN = Pattern.compile("^(?<protocol>[a-z][a-z0-9_-]*):.*");
    private final DefaultNWorkspace workspace;
    private final Map<String, NUserConfig> configUsers = new LinkedHashMap<String, NUserConfig>();
    private final NWorkspaceStoredConfig storedConfig = new NWorkspaceStoredConfigImpl();
    private final ClassLoader bootClassLoader;
    private final List<URL> bootClassWorldURLs;
    private final WorkspaceSystemTerminalAdapter workspaceSystemTerminalAdapter;
    private final List<NPathFactorySPI> pathFactories = new ArrayList<NPathFactorySPI>();
    private final NPathFactorySPI invalidPathFactory;
    private final DefaultNBootModel bootModel;
    protected NWorkspaceConfigBoot storeModelBoot = new NWorkspaceConfigBoot();
    protected NWorkspaceConfigApi storeModelApi = new NWorkspaceConfigApi();
    protected NWorkspaceConfigRuntime storeModelRuntime = new NWorkspaceConfigRuntime();
    protected NWorkspaceConfigSecurity storeModelSecurity = new NWorkspaceConfigSecurity();
    protected NWorkspaceConfigMain storeModelMain = new NWorkspaceConfigMain();
    protected Map<String, NDependencySolverFactory> dependencySolvers;
    private DefaultNWorkspaceCurrentConfig currentConfig;
    private boolean storeModelBootChanged = false;
    private boolean storeModelApiChanged = false;
    private boolean storeModelRuntimeChanged = false;
    private boolean storeModelSecurityChanged = false;
    private boolean storeModelMainChanged = false;
    private Instant startCreateTime;
    private Instant endCreateTime;
    private NIndexStoreFactory indexStoreClientFactory;
    private NStoreLocationsMap preUpdateConfigStoreLocations;
    private NRepositorySelectorList parsedBootRepositoriesList;
    private ExecutorService executorService;
    private NTerminal terminal;
    private Map<String, NId> protocolToExtensionMap = new HashMap<String, NId>(NMaps.of("ssh", NId.get("net.thevpc.nuts:nuts-ssh").get()));
    public NScopedValue<Map<String, String>> currentEnv = NScopedValue.ofSupplier(this::rootEnv);

    public DefaultNWorkspaceConfigModel(DefaultNWorkspace workspace) {
        this.workspace = workspace;
        NBootOptions bOptions = NWorkspaceExt.of().getModel().bootModel.getBootEffectiveOptions();
        this.bootClassLoader = bOptions.getClassWorldLoader().orElseGet(() -> Thread.currentThread().getContextClassLoader());
        this.bootClassWorldURLs = NCollections.nonNullList((Collection)bOptions.getClassWorldURLs().orNull());
        this.workspaceSystemTerminalAdapter = new WorkspaceSystemTerminalAdapter(workspace);
        this.bootModel = workspace.getModel().bootModel;
        this.addPathFactory(new FilePath.FilePathFactory());
        this.addPathFactory(new ClassLoaderPath.ClasspathFactory());
        this.addPathFactory(new URLPath.URLPathFactory());
        this.addPathFactory(new NResourcePath.NResourceFactory());
        this.addPathFactory(new HtmlfsPath.HtmlfsFactory());
        this.addPathFactory(new DotfilefsPath.DotfilefsFactory());
        this.addPathFactory(new GithubfsPath.GithubfsFactory());
        this.addPathFactory(new GenericFilePath.GenericPathFactory());
        this.addPathFactory(new RnshPathFactorySPI());
        this.invalidPathFactory = new InvalidFilePathFactory();
    }

    public Map<String, String> appendEnv(Map<String, String> env) {
        Map<String, String> curr = this.currentEnv.get();
        Map<String, String> m = this.newSysEnvEmptyMap();
        m.putAll(curr);
        if (env != null) {
            for (Map.Entry<String, String> e : env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) continue;
                if (v == null) {
                    m.remove(k);
                    continue;
                }
                m.put(k, v);
            }
        }
        return m;
    }

    public Map<String, String> rootEnv() {
        Map<String, String> m = this.newSysEnvEmptyMap();
        m.putAll(System.getenv());
        return m;
    }

    public Map<String, String> newSysEnvEmptyMap() {
        switch (this.workspace.getEnvModel().getOsFamily()) {
            case WINDOWS: {
                return new NCaseInsensitiveStringMap<String>();
            }
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> sysEnv() {
        return this.currentEnv.get();
    }

    public void onNewComponent(Class componentType) {
        if (NPathFactorySPI.class.isAssignableFrom(componentType)) {
            DefaultNWorkspaceFactory aa = (DefaultNWorkspaceFactory)this.workspace.getModel().extensionModel.getObjectFactory();
            this.addPathFactory(aa.newInstance(componentType, NPathFactorySPI.class));
        }
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNWorkspaceConfigModel.class);
    }

    public DefaultNWorkspaceCurrentConfig getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(DefaultNWorkspaceCurrentConfig currentConfig) {
        this.currentConfig = currentConfig;
    }

    public NWorkspaceStoredConfig stored() {
        return this.storedConfig;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootClassLoader;
    }

    public List<URL> getBootClassWorldURLs() {
        return this.bootClassWorldURLs == null ? Collections.emptyList() : this.bootClassWorldURLs;
    }

    public boolean isReadOnly() {
        return NWorkspaceExt.of().getModel().bootModel.getBootUserOptions().getReadOnly().orElse(false);
    }

    public boolean save(boolean force) {
        if (!force && !this.isConfigurationChanged()) {
            return false;
        }
        NWorkspaceUtils.of().checkReadOnly();
        boolean ok = false;
        NWorkspaceSecurityManager.of().checkAllowed("save", "save");
        if (force || this.storeModelBootChanged) {
            this.storeModelBoot.setConfigVersion(DefaultNWorkspace.VERSION_WS_CONFIG_BOOT);
            if (this.storeModelBoot.getExtensions() != null) {
                for (NWorkspaceConfigBoot.ExtensionConfig extension : this.storeModelBoot.getExtensions()) {
                    extension.setConfigVersion(null);
                }
            }
            this.workspace.store().saveWorkspaceConfigBoot(this.storeModelBoot);
            this.storeModelBootChanged = false;
            ok = true;
        }
        if (force || this.storeModelSecurityChanged) {
            this.storeModelSecurity.setUsers(this.configUsers.isEmpty() ? null : this.configUsers.values().toArray(new NUserConfig[0]));
            this.storeModelSecurity.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NUserConfig extension : this.storeModelSecurity.getUsers()) {
                    extension.setConfigVersion(null);
                }
            }
            this.workspace.store().saveConfigSecurity(this.storeModelSecurity);
            this.storeModelSecurityChanged = false;
            ok = true;
        }
        if (force || this.storeModelMainChanged) {
            NUserConfig[] plainSdks = new ArrayList();
            plainSdks.addAll(NWorkspace.of().findPlatforms().toList());
            this.storeModelMain.setPlatforms((List<NPlatformLocation>)plainSdks);
            this.storeModelMain.setRepositories(this.workspace.getRepositories().stream().filter(x -> !x.config().isTemporary()).map(x -> x.config().getRepositoryRef()).collect(Collectors.toList()));
            this.storeModelMain.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelMain.getCommandFactories() != null) {
                for (NCommandFactoryConfig item : this.storeModelMain.getCommandFactories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getRepositories() != null) {
                for (NRepositoryRef item : this.storeModelMain.getRepositories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getPlatforms() != null) {
                for (NPlatformLocation item : this.storeModelMain.getPlatforms()) {
                    item.setConfigVersion(null);
                }
            }
            this.workspace.store().saveConfigMain(this.storeModelMain);
            this.storeModelMainChanged = false;
            ok = true;
        }
        if (force || this.storeModelApiChanged) {
            this.storeModelApi.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NUserConfig item : this.storeModelSecurity.getUsers()) {
                    item.setConfigVersion(null);
                }
            }
            this.workspace.store().saveConfigApi(this.storeModelApi);
            this.storeModelApiChanged = false;
            ok = true;
        }
        if (force || this.storeModelRuntimeChanged) {
            this.storeModelRuntime.setConfigVersion(this.current().getApiVersion());
            this.workspace.store().saveConfigRuntime(this.storeModelRuntime);
            this.storeModelRuntimeChanged = false;
            ok = true;
        }
        NException error = null;
        for (NRepository repo : this.workspace.getRepositories()) {
            try {
                if (!(repo.config() instanceof NRepositoryConfigManagerExt)) continue;
                ok |= ((NRepositoryConfigManagerExt)((Object)repo.config())).getModel().save(force);
            }
            catch (NException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return ok;
    }

    public boolean save() {
        return this.save(true);
    }

    public boolean isExcludedExtension(String extensionId, NWorkspaceOptions options) {
        if (extensionId != null && options != null) {
            NId pnid = NId.get(extensionId).get();
            String shortName = pnid.getShortName();
            String artifactId = pnid.getArtifactId();
            for (String excludedExtensionList : options.getExcludedExtensions().orElseGet(Collections::emptyList)) {
                for (String s : StringTokenizerUtils.splitDefault(excludedExtensionList)) {
                    if (s.length() <= 0 || !s.equals(shortName) && !s.equals(artifactId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public NBootOptions getBootUserOptions() {
        return NWorkspaceExt.of().getModel().bootModel.getBootUserOptions();
    }

    public boolean isSupportedRepositoryType(String repositoryType) {
        if (NBlankable.isBlank(repositoryType)) {
            repositoryType = "nuts";
        }
        return NExtensions.of().createComponents(NRepositoryFactoryComponent.class, new NRepositoryConfig().setLocation(NRepositoryLocation.of(repositoryType + "@"))).size() > 0;
    }

    public List<NAddRepositoryOptions> getDefaultRepositories() {
        ArrayList<NAddRepositoryOptions> all = new ArrayList<NAddRepositoryOptions>();
        for (NRepositoryFactoryComponent provider : NExtensions.of().createAll(NRepositoryFactoryComponent.class)) {
            for (NAddRepositoryOptions d : provider.getDefaultRepositories()) {
                all.add(d);
            }
        }
        Collections.sort(all, new Comparator<NAddRepositoryOptions>(){

            @Override
            public int compare(NAddRepositoryOptions o1, NAddRepositoryOptions o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return all;
    }

    public Set<String> getAvailableArchetypes() {
        HashSet<String> set = new HashSet<String>();
        set.add("default");
        for (NWorkspaceArchetypeComponent extension : NExtensions.of().createComponents(NWorkspaceArchetypeComponent.class, null)) {
            set.add(extension.getName());
        }
        return set;
    }

    public NPath resolveRepositoryPath(NPath repositoryLocation) {
        NPath root = this.getRepositoriesRoot();
        return repositoryLocation.toAbsolute(root != null ? root : NPath.ofWorkspaceStore(NStoreType.CONF).resolve("repos"));
    }

    public NIndexStoreFactory getIndexStoreClientFactory() {
        return this.indexStoreClientFactory;
    }

    public List<String> getBootRepositories() {
        return this.current().getBootRepositories();
    }

    public String getJavaCommand() {
        return this.current().getJavaCommand();
    }

    public String getJavaOptions() {
        return this.current().getJavaOptions();
    }

    public boolean isSystem() {
        return this.current().getSystem();
    }

    public Instant getCreationStartTime() {
        return this.startCreateTime;
    }

    public Instant getCreationFinishTime() {
        return this.endCreateTime;
    }

    public NDuration getCreateDuration() {
        if (this.startCreateTime == null || this.endCreateTime == null) {
            return NDuration.ofMillis(0L);
        }
        return NDuration.between(this.startCreateTime, this.endCreateTime);
    }

    public NWorkspaceConfigMain getStoreModelMain() {
        return this.storeModelMain;
    }

    public DefaultNWorkspaceCurrentConfig current() {
        if (this.currentConfig == null) {
            throw new IllegalStateException("unable to use workspace.current(). Still in initialize status");
        }
        return this.currentConfig;
    }

    public void setStartCreateTime(Instant startCreateTime) {
        this.startCreateTime = startCreateTime;
    }

    public void setConfigBoot(NWorkspaceConfigBoot config) {
        this.setConfigBoot(config, true);
    }

    public void setConfigApi(NWorkspaceConfigApi config) {
        this.setConfigApi(config, true);
    }

    public void setConfigRuntime(NWorkspaceConfigRuntime config) {
        this.setConfigRuntime(config, true);
    }

    public void setConfigSecurity(NWorkspaceConfigSecurity config) {
        this.setConfigSecurity(config, true);
    }

    public void setConfigMain(NWorkspaceConfigMain config) {
        this.setConfigMain(config, true);
    }

    public void setEndCreateTime(Instant endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public void installBootIds() {
        NWorkspaceModel wsModel = NWorkspaceExt.of().getModel();
        NId iruntimeId = wsModel.bootModel.getBootEffectiveOptions().getRuntimeId().orNull();
        if (wsModel.bootModel.getBootEffectiveOptions().getRuntimeBootDescriptor().isPresent()) {
            NBootDescriptor d = wsModel.bootModel.getBootEffectiveOptions().getRuntimeBootDescriptor().get();
            iruntimeId = NId.get(d.getId().toString()).get();
        }
        wsModel.configModel.prepareBootClassPathConf(NIdType.API, this.workspace.getApiId(), null, iruntimeId, false, false);
        NBootDef nBootNutsApi = null;
        try {
            nBootNutsApi = wsModel.configModel.prepareBootClassPathJar(this.workspace.getApiId(), null, iruntimeId, false);
        }
        catch (Exception ex) {
            this._LOG().log(NMsg.ofC("unable to install boot id (api) %s", this.workspace.getApiId()).withLevel(Level.SEVERE));
        }
        if (nBootNutsApi == null) {
            return;
        }
        NBootDef nBootNutsRuntime = null;
        try {
            wsModel.configModel.prepareBootClassPathConf(NIdType.RUNTIME, iruntimeId, this.workspace.getApiId(), null, false, true);
            nBootNutsRuntime = wsModel.configModel.prepareBootClassPathJar(iruntimeId, this.workspace.getApiId(), null, true);
        }
        catch (Exception ex) {
            this._LOG().log(NMsg.ofC("unable to install boot id (runtime) %s", iruntimeId).withLevel(Level.SEVERE));
        }
        if (nBootNutsRuntime == null) {
            return;
        }
        List<NWorkspaceConfigBoot.ExtensionConfig> extensions = this.getStoredConfigBoot().getExtensions();
        if (extensions != null) {
            for (NWorkspaceConfigBoot.ExtensionConfig extension : extensions) {
                if (!extension.isEnabled()) continue;
                try {
                    wsModel.configModel.prepareBootClassPathConf(NIdType.EXTENSION, extension.getId(), this.workspace.getApiId(), null, false, true);
                    wsModel.configModel.prepareBootClassPathJar(extension.getId(), this.workspace.getApiId(), null, true);
                }
                catch (Exception ex) {
                    this._LOG().log(NMsg.ofC("unable to install boot id (extension) %s", extension.getId()).asError());
                }
            }
        }
    }

    public boolean isConfigurationChanged() {
        return this.storeModelBootChanged || this.storeModelApiChanged || this.storeModelRuntimeChanged || this.storeModelSecurityChanged || this.storeModelMainChanged;
    }

    public boolean loadWorkspace() {
        try {
            NWorkspaceConfigMain mconfig;
            NWorkspaceConfigSecurity sconfig;
            NWorkspaceConfigRuntime rconfig;
            boolean _storeModelBootChanged = false;
            boolean _storeModelApiChanged = false;
            boolean _storeModelRuntimeChanged = false;
            boolean _storeModelSecurityChanged = false;
            boolean _storeModelMainChanged = false;
            NWorkspaceConfigBoot _config = this.parseBootConfig();
            if (_config == null) {
                return false;
            }
            DefaultNWorkspaceCurrentConfig cConfig = new DefaultNWorkspaceCurrentConfig(this.workspace).merge(_config);
            DefaultNBootModel bm = NWorkspaceExt.of().getModel().bootModel;
            NBootOptions effOptions = bm.getBootEffectiveOptions();
            NBootOptions userOptions = bm.getBootUserOptions();
            if (cConfig.getApiId() == null) {
                cConfig.setApiId(NId.getApi(effOptions.getApiVersion().orNull()).get());
            }
            if (cConfig.getRuntimeId() == null) {
                cConfig.setRuntimeId(effOptions.getRuntimeId().orNull());
            }
            if (cConfig.getRuntimeBootDescriptor() == null) {
                cConfig.setRuntimeBootDescriptor(effOptions.getRuntimeBootDescriptor().map(x -> new DefaultNDescriptorBuilder().copyFrom((NBootDescriptor)x).build()).orNull());
            }
            if (cConfig.getExtensionBootDescriptors() == null) {
                cConfig.setExtensionBootDescriptors(effOptions.getExtensionBootDescriptors().map(x -> x.stream().map(y -> y == null ? null : new DefaultNDescriptorBuilder().copyFrom((NBootDescriptor)y).build()).collect(Collectors.toList())).orNull());
            }
            if (cConfig.getBootRepositories() == null) {
                cConfig.setBootRepositories(effOptions.getBootRepositories().orNull());
            }
            cConfig.merge(this.getBootUserOptions().toWorkspaceOptions());
            this.setCurrentConfig(cConfig.build(NWorkspace.of().getWorkspaceLocation()));
            NVersionCompat compat = NVersionCompat.of(Nuts.getVersion());
            NId apiId = this.workspace.getApiId();
            NWorkspaceConfigApi aconfig = compat.parseApiConfig(apiId);
            NId toImportOlderId = null;
            if (aconfig != null) {
                cConfig.merge(aconfig);
            } else {
                List<NId> olderIds = this.findOlderNutsApiIds();
                for (NId olderId : olderIds) {
                    aconfig = compat.parseApiConfig(olderId);
                    if (aconfig == null) continue;
                    if (!NAsk.of().forBoolean(NMsg.ofC("import older config %s into %s", olderId, apiId)).setDefaultValue(true).getBooleanValue().booleanValue()) break;
                    toImportOlderId = olderId;
                    aconfig.setRuntimeId(null);
                    aconfig.setApiVersion(null);
                    cConfig.merge(aconfig);
                    _storeModelApiChanged = true;
                    break;
                }
            }
            if (cConfig.getApiId() == null) {
                cConfig.setApiId(NId.getApi(Nuts.getVersion()).get());
            }
            if (cConfig.getRuntimeId() == null) {
                cConfig.setRuntimeId(effOptions.getRuntimeId().orNull());
            }
            if ((rconfig = compat.parseRuntimeConfig()) != null) {
                cConfig.merge(rconfig);
            }
            if ((sconfig = compat.parseSecurityConfig(apiId)) == null && toImportOlderId != null) {
                sconfig = compat.parseSecurityConfig(toImportOlderId);
            }
            if ((mconfig = compat.parseMainConfig(apiId)) == null && toImportOlderId != null) {
                mconfig = compat.parseMainConfig(toImportOlderId);
            }
            if (userOptions.getRecover().orElse(false).booleanValue() || userOptions.getReset().orElse(false).booleanValue()) {
                cConfig.setApiId(NId.getApi(effOptions.getApiVersion().orNull()).get());
                cConfig.setRuntimeId(effOptions.getRuntimeId().orNull());
                cConfig.setRuntimeBootDescriptor(NBootHelper.toDescriptor(effOptions.getRuntimeBootDescriptor().orNull()));
                cConfig.setExtensionBootDescriptors(NBootHelper.toDescriptorList(effOptions.getExtensionBootDescriptors().orNull()));
                cConfig.setBootRepositories(effOptions.getBootRepositories().orNull());
            }
            this.setCurrentConfig(cConfig.build(NWorkspace.of().getWorkspaceLocation()));
            if (aconfig == null) {
                aconfig = new NWorkspaceConfigApi();
            }
            if (aconfig.getApiVersion() == null) {
                aconfig.setApiVersion(cConfig.getApiId().getVersion());
            }
            if (aconfig.getRuntimeId() == null) {
                aconfig.setRuntimeId(cConfig.getRuntimeId());
            }
            this.setConfigBoot(_config, false);
            this.setConfigApi(aconfig, false);
            this.setConfigRuntime(rconfig, false);
            this.setConfigSecurity(sconfig, false);
            this.setConfigMain(mconfig, false);
            this.storeModelBootChanged = _storeModelBootChanged;
            this.storeModelApiChanged = _storeModelApiChanged;
            this.storeModelRuntimeChanged = _storeModelRuntimeChanged;
            this.storeModelSecurityChanged = _storeModelSecurityChanged;
            this.storeModelMainChanged = _storeModelMainChanged;
            return true;
        }
        catch (RuntimeException ex) {
            if (!NWorkspace.of().getBootOptions().getRecover().orElse(false).booleanValue()) {
                throw ex;
            }
            this.onLoadWorkspaceError(ex);
            return false;
        }
    }

    private List<NId> findOlderNutsApiIds() {
        NId apiId = this.workspace.getApiId();
        NPath path = NPath.ofIdStore(apiId, NStoreType.CONF).getParent();
        List<NId> olderIds = ((NStream)((NStream)((NStream)((NStream)path.stream().filter(NPath::isDirectory).redescribe(NElementDescribables.ofDesc("isDirectory"))).map(x -> NVersion.get(x.getName()).get()).redescribe(NElementDescribables.ofDesc("toVersion"))).filter(x -> x.compareTo(apiId.getVersion()) < 0).redescribe(NElementDescribables.ofDesc("older"))).sorted(new NComparator<NVersion>(){

            @Override
            public int compare(NVersion o1, NVersion o2) {
                return Comparator.reverseOrder().compare(o1, o2);
            }

            @Override
            public NElement describe() {
                return NElement.ofString("reverseOrder");
            }
        }).map(x -> apiId.builder().setVersion((NVersion)x).build()).redescribe(NElementDescribables.ofDesc("toId"))).toList();
        return olderIds;
    }

    public void setBootApiVersion(NVersion value) {
        if (!Objects.equals(value, this.storeModelApi.getApiVersion())) {
            this.storeModelApi.setApiVersion(value);
            this.fireConfigurationChanged("api-version", ConfigEventType.API);
        }
    }

    public void setExtraBootExtensionId(NId apiId, NId extensionId, List<NDependency> deps) {
        String newDeps = deps.stream().map(Object::toString).collect(Collectors.joining(";"));
        NWorkspaceConfigBoot.ExtensionConfig cc = new NWorkspaceConfigBoot.ExtensionConfig();
        cc.setId(apiId);
        cc.setDependencies(newDeps);
        cc.setEnabled(true);
        NSession session = this.getWorkspace().currentSession();
        if (apiId.getVersion().equals(session.getWorkspace().getApiId().getVersion())) {
            NExtensionListHelper h = new NExtensionListHelper(session.getWorkspace().getApiId(), this.getStoredConfigBoot().getExtensions()).save();
            if (h.add(extensionId, deps)) {
                this.getStoredConfigBoot().setExtensions(h.getConfs());
                NWorkspaceExt.of().deployBoot(extensionId, true);
                this.fireConfigurationChanged("extensions", ConfigEventType.BOOT);
                DefaultNWorkspaceConfigModel configModel = NWorkspaceExt.of().getModel().configModel;
                configModel.save();
            }
        } else {
            NExtensionListHelper h2 = new NExtensionListHelper(session.getWorkspace().getApiId(), new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>());
            if (h2.add(extensionId, deps)) {
                NWorkspaceExt.of().deployBoot(extensionId, true);
            }
        }
        NPath runtimeVersionSpecificLocation = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id").resolve(NWorkspace.of().getDefaultIdBasedir(extensionId));
        NPath afile = runtimeVersionSpecificLocation.resolve("nuts-extension-boot-config.json");
        cc.setConfigVersion(this.current().getApiVersion());
        NElementWriter.ofJson().write((Object)cc, afile);
    }

    public void setExtraBootRuntimeId(NId apiId, NId runtimeId, List<NDependency> deps) {
        String newDeps = deps.stream().map(Object::toString).collect(Collectors.joining(";"));
        NSession session = this.getWorkspace().currentSession();
        if (apiId == null || apiId.getVersion().equals(session.getWorkspace().getApiId().getVersion())) {
            if (!Objects.equals(runtimeId.toString(), this.storeModelApi.getRuntimeId()) || !Objects.equals(newDeps, this.storeModelRuntime.getDependencies())) {
                this.storeModelApi.setRuntimeId(runtimeId);
                this.storeModelRuntime.setDependencies(newDeps);
                this.setConfigRuntime(this.storeModelRuntime, true);
                this.fireConfigurationChanged("runtime-id", ConfigEventType.API);
            }
            this.setBootRuntimeId(runtimeId, newDeps);
            this.save();
            return;
        }
        NWorkspaceConfigApi estoreModelApi = new NWorkspaceConfigApi();
        estoreModelApi.setApiVersion(apiId.getVersion());
        estoreModelApi.setRuntimeId(runtimeId);
        estoreModelApi.setConfigVersion(this.current().getApiVersion());
        NPath apiVersionSpecificLocation = NPath.ofIdStore(apiId, NStoreType.CONF);
        NPath afile = apiVersionSpecificLocation.resolve("nuts-api-boot-config.json");
        NElementWriter.ofJson().write((Object)estoreModelApi, afile);
        NWorkspaceConfigRuntime storeModelRuntime = new NWorkspaceConfigRuntime();
        storeModelRuntime.setId(runtimeId);
        storeModelRuntime.setDependencies(newDeps);
        NPath runtimeVersionSpecificLocation = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id").resolve(NWorkspace.of().getDefaultIdBasedir(runtimeId));
        afile = runtimeVersionSpecificLocation.resolve("nuts-runtime-boot-config.json");
        storeModelRuntime.setConfigVersion(this.current().getApiVersion());
        NElementWriter.ofJson().write((Object)storeModelRuntime, afile);
    }

    public void setBootRuntimeId(NId value, String dependencies) {
        if (!Objects.equals(value, this.storeModelApi.getRuntimeId()) || !Objects.equals(dependencies, this.storeModelRuntime.getDependencies())) {
            this.storeModelApi.setRuntimeId(value);
            this.storeModelRuntime.setDependencies(dependencies);
            this.setConfigRuntime(this.storeModelRuntime, true);
            this.fireConfigurationChanged("runtime-id", ConfigEventType.API);
        }
    }

    public void setBootRuntimeDependencies(String dependencies) {
        if (!Objects.equals(dependencies, this.storeModelRuntime.getDependencies())) {
            // empty if block
        }
    }

    public void setBootRepositories(List<String> value) {
        if (!Objects.equals(value, this.storeModelBoot.getBootRepositories())) {
            this.storeModelBoot.setBootRepositories(value);
            this.fireConfigurationChanged("boot-repositories", ConfigEventType.API);
        }
    }

    public NWorkspaceConfigBoot.ExtensionConfig getBootExtension(String value) {
        NId newId = NId.get(value).get();
        for (NWorkspaceConfigBoot.ExtensionConfig extension : this.storeModelBoot.getExtensions()) {
            NId id = extension.getId();
            if (!newId.equalsShortId(id)) continue;
            return extension;
        }
        return null;
    }

    public void setBootExtension(String value, String dependencies, boolean enabled) {
        NId newId = NId.get(value).get();
        for (NWorkspaceConfigBoot.ExtensionConfig extension : this.storeModelBoot.getExtensions()) {
            NId id = extension.getId();
            if (!newId.equalsShortId(id)) continue;
            extension.setId(newId);
            extension.setEnabled(enabled);
            extension.setDependencies(dependencies);
            this.fireConfigurationChanged("boot-extensions", ConfigEventType.API);
            return;
        }
        this.storeModelBoot.getExtensions().add(new NWorkspaceConfigBoot.ExtensionConfig(newId, dependencies, true));
    }

    public NUserConfig getUser(String userId) {
        NUserConfig _config = this.getSecurity(userId);
        if (_config == null && ("admin".equals(userId) || "anonymous".equals(userId))) {
            _config = new NUserConfig(userId, null, null, null);
            this.setUser(_config);
        }
        return _config;
    }

    public NUserConfig[] getUsers() {
        return this.configUsers.values().toArray(new NUserConfig[0]);
    }

    public void setUser(NUserConfig config) {
        if (config != null) {
            this.configUsers.put(config.getUser(), config);
            this.fireConfigurationChanged("user", ConfigEventType.SECURITY);
        }
    }

    public void removeUser(String userId) {
        NUserConfig old = this.getSecurity(userId);
        if (old != null) {
            this.configUsers.remove(userId);
            this.fireConfigurationChanged("users", ConfigEventType.SECURITY);
        }
    }

    public void setSecure(boolean secure) {
        if (secure != this.storeModelSecurity.isSecure()) {
            this.storeModelSecurity.setSecure(secure);
            this.fireConfigurationChanged("secure", ConfigEventType.SECURITY);
        }
    }

    public void fireConfigurationChanged(String configName, ConfigEventType t) {
        NSession session = this.getWorkspace().currentSession();
        this.workspace.getImportModel().invalidateCache();
        switch (t) {
            case API: {
                this.storeModelApiChanged = true;
                break;
            }
            case RUNTIME: {
                this.storeModelRuntimeChanged = true;
                break;
            }
            case SECURITY: {
                this.storeModelSecurityChanged = true;
                break;
            }
            case MAIN: {
                this.storeModelMainChanged = true;
                break;
            }
            case BOOT: {
                this.storeModelBootChanged = true;
            }
        }
        DefaultNWorkspaceEvent evt = new DefaultNWorkspaceEvent(session, null, "config." + configName, null, true);
        for (NWorkspaceListener workspaceListener : this.workspace.getWorkspaceListeners()) {
            workspaceListener.onConfigurationChanged(evt);
        }
    }

    public NWorkspaceConfigApi getStoredConfigApi() {
        if (this.storeModelApi.getApiVersion() == null || this.storeModelApi.getApiVersion().isBlank()) {
            this.storeModelApi.setApiVersion(Nuts.getVersion());
        }
        return this.storeModelApi;
    }

    public NWorkspaceConfigBoot getStoredConfigBoot() {
        return this.storeModelBoot;
    }

    public NWorkspaceConfigSecurity getStoredConfigSecurity() {
        return this.storeModelSecurity;
    }

    public NWorkspaceConfigMain getStoredConfigMain() {
        return this.storeModelMain;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public NDependencySolver createDependencySolver(String name) {
        NDependencySolverFactory c = this.getSolversMap().get(NDependencySolverUtils.resolveSolverName(name));
        if (c != null) {
            return c.create();
        }
        throw new NIllegalArgumentException(NMsg.ofC("dependency solver not found %s", name));
    }

    private Map<String, NDependencySolverFactory> getSolversMap() {
        if (this.dependencySolvers == null) {
            this.dependencySolvers = new LinkedHashMap<String, NDependencySolverFactory>();
            for (NDependencySolverFactory nutsDependencySolver : NExtensions.of().createComponents(NDependencySolverFactory.class, null)) {
                this.dependencySolvers.put(nutsDependencySolver.getName(), nutsDependencySolver);
            }
        }
        return this.dependencySolvers;
    }

    public NDependencySolverFactory[] getDependencySolvers() {
        return this.getSolversMap().values().toArray(new NDependencySolverFactory[0]);
    }

    public List<String> getDependencySolverNames() {
        return Arrays.stream(this.getDependencySolvers()).map(NDependencySolverFactory::getName).sorted(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (!o1.equals(o2)) {
                    String n = NDependencySolverUtils.resolveSolverName(NSession.of().getDependencySolver());
                    if (o1.equals(n)) {
                        return -1;
                    }
                    if (o2.equals(n)) {
                        return 1;
                    }
                }
                return o1.compareTo(o2);
            }
        }).collect(Collectors.toList());
    }

    public NPath getRepositoriesRoot() {
        return NPath.ofWorkspaceStore(NStoreType.CONF).resolve("repos");
    }

    public NPath getTempRepositoriesRoot() {
        return NPath.ofWorkspaceStore(NStoreType.TEMP).resolve("repos");
    }

    public NAuthenticationAgent createAuthenticationAgent(String authenticationAgent) {
        authenticationAgent = NStringUtils.trim(authenticationAgent);
        NAuthenticationAgent supported = null;
        NSession session = this.getWorkspace().currentSession();
        if (authenticationAgent.isEmpty()) {
            supported = NExtensions.of().createComponent(NAuthenticationAgent.class, "").get();
        } else {
            List<NAuthenticationAgent> agents = NExtensions.of().createComponents(NAuthenticationAgent.class, authenticationAgent);
            for (NAuthenticationAgent agent : agents) {
                if (!agent.getId().equals(authenticationAgent)) continue;
                supported = agent;
            }
        }
        if (supported == null) {
            return (NAuthenticationAgent)NOptional.ofNamedEmpty(NMsg.ofC("extensions component %s with agent=%s", NAuthenticationAgent.class, authenticationAgent)).get();
        }
        NSessionUtils.setSession(supported, session);
        return supported;
    }

    public void setUsers(NUserConfig[] users) {
        for (NUserConfig u : this.getUsers()) {
            this.removeUser(u.getUser());
        }
        for (NUserConfig conf : users) {
            this.setUser(conf);
        }
    }

    public NWorkspaceConfigRuntime getStoredConfigRuntime() {
        return this.storeModelRuntime;
    }

    public NId createSdkId(String type, String version) {
        return NWorkspaceUtils.of().createSdkId(type, version);
    }

    public void onExtensionsPrepared() {
        try {
            this.indexStoreClientFactory = NExtensions.of().createComponent(NIndexStoreFactory.class).orNull();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indexStoreClientFactory == null) {
            this.indexStoreClientFactory = new DummyNIndexStoreFactory();
        }
    }

    public void setConfigApi(NWorkspaceConfigApi config, boolean fire) {
        NWorkspaceConfigApi nWorkspaceConfigApi = this.storeModelApi = config == null ? new NWorkspaceConfigApi() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-api-config", ConfigEventType.API);
        }
    }

    public void setConfigRuntime(NWorkspaceConfigRuntime config, boolean fire) {
        NWorkspaceConfigRuntime nWorkspaceConfigRuntime = this.storeModelRuntime = config == null ? new NWorkspaceConfigRuntime() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-runtime-config", ConfigEventType.RUNTIME);
        }
    }

    private void setConfigSecurity(NWorkspaceConfigSecurity config, boolean fire) {
        this.storeModelSecurity = config == null ? new NWorkspaceConfigSecurity() : config;
        this.configUsers.clear();
        if (this.storeModelSecurity.getUsers() != null) {
            for (NUserConfig s : this.storeModelSecurity.getUsers()) {
                this.configUsers.put(s.getUser(), s);
            }
        }
        this.storeModelSecurityChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-security", ConfigEventType.SECURITY);
        }
    }

    private void setConfigMain(NWorkspaceConfigMain config, boolean fire) {
        this.storeModelMain = config == null ? new NWorkspaceConfigMain() : config;
        this.workspace.getSdkModel().setPlatforms(this.storeModelMain.getPlatforms().toArray(new NPlatformLocation[0]));
        this.workspace.removeAllRepositories();
        List<NRepositoryRef> refsToLoad = this.storeModelMain.getRepositories();
        if (refsToLoad != null) {
            refsToLoad = new ArrayList<NRepositoryRef>(refsToLoad);
            this.storeModelMain.setRepositories(new ArrayList<NRepositoryRef>());
            for (NRepositoryRef ref : refsToLoad) {
                this.workspace.addRepository(NRepositoryUtils.refToOptions(ref));
            }
        }
        this.storeModelMainChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-main", ConfigEventType.MAIN);
        }
    }

    private void setConfigBoot(NWorkspaceConfigBoot config, boolean fire) {
        this.storeModelBoot = config;
        if (NBlankable.isBlank(config.getUuid())) {
            config.setUuid(UUID.randomUUID().toString());
            fire = true;
        }
        if (fire) {
            this.fireConfigurationChanged("config-master", ConfigEventType.BOOT);
        }
    }

    public String toString() {
        String s1 = "NULL";
        String s2 = "NULL";
        s1 = this.workspace == null ? "?" : this.workspace.getApiId().toString();
        s2 = this.workspace == null ? "?" : String.valueOf(this.workspace.getRuntimeId());
        return "NutsWorkspaceConfig{workspaceBootId=" + s1 + ", workspaceRuntimeId=" + s2 + ", workspace=" + (this.currentConfig == null ? "NULL" : "'" + (this.workspace == null ? "?" : "" + NWorkspaceExt.of(this.workspace).getLocationModel().getWorkspaceLocation()) + '\'') + '}';
    }

    public void collect(NClassLoaderNode n, LinkedHashMap<NId, NClassLoaderNode> deps) {
        if (!deps.containsKey(n.getId())) {
            deps.put(n.getId(), n);
            for (NClassLoaderNode d : n.getDependencies()) {
                this.collect(d, deps);
            }
        }
    }

    public NBootDef fetchBootDef(NId id, boolean content) {
        NDefinition nd = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFailFast(false).getResultDefinition();
        if (nd != null) {
            if (content && nd.getContent().isNotPresent()) {
                throw new NArtifactNotFoundException(id.getLongId());
            }
            return new NBootDef(nd.getId(), nd.getDependencies().get().transitive().toList(), content && nd.getContent().isPresent() ? nd.getContent().get() : null);
        }
        if (this.isFirstBoot()) {
            NClassLoaderNode n = this.searchBootNode(id);
            if (n != null) {
                LinkedHashMap<NId, NClassLoaderNode> dm = new LinkedHashMap<NId, NClassLoaderNode>();
                for (NClassLoaderNode d : n.getDependencies()) {
                    this.collect(d, dm);
                }
                return new NBootDef(id, dm.values().stream().map(x -> NDependency.get(x.getId()).get()).collect(Collectors.toList()), NPath.of(n.getURL()));
            }
            String contentPath = id.getMavenPath(null);
            NPath jarPath = null;
            NPath pomPath = null;
            for (NRepositoryLocation nutsRepositoryLocation : this.resolveBootRepositoriesBootSelectionArray()) {
                NPath base = NPath.of(nutsRepositoryLocation.getPath());
                if (!base.isLocal() || !base.isDirectory()) continue;
                NPath a = base.resolve(contentPath + ".jar");
                NPath b = base.resolve(contentPath + ".pom");
                if (!a.isRegularFile() || !b.isRegularFile()) continue;
                jarPath = a;
                pomPath = b;
                break;
            }
            if (jarPath != null) {
                NDescriptor d = NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.MAVEN).parse(pomPath).get();
                return new NBootDef(id, d.getDependencies(), jarPath);
            }
        }
        throw new NArtifactNotFoundException(id.getLongId());
    }

    public void prepareBootClassPathConf(NIdType idType, NId id, NId forId, NId forceRuntimeId, boolean force, boolean processDependencies) {
        switch (idType) {
            case API: {
                return;
            }
            case RUNTIME: {
                NBootDef d = this.fetchBootDef(id, false);
                for (NId apiId : CoreNUtils.resolveNutsApiIdsFromDependencyList(d.deps)) {
                    this.setExtraBootRuntimeId(apiId, d.id, d.deps);
                }
                break;
            }
            case EXTENSION: {
                NBootDef d = this.fetchBootDef(id, false);
                for (NId apiId : CoreNUtils.resolveNutsApiIdsFromDependencyList(d.deps)) {
                    this.setExtraBootExtensionId(apiId, d.id, d.deps);
                }
                break;
            }
        }
    }

    public NBootDef prepareBootClassPathJar(NId id, NId forId, NId forceRuntimeId, boolean processDependencies) {
        NBootDef d = this.fetchBootDef(id, true);
        if (this.deployToInstalledRepository(d.content.toPath().get()) && processDependencies) {
            for (NDependency dep : d.deps) {
                this.prepareBootClassPathJar(dep.toId(), id, forceRuntimeId, true);
            }
        }
        return d;
    }

    private boolean isFirstBoot() {
        return this.bootModel.isFirstBoot();
    }

    private boolean deployToInstalledRepository(Path tmp) {
        NInstalledRepository ins = NWorkspaceExt.of().getInstalledRepository();
        NDescriptor descriptor = NDescriptorContentResolver.resolveNutsDescriptorFromFileContent(tmp, null);
        if (descriptor != null) {
            NDefinition b = new DefaultNDefinitionBuilder().setId(descriptor.getId()).setDependency(descriptor.getId().toDependency()).setDependency(descriptor.getId().toDependency()).setDescriptor(descriptor).setContent(NPath.of(tmp).setUserCache(true).setUserTemporary(true)).setInstallInformation(new DefaultNInstallInfo(descriptor.getId(), NInstallStatus.NONE, null, null, null, null, null, null, false, false)).build();
            ins.install(b);
            return true;
        }
        return false;
    }

    private NClassLoaderNode searchBootNode(NId id) {
        ArrayList<NClassLoaderNode> all = new ArrayList<NClassLoaderNode>();
        all.add(this.workspace.getBootRuntimeClassLoaderNode());
        all.addAll(this.workspace.getBootExtensionClassLoaderNode());
        return this.searchBootNode(id, all);
    }

    private NClassLoaderNode searchBootNode(NId id, List<NClassLoaderNode> into) {
        for (NClassLoaderNode n : into) {
            if (n == null) continue;
            if (id.equalsLongId(n.getId())) {
                return n;
            }
            NClassLoaderNode a = this.searchBootNode(id, n.getDependencies());
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public void onPreUpdateConfig(String confName) {
        this.preUpdateConfigStoreLocations = new NStoreLocationsMap(this.currentConfig.getStoreLocations());
    }

    public void onPostUpdateConfig(String confName) {
        this.preUpdateConfigStoreLocations = new NStoreLocationsMap(this.currentConfig.getStoreLocations());
        DefaultNWorkspaceCurrentConfig d = this.currentConfig;
        d.setUserStoreLocations(new NStoreLocationsMap(this.storeModelBoot.getStoreLocations()).toMapOrNull());
        d.setHomeLocations(new NHomeLocationsMap(this.storeModelBoot.getHomeLocations()).toMapOrNull());
        d.build(NWorkspace.of().getWorkspaceLocation());
        NStoreLocationsMap newSL = new NStoreLocationsMap(this.currentConfig.getStoreLocations());
        for (NStoreType sl : NStoreType.values()) {
            Path oldPathObj;
            String newPath;
            String oldPath = this.preUpdateConfigStoreLocations.get(sl);
            if (oldPath.equals(newPath = newSL.get(sl)) || !Files.exists(oldPathObj = Paths.get(oldPath, new String[0]), new LinkOption[0])) continue;
            NIOUtils.copyFolder(oldPathObj, Paths.get(newPath, new String[0]));
        }
        this.fireConfigurationChanged(confName, ConfigEventType.API);
    }

    private void onLoadWorkspaceError(Throwable ex) {
        DefaultNWorkspaceConfigModel wconfig = this;
        Path file = NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json");
        if (wconfig.isReadOnly()) {
            throw new NIOException(NMsg.ofC("unable to load config file %s", file), ex);
        }
        String fileSuffix = Instant.now().toString();
        fileSuffix = fileSuffix.replace(':', '-');
        String fileName = "nuts-workspace-" + fileSuffix;
        NPath logError = NPath.ofIdStore(this.workspace.getApiId(), NStoreType.LOG).resolve("invalid-config");
        NPath logFile = logError.resolve(fileName + ".error");
        this._LOG().log(NMsg.ofC("erroneous workspace config file. Unable to load file %s : %s", file, ex).withLevel(Level.SEVERE).withIntent(NMsgIntent.FAIL));
        try {
            logFile.mkParentDirs();
        }
        catch (Exception ex1) {
            throw new NIOException(NMsg.ofC("unable to log workspace error while loading config file %s : %s", file, ex1), ex);
        }
        NPath newfile = logError.resolve(fileName + ".json");
        this._LOG().log(NMsg.ofC("erroneous workspace config file will be replaced by a fresh one. Old config is copied to %s\n error logged to  %s", newfile.toString(), logFile).withLevel(Level.SEVERE).withIntent(NMsgIntent.FAIL));
        try {
            Files.move(file, newfile.toPath().get(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new NIOException(NMsg.ofC("unable to load and re-create config file %s : %s", file, e), ex);
        }
        try (PrintStream o = new PrintStream(logFile.getOutputStream());){
            o.println("workspace.path:");
            o.println(NWorkspace.of().getWorkspaceLocation());
            o.println("workspace.options:");
            o.println(wconfig.getBootUserOptions().toCmdLine(new NWorkspaceOptionsConfig().setCompact(false)));
            for (NStoreType storeType : NStoreType.values()) {
                o.println("location." + storeType.id() + ":");
                o.println(NPath.ofWorkspaceStore(storeType));
            }
            o.println("java.class.path:");
            o.println(System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NUserConfig getSecurity(String id) {
        return this.configUsers.get(id);
    }

    private NWorkspaceConfigBoot parseBootConfig() {
        return NWorkspaceExt.of().store().loadWorkspaceConfigBoot();
    }

    public NRepositoryLocation[] resolveBootRepositoriesBootSelectionArray() {
        ArrayList<NRepositoryLocation> defaults = new ArrayList<NRepositoryLocation>();
        for (NAddRepositoryOptions d : this.workspace.getDefaultRepositories()) {
            defaults.add(NRepositoryLocation.of(d.getName(), (String)null));
        }
        return this.resolveBootRepositoriesList().resolve(defaults.toArray(new NRepositoryLocation[0]), NRepositoryDB.of());
    }

    public NRepositorySelectorList resolveBootRepositoriesList() {
        if (this.parsedBootRepositoriesList != null) {
            return this.parsedBootRepositoriesList;
        }
        DefaultNBootModel bm = NWorkspaceExt.of().getModel().bootModel;
        this.parsedBootRepositoriesList = NRepositorySelectorList.of(bm.getBootUserOptions().getRepositories().orNull(), NRepositoryDB.of()).get();
        return this.parsedBootRepositoriesList;
    }

    public NWorkspaceConfigBoot getStoreModelBoot() {
        return this.storeModelBoot;
    }

    public NWorkspaceConfigApi getStoreModelApi() {
        return this.storeModelApi;
    }

    public NWorkspaceConfigRuntime getStoreModelRuntime() {
        return this.storeModelRuntime;
    }

    public NWorkspaceConfigSecurity getStoreModelSecurity() {
        return this.storeModelSecurity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService executorService() {
        if (this.executorService == null) {
            DefaultNWorkspaceConfigModel defaultNWorkspaceConfigModel = this;
            synchronized (defaultNWorkspaceConfigModel) {
                if (this.executorService == null) {
                    this.executorService = NWorkspace.of().getBootOptions().getExecutorService().orNull();
                    if (this.executorService == null) {
                        int minPoolSize = this.getConfigProperty("nuts.threads.min").flatMap(NLiteral::asInt).orElse(2);
                        if (minPoolSize < 1) {
                            minPoolSize = 60;
                        } else if (minPoolSize > 500) {
                            minPoolSize = 500;
                        }
                        int maxPoolSize = this.getConfigProperty("nuts.threads.max").flatMap(NLiteral::asInt).orElse(60);
                        if (maxPoolSize < 1) {
                            maxPoolSize = 60;
                        } else if (maxPoolSize > 500) {
                            maxPoolSize = 500;
                        }
                        if (minPoolSize > maxPoolSize) {
                            minPoolSize = maxPoolSize;
                        }
                        TimePeriod defaultPeriod = new TimePeriod(3L, TimeUnit.SECONDS);
                        TimePeriod period = TimePeriod.parse((String)this.getConfigProperty("nuts.threads.keep-alive").flatMap(NLiteral::asString).orNull(), TimeUnit.SECONDS).orElse(defaultPeriod);
                        if (period.getCount() < 0L) {
                            period = defaultPeriod;
                        }
                        ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(CoreNUtils.N_DEFAULT_THREAD_FACTORY);
                        poolExecutor.setCorePoolSize(minPoolSize);
                        poolExecutor.setKeepAliveTime(period.getCount(), period.getUnit());
                        poolExecutor.setMaximumPoolSize(maxPoolSize);
                        this.executorService = poolExecutor;
                    }
                }
            }
        }
        return this.executorService;
    }

    public NTerminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(NTerminal terminal) {
        if (terminal == null) {
            terminal = this.createTerminal();
        }
        if (!(terminal instanceof UnmodifiableTerminal)) {
            terminal = new UnmodifiableTerminal(terminal);
        }
        this.terminal = terminal;
    }

    public NTerminal createTerminal(InputStream in, NPrintStream out, NPrintStream err) {
        NTerminal t = this.createTerminal();
        if (in != null) {
            t.setIn(in);
        }
        if (out != null) {
            t.setOut(out);
        }
        if (err != null) {
            t.setErr(err);
        }
        return t;
    }

    public NTerminal createTerminal() {
        return new DefaultNTerminalFromSystem(this.workspaceSystemTerminalAdapter);
    }

    public void addPathFactory(NPathFactorySPI f) {
        if (f != null && !this.pathFactories.contains(f)) {
            this.pathFactories.add(f);
        }
    }

    public void removePathFactory(NPathFactorySPI f) {
        this.pathFactories.remove(f);
    }

    public NPath resolve(String path, ClassLoader classLoader) {
        NPathSPI s;
        String protocol;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader finalClassLoader = classLoader;
        Matcher m = PRELOAD_EXTENSION_PATH_PATTERN.matcher(path);
        if (m.find()) {
            protocol = m.group("protocol");
            NId eid = this.protocolToExtensionMap.get(protocol);
            if (eid != null) {
                NExtensions.of().loadExtension(eid);
            }
        } else {
            protocol = null;
        }
        NScoredCallable z = NScorable.query().fromStream(Arrays.stream(this.getPathFactories()).map(x -> {
            NScoredCallable<NPathSPI> v = null;
            try {
                v = x.createPath(path, protocol, finalClassLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return v;
        })).getBest().orNull();
        NPathSPI nPathSPI = s = z == null ? null : (NPathSPI)z.call();
        if (s != null) {
            if (s instanceof NPath) {
                return (NPath)((Object)s);
            }
            return new NPathFromSPI(s);
        }
        return null;
    }

    public NPathFactorySPI[] getPathFactories() {
        ArrayList<NPathFactorySPI> all = new ArrayList<NPathFactorySPI>(this.pathFactories.size() + 1);
        all.addAll(this.pathFactories);
        all.add(this.invalidPathFactory);
        return all.toArray(new NPathFactorySPI[0]);
    }

    public DefaultNBootModel getBootModel() {
        return this.bootModel;
    }

    public Map<String, String> getConfigMap() {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        if (this.getStoreModelMain().getEnv() != null) {
            p.putAll(this.getStoreModelMain().getEnv());
        }
        return p;
    }

    public NOptional<NLiteral> getConfigProperty(String property) {
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (env != null) {
            String v = env.get(property);
            return NOptional.of(v == null ? null : NLiteral.of(v));
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("config property not found : %s", property));
    }

    public void setConfigProperty(String property, String value) {
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (NBlankable.isBlank(value)) {
            if (env != null && env.containsKey(property)) {
                env.remove(property);
                this.workspace.getConfigModel().fireConfigurationChanged("env", ConfigEventType.MAIN);
            }
        } else {
            String old;
            if (env == null) {
                env = new LinkedHashMap<String, String>();
                this.getStoreModelMain().setEnv(env);
            }
            if (!value.equals(old = env.get(property))) {
                env.put(property, value);
                this.workspace.getConfigModel().fireConfigurationChanged("env", ConfigEventType.MAIN);
            }
        }
    }

    public boolean isSecure() {
        return this.getStoredConfigSecurity().isSecure();
    }

    public void invalidateStoreModelMain() {
        this.storeModelMainChanged = true;
    }

    private class NWorkspaceStoredConfigImpl
    implements NWorkspaceStoredConfig {
        @Override
        public String getName() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getName();
        }

        @Override
        public NStoreStrategy getStoreStrategy() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getStoreStrategy();
        }

        @Override
        public NStoreStrategy getRepositoryStoreStrategy() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getStoreStrategy();
        }

        @Override
        public NOsFamily getStoreLayout() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLayout();
        }

        @Override
        public Map<NStoreType, String> getStoreLocations() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations();
        }

        @Override
        public Map<NHomeLocation, String> getHomeLocations() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations();
        }

        @Override
        public String getStoreLocation(NStoreType folderType) {
            return new NStoreLocationsMap(DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations()).get(folderType);
        }

        @Override
        public String getHomeLocation(NHomeLocation homeLocation) {
            return new NHomeLocationsMap(DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations()).get(homeLocation);
        }

        @Override
        public NId getApiId() {
            NVersion v = DefaultNWorkspaceConfigModel.this.getStoredConfigApi().getApiVersion();
            return v == null || v.isBlank() ? null : NId.getApi(v).get();
        }

        @Override
        public NId getRuntimeId() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigApi().getRuntimeId();
        }

        @Override
        public String getRuntimeDependencies() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigRuntime().getDependencies();
        }

        @Override
        public List<String> getBootRepositories() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().getBootRepositories();
        }

        @Override
        public String getJavaCommand() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigApi().getJavaCommand();
        }

        @Override
        public String getJavaOptions() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigApi().getJavaOptions();
        }

        @Override
        public boolean isSystem() {
            return DefaultNWorkspaceConfigModel.this.getStoredConfigBoot().isSystem();
        }
    }

    private static class WorkspaceSystemTerminalAdapter
    extends AbstractSystemTerminalAdapter {
        public WorkspaceSystemTerminalAdapter(NWorkspace workspace) {
        }

        @Override
        public NSystemTerminalBase getBase() {
            return NIO.of().getSystemTerminal();
        }
    }

    private class InvalidFilePathFactory
    implements NPathFactorySPI {
        private InvalidFilePathFactory() {
        }

        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            try {
                return NScoredCallable.of(1, () -> new InvalidFilePath(path, DefaultNWorkspaceConfigModel.this.workspace));
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            return 1;
        }
    }

    private class NBootDef {
        NId id;
        List<NDependency> deps;
        NPath content;

        public NBootDef(NId id, List<NDependency> deps, NPath content) {
            this.id = id;
            this.deps = deps;
            this.content = content;
        }
    }
}

