/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceBootConfig;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceBootConfigExtensionImpl;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;

public class DefaultNWorkspaceBootConfig
implements NWorkspaceBootConfig {
    private String bootPath;
    private String effectiveWorkspace;
    private String effectiveWorkspaceName;
    private boolean immediateLocation;
    private String uuid = null;
    private boolean system;
    private String name = null;
    private String workspace = null;
    private List<String> bootRepositories = null;
    private Map<NStoreType, String> storeLocations = null;
    private Map<NHomeLocation, String> homeLocations = null;
    private NStoreStrategy repositoryStoreStrategy = null;
    private NStoreStrategy storeStrategy = null;
    private NOsFamily storeLayout = null;
    private List<NWorkspaceBootConfig.Extension> extensions;

    public DefaultNWorkspaceBootConfig(String bootPath, String effectiveWorkspace, String effectiveWorkspaceName, boolean immediateLocation, NWorkspaceConfigBoot bootModel) {
        this.bootPath = bootPath;
        this.effectiveWorkspace = effectiveWorkspace;
        this.immediateLocation = immediateLocation;
        this.effectiveWorkspaceName = effectiveWorkspaceName;
        this.uuid = bootModel.getUuid();
        this.system = bootModel.isSystem();
        this.name = bootModel.getName();
        this.workspace = bootModel.getWorkspace();
        this.bootRepositories = bootModel.getBootRepositories();
        this.storeLocations = bootModel.getStoreLocations() == null ? new HashMap<NStoreType, String>() : new HashMap<NStoreType, String>(bootModel.getStoreLocations());
        this.homeLocations = bootModel.getHomeLocations() == null ? new HashMap<NHomeLocation, String>() : new HashMap<NHomeLocation, String>(bootModel.getHomeLocations());
        this.repositoryStoreStrategy = bootModel.getRepositoryStoreStrategy();
        this.storeStrategy = bootModel.getStoreStrategy();
        this.storeLayout = bootModel.getStoreLayout();
        if (this.storeStrategy == null) {
            this.storeStrategy = NStoreStrategy.EXPLODED;
        }
        this.storeLocations = NPlatformHome.of(null, this.system).buildLocations(this.storeStrategy, this.storeLocations, this.homeLocations, effectiveWorkspace);
        List<NWorkspaceConfigBoot.ExtensionConfig> extensions = bootModel.getExtensions();
        this.extensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions.stream().map(x -> new NWorkspaceBootConfigExtensionImpl((NWorkspaceConfigBoot.ExtensionConfig)x)).collect(Collectors.toList()));
    }

    @Override
    public boolean isImmediateLocation() {
        return this.immediateLocation;
    }

    @Override
    public String getEffectiveWorkspaceName() {
        return this.effectiveWorkspaceName;
    }

    @Override
    public String getBootPath() {
        return this.bootPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getEffectiveWorkspace() {
        return this.effectiveWorkspace;
    }

    @Override
    public List<NWorkspaceBootConfig.Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getBootRepositories() {
        return this.bootRepositories;
    }

    @Override
    public Map<NStoreType, String> getStoreLocations() {
        return Collections.unmodifiableMap(this.storeLocations);
    }

    @Override
    public Map<NHomeLocation, String> getHomeLocations() {
        return Collections.unmodifiableMap(this.homeLocations);
    }

    @Override
    public NStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    @Override
    public NOsFamily getStoreLayout() {
        return this.storeLayout;
    }

    @Override
    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.repositoryStoreStrategy;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    public String getDefaultIdBasedir(NId id) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return plainIdPath;
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return x;
    }

    @Override
    public String getStoreLocation(NId id, NStoreType folderType) {
        String storeLocation = this.getStoreLocation(folderType);
        if (storeLocation == null) {
            return null;
        }
        return Paths.get(storeLocation, new String[0]).resolve("id").resolve(this.getDefaultIdBasedir(id)).toString();
    }

    @Override
    public String getStoreLocation(NStoreType storeType) {
        return this.storeLocations.get(storeType);
    }

    @Override
    public String getHomeLocation(NHomeLocation homeLocation) {
        return new NHomeLocationsMap(this.homeLocations).get(homeLocation);
    }

    @Override
    public String getHomeLocation(NStoreType storeType) {
        return NPlatformHome.of(this.getStoreLayout(), this.isSystem()).getWorkspaceLocation(storeType, this.getHomeLocations(), this.getName());
    }
}

