/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.update;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.command.NUpdateResult;
import net.thevpc.nuts.core.NWorkspaceUpdateResult;

public class DefaultNWorkspaceUpdateResult
implements NWorkspaceUpdateResult {
    private final NUpdateResult api;
    private final NUpdateResult runtime;
    private final List<NUpdateResult> extensions;
    private final List<NUpdateResult> artifacts;

    public DefaultNWorkspaceUpdateResult(NUpdateResult api, NUpdateResult runtime, List<NUpdateResult> extensions, List<NUpdateResult> components) {
        this.api = api;
        this.runtime = runtime;
        this.extensions = extensions;
        this.artifacts = components;
    }

    @Override
    public NUpdateResult getApi() {
        return this.api;
    }

    @Override
    public NUpdateResult getRuntime() {
        return this.runtime;
    }

    @Override
    public List<NUpdateResult> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<NUpdateResult> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isUpdatableApi() {
        return this.api != null && this.api.isUpdatable();
    }

    @Override
    public boolean isUpdatableRuntime() {
        return this.runtime != null && this.runtime.isUpdatable();
    }

    @Override
    public boolean isUpdatableExtensions() {
        for (NUpdateResult r : this.extensions) {
            if (!r.isUpdatable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.getUpdatesCount() > 0;
    }

    @Override
    public List<NUpdateResult> getUpdatable() {
        ArrayList<NUpdateResult> all = new ArrayList<NUpdateResult>();
        if (this.api != null && this.api.isUpdatable()) {
            all.add(this.api);
        }
        if (this.runtime != null && this.runtime.isUpdatable()) {
            all.add(this.runtime);
        }
        for (NUpdateResult r : this.extensions) {
            if (!r.isUpdatable()) continue;
            all.add(r);
        }
        for (NUpdateResult r : this.artifacts) {
            if (!r.isUpdatable()) continue;
            all.add(r);
        }
        return all;
    }

    @Override
    public List<NUpdateResult> getAllResults() {
        ArrayList<NUpdateResult> all = new ArrayList<NUpdateResult>();
        if (this.api != null) {
            all.add(this.api);
        }
        if (this.runtime != null) {
            all.add(this.runtime);
        }
        all.addAll(this.extensions);
        all.addAll(this.artifacts);
        return all;
    }

    @Override
    public int getUpdatesCount() {
        int c = 0;
        if (this.api != null && this.api.isUpdatable()) {
            ++c;
        }
        if (this.runtime != null && this.runtime.isUpdatable()) {
            ++c;
        }
        for (NUpdateResult r : this.extensions) {
            if (!r.isUpdatable()) continue;
            ++c;
        }
        for (NUpdateResult r : this.artifacts) {
            if (!r.isUpdatable()) continue;
            ++c;
        }
        return c;
    }
}

