/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NUninstallCmd;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.AbstractNInstallCmd;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNUninstallCmd
extends NWorkspaceCmdBase<NUninstallCmd>
implements NUninstallCmd {
    protected boolean erase = false;
    protected List<String> args;
    protected List<AbstractNInstallCmd.ConditionalArguments> conditionalArguments = new ArrayList<AbstractNInstallCmd.ConditionalArguments>();
    protected final List<NId> ids = new ArrayList<NId>();

    public AbstractNUninstallCmd() {
        super("uninstall");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NUninstallCmd addId(String id) {
        return this.addId(id == null ? null : NId.get(id).get());
    }

    @Override
    public NUninstallCmd addId(NId id) {
        if (id == null) {
            throw new NArtifactNotFoundException(id);
        }
        this.ids.add(id);
        return this;
    }

    @Override
    public NUninstallCmd addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NUninstallCmd addIds(NId ... ids) {
        for (NId id : ids) {
            this.addId(id);
        }
        return this;
    }

    @Override
    public NUninstallCmd removeId(NId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    @Override
    public NUninstallCmd removeId(String id) {
        return this.removeId(NId.get(id).get());
    }

    @Override
    public NUninstallCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NUninstallCmd clearArgs() {
        this.args = null;
        return this;
    }

    @Override
    public List<String> getArgs() {
        return NCollections.unmodifiableList(this.args);
    }

    @Override
    public NUninstallCmd addArg(String arg) {
        if (arg != null) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
        }
        return this;
    }

    @Override
    public NUninstallCmd addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    @Override
    public NUninstallCmd addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
        return this;
    }

    @Override
    public List<NId> getIds() {
        return NCollections.unmodifiableList(this.ids);
    }

    @Override
    public boolean isErase() {
        return this.erase;
    }

    @Override
    public NUninstallCmd setErase(boolean erase) {
        this.erase = erase;
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        switch (aa.key()) {
            case "-e": 
            case "--erase": {
                cmdLine.matcher().matchFlag(v -> this.setErase(v.booleanValue())).anyMatch();
                return true;
            }
            case "-g": 
            case "--args": {
                cmdLine.matcher().matchFlag(v -> {
                    this.addArgs(cmdLine.toStringArray());
                    cmdLine.skipAll();
                }).anyMatch();
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (aa.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(aa.asString().get());
        return true;
    }
}

