/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy;

import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.command.NUndeployCmd;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy.AbstractNUndeployCmd;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;

public class DefaultNUndeployCmd
extends AbstractNUndeployCmd {
    public DefaultNUndeployCmd(NWorkspace workspace) {
        super(workspace);
    }

    @Override
    public NUndeployCmd run() {
        NSession session = NSession.of();
        NWorkspace workspace = NWorkspace.of();
        NWorkspaceUtils.of(workspace).checkReadOnly();
        if (this.ids.isEmpty()) {
            throw new NExecutionException(NMsg.ofPlain("no package to undeploy"), 1);
        }
        for (NId id : this.ids) {
            NDefinition p = NSearchCmd.of().setFetchStrategy(this.isOffline() ? NFetchStrategy.OFFLINE : NFetchStrategy.ONLINE).addIds(id).addRepositoryFilter(NRepositoryFilters.of().byName(this.getRepository())).setRepositoryFilter(NRepositoryFilters.of().installedRepo().neg()).setDistinct(true).failFast().getResultDefinitions().findFirst().get();
            NRepository repository1 = workspace.findRepository(p.getRepositoryUuid()).get();
            NRepositorySPI repoSPI = NWorkspaceUtils.of(workspace).toRepositorySPI(repository1);
            repoSPI.undeploy().setId(p.getId()).run();
            this.addResult(id);
        }
        if (session.isTrace()) {
            NOut.println(this.result);
        }
        return this;
    }
}

