/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NUndeployCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NWorkspaceCmdBase;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNUndeployCmd
extends NWorkspaceCmdBase<NUndeployCmd>
implements NUndeployCmd {
    protected List<NId> result;
    protected final List<NId> ids = new ArrayList<NId>();
    protected String repository;
    protected boolean offline = true;

    public AbstractNUndeployCmd(NWorkspace workspace) {
        super("undeploy");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public List<NId> getIds() {
        return this.ids;
    }

    @Override
    public NUndeployCmd addId(NId id) {
        if (id != null) {
            this.ids.add(id);
        }
        this.invalidateResult();
        return this;
    }

    @Override
    public NUndeployCmd addId(String id) {
        return this.addId(NBlankable.isBlank(id) ? null : NId.get(id).get());
    }

    @Override
    public NUndeployCmd addIds(String ... values) {
        if (values != null) {
            for (String s : values) {
                if (NBlankable.isBlank(s)) continue;
                this.ids.add(NId.get(s).get());
            }
        }
        return this;
    }

    @Override
    public NUndeployCmd addIds(NId ... value) {
        if (value != null) {
            for (NId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NUndeployCmd clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public NUndeployCmd setRepository(String repository) {
        this.repository = repository;
        this.invalidateResult();
        return this;
    }

    protected void addResult(NId id) {
        if (this.result == null) {
            this.result = new ArrayList<NId>();
        }
        this.result.add(id);
        NSession session = NSession.of();
        if (!(!session.isTrace() || session.getOutputFormat().orNull() != null && session.getOutputFormat().orDefault() != NContentType.PLAIN || session.getOutputFormat().orNull() != null && session.getOutputFormat().orDefault() != NContentType.PLAIN)) {
            session.getTerminal().out().println(NMsg.ofC("Nuts %s undeployed successfully", id));
        }
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public NUndeployCmd setOffline(boolean offline) {
        this.offline = offline;
        this.invalidateResult();
        return this;
    }

    @Override
    protected void invalidateResult() {
        this.result = null;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().orNull();
        if (aa == null) {
            return false;
        }
        switch (aa.key()) {
            case "--offline": {
                return cmdLine.matcher().matchFlag(v -> this.setOffline(v.booleanValue())).anyMatch();
            }
            case "-r": 
            case "-repository": 
            case "--from": {
                return cmdLine.matcher().matchEntry(v -> this.setRepository(v.stringValue())).anyMatch();
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (aa.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(aa.asString().get());
        return true;
    }
}

