/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell;

import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.AbstractShellWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.NShellWriter;
import net.thevpc.nuts.util.NStringUtils;

public class WinCmdShellWriter
extends AbstractShellWriter {
    public WinCmdShellWriter() {
        super(NShellFamily.WIN_CMD);
    }

    @Override
    protected String lineCommentImpl(String anyString) {
        return ":: " + anyString;
    }

    @Override
    protected String codeCommentImpl(String anyString) {
        return "REM " + anyString;
    }

    @Override
    public NShellWriter echoOff() {
        this.printlnCommandImpl("@echo off");
        return this;
    }

    @Override
    public NShellWriter echoOn() {
        this.printlnCommandImpl("@echo on");
        return this;
    }

    @Override
    public NShellWriter printlnSetVarScriptPath(String varName) {
        this.printlnCommandImpl("SET " + varName + "=%~dp0");
        return this;
    }

    @Override
    public NShellWriter printlnSetVarFolderPath(String varName, String fromPathVarName) {
        this.printlnCommandImpl("SET " + varName + "=%" + fromPathVarName + ":~0,-1%");
        return this;
    }

    @Override
    public NShellWriter printlnSetVar(String varName, String varExpr) {
        this.printlnCommandImpl("SET " + varName + "=" + this.replaceDollarVar(varExpr.replace("/", "\\")));
        return this;
    }

    @Override
    public String varValue(String varName) {
        if (NStringUtils.isEmpty(varName)) {
            return "${NULL}";
        }
        switch (varName) {
            case "*": {
                return "%*";
            }
        }
        return "%" + varName + "%";
    }

    @Override
    public NShellWriter printlnPrepareJavaCommand(String javaCommand, String javaHomeVarName, int minJavaVersion, boolean preferJavaW) {
        if (preferJavaW) {
            this.out().println("if [%" + javaCommand + "%] == [] SET \"" + javaCommand + "=javaw.exe\"");
        } else {
            this.out().println("if [%" + javaCommand + "%] == [] SET \"" + javaCommand + "=java.exe\"");
        }
        return this;
    }
}

