/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell;

import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.BashShellWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.ShShellWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.WinCmdShellWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.ZshShellWriter;
import net.thevpc.nuts.util.NOptional;

public interface NShellWriter {
    public static NOptional<NShellWriter> of(NShellFamily family) {
        if (family == null) {
            family = NShellFamily.getCurrent();
        }
        switch (family) {
            case BASH: {
                return NOptional.of(new BashShellWriter());
            }
            case ZSH: {
                return NOptional.of(new ZshShellWriter());
            }
            case SH: {
                return NOptional.of(new ShShellWriter());
            }
            case WIN_CMD: {
                return NOptional.of(new WinCmdShellWriter());
            }
        }
        return NOptional.ofNamedEmpty(family.id() + " shell writer");
    }

    public boolean isDisableCommand();

    public NShellWriter setEnableCommands();

    public NShellWriter setDisableCommands();

    public NShellWriter setDisableCommands(boolean var1);

    public NShellWriter printlnSetVarScriptPath(String var1);

    public NShellWriter printlnSetVarFolderPath(String var1, String var2);

    public NShellWriter printlnComment(String var1);

    public NShellWriter printlnSetVar(String var1, String var2);

    public NShellWriter printlnSetAppendVar(String var1, String var2);

    public NShellWriter println();

    public NShellWriter echoOff();

    public NShellWriter echoOn();

    public NShellWriter printlnCommand(String var1);

    public String build();

    public NShellWriter printlnPrepareJavaCommand(String var1, String var2, int var3, boolean var4);
}

