/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell;

import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.AbstractShellWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.shell.NShellWriter;
import net.thevpc.nuts.util.NStringUtils;

public abstract class AbstractPosixShellWriter
extends AbstractShellWriter {
    public AbstractPosixShellWriter(NShellFamily family) {
        super(NShellFamily.BASH);
        switch (family) {
            case BASH: {
                this.out().println("#!/bin/bash");
                break;
            }
            case SH: {
                this.out().println("#!/bin/sh");
                break;
            }
            case ZSH: {
                this.out().println("#!/bin/zsh");
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported shell family " + family);
            }
        }
    }

    @Override
    protected String lineCommentImpl(String anyString) {
        return "## " + anyString;
    }

    @Override
    protected String codeCommentImpl(String anyString) {
        return "# " + anyString;
    }

    @Override
    public NShellWriter echoOff() {
        this.out().println("set +x");
        return this;
    }

    @Override
    public NShellWriter echoOn() {
        this.out().println("set -x");
        return this;
    }

    @Override
    public NShellWriter printlnSetVarScriptPath(String varName) {
        this.printlnCommandImpl(varName + "=\"${BASH_SOURCE[0]:-${(%):-%x}}\"");
        return this;
    }

    @Override
    public NShellWriter printlnSetVarFolderPath(String varName, String fromPathVarName) {
        this.printlnCommandImpl(varName + "=\"$(cd -- \"$(dirname -- \"$" + fromPathVarName + "\")\" && pwd)\"");
        return this;
    }

    @Override
    public NShellWriter printlnPrepareJavaCommand(String javaCommand, String javaHomeVarName, int minJavaVersion, boolean preferJavaW) {
        this.out().println("if [ -n \"$" + javaHomeVarName + "\" ] && [ -x \"$" + javaHomeVarName + "/bin/java\" ];  then");
        this.out().println("    " + javaCommand + "=\"$" + javaHomeVarName + "/bin/java\"\n");
        this.out().println("elif (type -p java > /dev/null) ; then\n");
        this.out().println("    " + javaCommand + "=java\n");
        this.out().println("elif [ -n \"$JAVA_HOME\" ] && [ -x \"$JAVA_HOME/bin/java\" ];  then\n");
        this.out().println("#    echo found java executable in JAVA_HOME\n");
        this.out().println("    " + javaCommand + "=\"$JAVA_HOME/bin/java\"\n");
        this.out().println("else\n");
        this.out().println("    " + javaCommand + "=\"java\"\n");
        this.out().println("fi\n");
        this.out().println("\n");
        this.out().println("if [ \"$" + javaCommand + "\" ]; then\n");
        this.out().println("    version=$(\"$" + javaCommand + "\" -version 2>&1 | awk -F '\"' '/version/ {print $2}')\n");
        this.out().println("    major=`echo $version | cut -d. -f1`\n");
        this.out().println("    minor=`echo $version | cut -d. -f2`\n");
        this.out().println("    if [ \"$major\" -eq \"1\" ]; then\n");
        this.out().println("        major=$minor\n");
        this.out().println("    fi\n");
        this.out().println("    if [ \"$major\" -lt \"" + minJavaVersion + "\" ]; then\n");
        this.out().println("        echo expected " + minJavaVersion + "+ java version, found $version;\n");
        this.out().println("        exit 204;\n");
        this.out().println("    fi\n");
        this.out().println("fi\n");
        return this;
    }

    @Override
    public NShellWriter printlnSetVar(String varName, String varExpr) {
        String u = this.replaceDollarVar(varExpr);
        StringBuilder sb = new StringBuilder();
        block6: for (char c : u.toCharArray()) {
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.printlnCommandImpl(varName + "=\"" + sb + "\"");
        return this;
    }

    @Override
    public String varValue(String varName) {
        if (NStringUtils.isEmpty(varName)) {
            return "${NULL}";
        }
        switch (varName) {
            case "*": {
                return "\"$@\"";
            }
        }
        return "${" + varName + "}";
    }
}

