/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.AbstractFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.util.NAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnixFreeDesktopEntryWriter
extends AbstractFreeDesktopEntryWriter {
    private final NPath desktopPath;

    public UnixFreeDesktopEntryWriter(NPath desktopPath) {
        this.desktopPath = desktopPath;
    }

    @Override
    public PathInfo[] writeShortcut(FreeDesktopEntry descriptor, NPath path, boolean doOverride, NId id) {
        path = NPath.of(this.ensureName(path == null ? null : path.toString(), descriptor.getOrCreateDesktopEntry().getName(), "desktop"));
        PathInfo.Status s = this.tryWrite(descriptor, path, "UpdateScript");
        return new PathInfo[]{new PathInfo("desktop-shortcut", id, path, s)};
    }

    @Override
    public PathInfo[] writeDesktop(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NId id) {
        fileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        NPath q = this.desktopPath.resolve(fileName);
        return this.writeShortcut(descriptor, q, doOverride, id);
    }

    @Override
    public PathInfo[] writeMenu(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NId id) {
        String desktopFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        FreeDesktopEntry.Group root = descriptor.getOrCreateDesktopEntry();
        NPath folder4shortcuts = NPath.ofUserHome().resolve(".local/share/applications");
        folder4shortcuts.mkdirs();
        NPath shortcutFile = folder4shortcuts.resolve(desktopFileName);
        all.add(new PathInfo("desktop-icon", id, shortcutFile, this.tryWrite(descriptor, shortcutFile, "UpdateScript")));
        ArrayList<String> categories = new ArrayList<String>(root.getCategories());
        if (categories.isEmpty()) {
            categories.add("/");
        }
        NPath folder4menus = NPath.ofUserHome().resolve(".config/menus/applications-merged");
        folder4menus.mkdirs();
        String menuFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "menu"), new String[0]).getFileName().toString();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.newDocument();
            for (String menuPath : categories) {
                String[] part = (String[])Arrays.stream((menuPath == null ? "" : menuPath).split("/")).filter(x -> !x.isEmpty()).toArray(String[]::new);
                if (part.length == 0) {
                    part = new String[]{"Applications"};
                } else if (!part[0].equals("Applications")) {
                    ArrayList<String> li = new ArrayList<String>();
                    li.add("Applications");
                    li.addAll(Arrays.asList(part));
                    part = li.toArray(new String[0]);
                }
                this.createMenuXmlElement(part, desktopFileName, dom);
            }
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            tr.transform(new DOMSource(dom), new StreamResult(b));
            NPath menuFile = folder4menus.resolve(menuFileName);
            all.add(new PathInfo("desktop-menu", id, menuFile, CoreIOUtils.tryWrite(b.toByteArray(), menuFile, "UpdateScript")));
        }
        catch (ParserConfigurationException | TransformerException ex) {
            throw new RuntimeException(ex);
        }
        if (all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.updateDesktopMenus();
        }
        return all.toArray(new PathInfo[0]);
    }

    private void callMeMayBe(String ... command) {
        ArrayList<String> cmdList = new ArrayList<String>(Arrays.asList(command));
        String sysCmd = (String)cmdList.remove(0);
        Path a = NSysExecUtils.sysWhich(sysCmd);
        if (a != null) {
            cmdList.add(0, a.toString());
            String outStr = NExecCmd.of().setCommand(cmdList).addCommand(new String[0]).system().getGrabbedAllString().trim();
            NSession session = NSession.of();
            if (session.isPlainTrace() && !outStr.isEmpty()) {
                NOut.println(CoreStringUtils.prefixLinesOsNL(outStr, "[" + sysCmd + "] "));
            }
        }
    }

    private void updateDesktopMenus() {
        this.callMeMayBe("kbuildsycoca5");
        this.callMeMayBe("update-desktop-database", System.getProperty("user.home") + "/.local/share/applications");
        this.callMeMayBe("xdg-desktop-menu", "forceupdate");
    }

    private String getDesktopEnvironment() {
        return NWorkspace.of().getSysEnv("XDG_SESSION_DESKTOP").orNull();
    }

    private Element ensureXmlChild(Node parent, String name) {
        NodeList cn = parent.getChildNodes();
        for (int i = 0; i < cn.getLength(); ++i) {
            Element e;
            String nn;
            Node ci = cn.item(i);
            if (!(ci instanceof Element) || !name.equals(nn = (e = (Element)ci).getNodeName())) continue;
            return e;
        }
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element elem = doc.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    private void createMenuXmlElement(String[] a, String name, Node parent) {
        if (a.length == 1) {
            Element emenu = this.ensureXmlChild(parent, "Menu");
            Element ename = this.ensureXmlChild(emenu, "Name");
            ename.setTextContent(a[0]);
            Element einclude = this.ensureXmlChild(emenu, "Include");
            Element efilename = this.ensureXmlChild(einclude, "Filename");
            efilename.setTextContent(name);
        } else {
            Element emenu = this.ensureXmlChild(parent, "Menu");
            Element ename = this.ensureXmlChild(emenu, "Name");
            ename.setTextContent(a[0]);
            this.createMenuXmlElement(Arrays.copyOfRange(a, 1, a.length), name, emenu);
        }
    }

    public void write(FreeDesktopEntry file, Path out) {
        NPath.of(out).mkParentDirs();
        try (PrintStream p = new PrintStream(Files.newOutputStream(out, new OpenOption[0]));){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public PathInfo.Status tryWrite(FreeDesktopEntry file, NPath out, String rememberMeKey) {
        out.mkParentDirs();
        return CoreIOUtils.tryWrite(this.writeAsString(file).getBytes(), out, rememberMeKey);
    }

    public String writeAsString(FreeDesktopEntry file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        this.write(file, out);
        out.flush();
        return bos.toString();
    }

    public void write(FreeDesktopEntry file, File out) {
        NPath.of(out).mkParentDirs();
        try (PrintStream p = new PrintStream(out);){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public void write(FreeDesktopEntry file, NPrintStream out) {
        this.write(file, out.asPrintStream());
    }

    public void write(FreeDesktopEntry file, PrintStream out) {
        out.println("#!/usr/bin/env xdg-open");
        for (FreeDesktopEntry.Group group : file.getGroups()) {
            out.println();
            String gn = group.getGroupName();
            NAssert.requireNonBlank(gn, "group name");
            FreeDesktopEntry.Type t = group.getType();
            NAssert.requireNonNull(t, "type");
            out.println("[" + gn.trim() + "]");
            for (Map.Entry<String, Object> e : group.toMap().entrySet()) {
                Object value = e.getValue();
                String key = e.getKey();
                if (value instanceof FreeDesktopEntry.Type) {
                    String v = value.toString().toLowerCase();
                    v = Character.toUpperCase(v.charAt(0)) + v.substring(1);
                    out.println(key + "=" + v);
                    continue;
                }
                if (value instanceof Boolean || value instanceof String) {
                    out.println(key + "=" + value);
                    continue;
                }
                if (value instanceof List) {
                    char sep = ';';
                    out.println(key + "=" + ((List)value).stream().map(x -> {
                        StringBuilder sb = new StringBuilder();
                        for (char c : x.toCharArray()) {
                            if (c == sep || c == '\\') {
                                sb.append('\\');
                            }
                            sb.append(c);
                        }
                        return sb.toString();
                    }).collect(Collectors.joining("" + sep)));
                    continue;
                }
                throw new IllegalArgumentException("unsupported value type for " + key);
            }
        }
    }
}

