/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NAskParseContext;
import net.thevpc.nuts.io.NAskParser;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.UnixFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NCancelException;
import net.thevpc.nuts.util.NValidationException;

public class AnyNixNdi
extends BaseSystemNdi {
    @Override
    protected NShellFamily[] getShellGroups() {
        LinkedHashSet<NShellFamily> all = new LinkedHashSet<NShellFamily>(NWorkspace.of().getShellFamilies());
        all.retainAll(Arrays.asList(NShellFamily.SH, NShellFamily.FISH));
        return all.toArray(new NShellFamily[0]);
    }

    @Override
    public boolean isShortcutFileNameUserFriendly() {
        return false;
    }

    @Override
    public String createNutsScriptContent(NId fnutsId, NdiScriptOptions options, NShellFamily shellFamily) {
        StringBuilder command = new StringBuilder();
        command.append(this.getExecFileName("nuts")).append(" ").append(NShellHelper.of(shellFamily).varRef("NUTS_OPTIONS")).append(" ");
        if (options.getLauncher().getNutsOptions() != null) {
            for (String no : options.getLauncher().getNutsOptions()) {
                command.append(" ").append(no);
            }
        }
        command.append(" \"").append(fnutsId).append("\"");
        command.append(" \"$@\"");
        return command.toString();
    }

    @Override
    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
        final NTexts factory = NTexts.of();
        final NSession session = NSession.of();
        if (Arrays.stream(updatedPaths).anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED) && session.isTrace()) {
            if (session.isPlainTrace()) {
                NOut.resetLine().println(NMsg.ofC("%s scripts to point to current workspace : ", session.isYes() ? factory.ofStyled("force updating", NTextStyle.warn().append(NTextStyle.underlined())) : factory.ofStyled("force updating", NTextStyle.warn())));
                List sortedNames = Arrays.stream(updatedPaths).map(x -> x.getPath().getName()).sorted().collect(Collectors.toList());
                int maxPerLine = 5;
                for (int i = 0; i < sortedNames.size(); i += maxPerLine) {
                    List sublist = sortedNames.subList(i, Math.min(i + maxPerLine, sortedNames.size()));
                    NOut.print("\t");
                    NOut.println(factory.ofBuilder().appendJoined(", ", sublist.stream().map(name -> factory.ofStyled((String)name, NTextStyle.path())).collect(Collectors.toList())));
                }
            }
            final String sysRcName = NShellHelper.of(NWorkspace.of().getShellFamily()).getSysRcName();
            NAsk.of().forBoolean(NMsg.ofC("```error ATTENTION``` You may need to re-run terminal or issue \"%s\" in your current terminal for new environment to take effect.%nPlease type %s if you agree, %s if you need more explanation or %s to cancel updates.", factory.ofStyled(". ~/" + sysRcName, NTextStyle.path()), factory.ofStyled("ok", NTextStyle.success()), factory.ofStyled("why", NTextStyle.warn()), factory.ofStyled("cancel!", NTextStyle.comments()))).setHintMessage(NMsg.ofPlain("you must enter your confirmation")).setParser(new NAskParser<Boolean>(){

                @Override
                public Boolean parse(NAskParseContext<Boolean> context) {
                    Object response = context.response();
                    NAsk<Boolean> question = context.question();
                    Boolean defaultValue = question.getDefaultValue();
                    if (response instanceof Boolean) {
                        return (Boolean)response;
                    }
                    if (response == null || response instanceof String && response.toString().length() == 0) {
                        response = defaultValue;
                    }
                    if (response == null) {
                        throw new NValidationException(NMsg.ofPlain("sorry... but you need to type 'ok', 'why' or 'cancel'"));
                    }
                    String r = response.toString();
                    if ("ok".equalsIgnoreCase(r)) {
                        return true;
                    }
                    if ("why".equalsIgnoreCase(r)) {
                        NPrintStream out = session.out();
                        out.resetLine();
                        out.println(NMsg.ofC("\\\"%s\\\" is a special file in your home that is invoked upon each interactive terminal launch.", factory.ofStyled(sysRcName, NTextStyle.path())));
                        out.print("It helps configuring environment variables. ```sh nuts``` make usage of such facility to update your **PATH** env variable\n");
                        out.print("to point to current ```sh nuts``` workspace, so that when you call a ```sh nuts``` command it will be resolved correctly...\n");
                        out.println(NMsg.ofC("However updating \\\"%s\\\" does not affect the running process/terminal. So you have basically two choices :", factory.ofStyled(sysRcName, NTextStyle.path())));
                        out.print(" - Either to restart the process/terminal (konsole, term, xterm, sh, bash, ...)%n");
                        out.println(NMsg.ofC(" - Or to run by your self the \\\"%s\\\" script (don\\'t forget the leading dot)", factory.ofStyled(". ~/" + sysRcName, NTextStyle.path())));
                        throw new NValidationException(NMsg.ofPlain("Try again..."));
                    }
                    if ("cancel".equalsIgnoreCase(r) || "cancel!".equalsIgnoreCase(r)) {
                        throw new NCancelException();
                    }
                    throw new NValidationException(NMsg.ofPlain("sorry... but you need to type 'ok', 'why' or 'cancel'"));
                }
            }).getValue();
        }
    }

    @Override
    public String getExecFileName(String name) {
        return name;
    }

    @Override
    protected FreeDesktopEntryWriter createFreeDesktopEntryWriter() {
        return new UnixFreeDesktopEntryWriter(NWorkspace.of().getDesktopPath() == null ? null : NPath.of(NWorkspace.of().getDesktopPath()));
    }

    @Override
    public String getTemplateName(String name, NShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return "template-" + name + ".sh";
            }
            case FISH: {
                return "template-" + name + ".fish";
            }
        }
        return "template-" + name + ".sh";
    }

    @Override
    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public NdiScriptInfo[] getNutsTerm(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(new NShellFamily[]{NShellFamily.SH}).map(x -> this.getNutsTerm(options, (NShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    @Override
    public NdiScriptInfo getNutsTerm(final NdiScriptOptions options, NShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveBinFolder().resolve(AnyNixNdi.this.getExecFileName("nuts-term"));
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term", NShellFamily.SH, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveBinFolder().resolve(AnyNixNdi.this.getExecFileName("nuts-term"));
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term", NShellFamily.FISH, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsEnv(final NdiScriptOptions options, NShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.sh");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-env", NShellFamily.SH, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.fish");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-env", NShellFamily.FISH, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsTermInit(final NdiScriptOptions options, NShellFamily shellFamily) {
        switch (shellFamily) {
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term-init", NShellFamily.FISH, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term-init", NShellFamily.SH, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsInit(final NdiScriptOptions options, NShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        NPath apiConfigFile = this.path();
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-init", NShellFamily.SH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(AnyNixNdi.this);
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        NPath apiConfigFile = this.path();
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-init", NShellFamily.FISH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(AnyNixNdi.this);
                    }
                };
            }
        }
        return null;
    }
}

