/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.text.NMutableTableModel;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArt;

public class NSettingsJavaSubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsJavaSubCommand(NWorkspace workspace) {
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        if (autoSave == null) {
            autoSave = false;
        }
        NSession session = NSession.of();
        NPrintStream out = session.out();
        NWorkspace workspace = NWorkspace.of();
        if (cmdLine.next("add java", "java add").isPresent()) {
            if (cmdLine.next("--search").isPresent()) {
                ArrayList<String> extraLocations = new ArrayList<String>();
                while (cmdLine.hasNext()) {
                    extraLocations.add(cmdLine.next().get().image());
                }
                if (extraLocations.isEmpty()) {
                    for (NPlatformLocation loc : workspace.searchSystemPlatforms(NPlatformFamily.JAVA)) {
                        workspace.addPlatform(loc);
                    }
                } else {
                    for (String extraLocation : extraLocations) {
                        for (NPlatformLocation loc : workspace.searchSystemPlatforms(NPlatformFamily.JAVA, NPath.of(extraLocation))) {
                            workspace.addPlatform(loc);
                        }
                    }
                }
                cmdLine.setCommandName("config java").throwUnexpectedArgument();
                if (autoSave.booleanValue()) {
                    workspace.saveConfig(false);
                }
            } else {
                while (cmdLine.hasNext()) {
                    NPlatformLocation loc = workspace.resolvePlatform(NPlatformFamily.JAVA, NPath.of(cmdLine.next().get().image()), null).orNull();
                    if (loc == null) continue;
                    workspace.addPlatform(loc);
                }
                if (autoSave.booleanValue()) {
                    workspace.saveConfig(false);
                }
            }
            return true;
        }
        if (cmdLine.next("remove java", "java remove").isPresent()) {
            while (cmdLine.hasNext()) {
                String name = cmdLine.next().get().image();
                NPlatformLocation loc = workspace.findPlatformByName(NPlatformFamily.JAVA, name).orNull();
                if (loc == null && (loc = workspace.findPlatformByName(NPlatformFamily.JAVA, name).orNull()) == null) {
                    loc = workspace.findPlatformByVersion(NPlatformFamily.JAVA, name).orNull();
                }
                if (loc == null) continue;
                workspace.removePlatform(loc);
            }
            if (autoSave.booleanValue()) {
                workspace.saveConfig(false);
            }
            return true;
        }
        if (cmdLine.next("list java", "java list").isPresent()) {
            NMutableTableModel m = NMutableTableModel.of();
            m.addHeaderRow(NText.ofPlain("Name"), NText.ofPlain("Version"), NText.ofPlain("Path"));
            while (cmdLine.hasNext()) {
                cmdLine.setCommandName("config list java").throwUnexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                NPlatformLocation[] sdks = (NPlatformLocation[])workspace.findPlatforms(NPlatformFamily.JAVA, null).toArray(NPlatformLocation[]::new);
                Arrays.sort(sdks, new Comparator<NPlatformLocation>(){

                    @Override
                    public int compare(NPlatformLocation o1, NPlatformLocation o2) {
                        int x = o1.getName().compareTo(o2.getName());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getVersion().compareTo(o2.getVersion());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getPath().compareTo(o2.getPath());
                        if (x != 0) {
                            return x;
                        }
                        return x;
                    }
                });
                for (NPlatformLocation jloc : sdks) {
                    m.addRow(NText.of(jloc.getName()), NText.of(jloc.getVersion()), NText.of(jloc.getPath()));
                }
                out.print(NTextArt.of().getTableRenderer().get().render(m));
            }
            return true;
        }
        return false;
    }
}

