/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.delete;

import java.util.HashSet;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;

public class NSettingsDeleteFoldersSubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsDeleteFoldersSubCommand(NWorkspace workspace) {
    }

    private static void deleteRepoCache(NRepository repository, boolean force) {
        NPath s = repository.config().getStoreLocation(NStoreType.CACHE);
        if (s != null) {
            NSession session = repository.getWorkspace().currentSession();
            if (s.exists()) {
                NOut.println(NMsg.ofC("```error deleting``` %s folder %s ...", NText.ofStyledPrimary1("cache"), s));
                if (force || NAsk.of().forBoolean(NMsg.ofPlain("force delete?")).setDefaultValue(false).getBooleanValue().booleanValue()) {
                    s.delete();
                }
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NRepository mirror : repository.config().getMirrors()) {
                NSettingsDeleteFoldersSubCommand.deleteRepoCache(mirror, force);
            }
        }
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        for (NStoreType value : NStoreType.values()) {
            String cmdName = "delete " + value.id();
            cmdLine.setCommandName("settings " + cmdName);
            if (!cmdLine.next(cmdName).isPresent()) continue;
            boolean force = false;
            HashSet<NStoreType> locationsToDelete = new HashSet<NStoreType>();
            locationsToDelete.add(value);
            while (cmdLine.hasNext()) {
                NArg a = cmdLine.nextFlag("-y", "--yes").orNull();
                if (a != null) {
                    force = a.getBooleanValue().get();
                    continue;
                }
                if (!cmdLine.isNextOption()) {
                    String s = cmdLine.peek().get().asString().get();
                    try {
                        locationsToDelete.add(NStoreType.valueOf(s.toUpperCase()));
                    }
                    catch (Exception ex) {
                        cmdLine.throwUnexpectedArgument();
                    }
                    continue;
                }
                cmdLine.throwUnexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                for (NStoreType folder : locationsToDelete) {
                    this.deleteWorkspaceFolder(folder, force);
                }
            }
            return true;
        }
        return false;
    }

    private void deleteWorkspaceFolder(NStoreType folder, boolean force) {
        NPath sstoreLocation = NPath.ofWorkspaceStore(folder);
        if (sstoreLocation != null) {
            NTexts factory = NTexts.of();
            if (sstoreLocation.exists()) {
                NOut.println(NMsg.ofC("```error deleting``` %s for workspace %s folder %s ...", factory.ofStyled(folder.id(), NTextStyle.primary1()), factory.ofStyled(NWorkspace.of().getName(), NTextStyle.primary1()), factory.ofStyled(sstoreLocation.toString(), NTextStyle.path())));
                if (force || NAsk.of().forBoolean(NMsg.ofPlain("force delete?")).setDefaultValue(false).getBooleanValue().booleanValue()) {
                    sstoreLocation.delete();
                }
            }
        }
        for (NRepository repository : NWorkspace.of().getRepositories()) {
            this.deleteRepoFolder(repository, folder, force);
        }
    }

    private void deleteRepoFolder(NRepository repository, NStoreType folder, boolean force) {
        NPath sstoreLocation = NPath.ofWorkspaceStore(folder);
        if (sstoreLocation != null) {
            NTexts factory = NTexts.of();
            if (sstoreLocation.exists()) {
                NOut.println(NMsg.ofC("```error deleting``` %s for repository %s folder %s ...", factory.ofStyled(folder.id(), NTextStyle.primary1()), factory.ofStyled(repository.getName(), NTextStyle.primary1()), factory.ofStyled(sstoreLocation.toString(), NTextStyle.path())));
                if (force || NAsk.of().forBoolean(NMsg.ofPlain("Force Delete?")).setDefaultValue(false).getBooleanValue().booleanValue()) {
                    sstoreLocation.delete();
                }
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NRepository subRepository : repository.config().getMirrors()) {
                NSettingsDeleteFoldersSubCommand.deleteRepoCache(subRepository, force);
            }
        }
    }

    private void deleteCache(boolean force) {
        NPath sstoreLocation = NPath.ofWorkspaceStore(NStoreType.CACHE);
        if (sstoreLocation != null) {
            if (sstoreLocation.exists()) {
                sstoreLocation.delete();
            }
            for (NRepository repository : NWorkspace.of().getRepositories()) {
                NSettingsDeleteFoldersSubCommand.deleteRepoCache(repository, force);
            }
        }
    }
}

