/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.connect;

import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.executor.system.PipeRunnable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;

public class NSettingsConnectSubCommand
extends AbstractNSettingsSubCommand {
    public static final int DEFAULT_ADMIN_SERVER_PORT = 8898;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        String cmd0 = cmdLine.toString();
        NSession session = NSession.of();
        if (cmdLine.next("connect").isPresent()) {
            char[] password = null;
            String server = null;
            while (cmdLine.hasNext()) {
                NArg a = cmdLine.nextEntry("--password").orNull();
                if (a != null) {
                    password = a.getValue().asString().orElse("").toCharArray();
                    continue;
                }
                if (cmdLine.isNextOption()) {
                    session.configureLast(cmdLine);
                    continue;
                }
                server = (String)cmdLine.nextNonOption(NArgName.of("ServerAddress")).flatMap(NArg::asString).get();
                cmdLine.setCommandName("settings connect").throwUnexpectedArgument();
            }
            if (!cmdLine.isExecMode()) {
                return true;
            }
            String login = null;
            int port = -1;
            NAssert.requireNonBlank(server, "server");
            if (server.contains("@")) {
                login = server.substring(0, server.indexOf("@"));
                server = server.substring(server.indexOf("@") + 1);
            }
            if (server.contains(":")) {
                port = NLiteral.of(server.substring(server.indexOf(":") + 1)).asInt().orElse(-1);
                server = server.substring(0, server.indexOf(":"));
            }
            if (!NBlankable.isBlank(login) && NBlankable.isBlank(password)) {
                password = session.getTerminal().readPassword(NMsg.ofPlain("Password:"));
            }
            Socket socket = null;
            try {
                try {
                    String line;
                    int validPort = port <= 0 ? 8898 : port;
                    socket = new Socket(InetAddress.getByName(server), validPort);
                    PipeRunnable rr = NSysExecUtils.pipe("pipe-out-socket-" + server + ":" + validPort, cmd0, "connect-socket", NInputSourceBuilder.of(socket.getInputStream()).setMetadata(new DefaultNContentMetadata().setMessage(NMsg.ofC("pipe-out-socket-%s:%s", server, validPort))).createNonBlockingInputStream(), NOut.asPrintStream());
                    NConcurrent.of().executorService().submit(rr);
                    PrintStream out = new PrintStream(socket.getOutputStream());
                    if (!NBlankable.isBlank(login)) {
                        out.printf("connect ==%s %s== %n", login, new String(password));
                    }
                    while ((line = session.getTerminal().readLine(NMsg.ofPlain(""))) != null) {
                        if (line.trim().length() <= 0) continue;
                        if (line.trim().equals("quit")) break;
                        if (line.trim().equals("exit")) {
                            break;
                        }
                        out.printf("%s%n", line);
                    }
                }
                finally {
                    if (socket != null) {
                        socket.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new NExecutionException(NMsg.ofPlain("settings connect failed"), ex, 2);
            }
            return true;
        }
        return false;
    }
}

