/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.backup;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NCompress;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NUncompress;
import net.thevpc.nuts.io.NUncompressVisitor;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNSettingsSubCommand;
import net.thevpc.nuts.text.NMsg;

public class NSettingsBackupSubCommand
extends AbstractNSettingsSubCommand {
    public NSettingsBackupSubCommand(NWorkspace workspace) {
    }

    @Override
    public boolean exec(NCmdLine cmdLine, Boolean autoSave) {
        NSession session = NSession.of();
        if (cmdLine.next("backup").isPresent()) {
            cmdLine.setCommandName("settings backup");
            String file = null;
            while (cmdLine.hasNext()) {
                NArg a = cmdLine.nextEntry("--file", "-f").orNull();
                if (a != null) {
                    file = a.getValue().asString().orElse("");
                    continue;
                }
                if (cmdLine.peek().get().isNonOption()) {
                    file = cmdLine.nextEntry().get().getValue().asString().orElse("");
                    continue;
                }
                session.configureLast(cmdLine);
            }
            if (cmdLine.isExecMode()) {
                ArrayList<String> all = new ArrayList<String>();
                all.add(NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json").toString());
                for (NStoreType value : NStoreType.values()) {
                    NPath r = NPath.ofWorkspaceStore(value);
                    if (!r.isDirectory()) continue;
                    all.add(r.toString());
                }
                if (file == null || file.isEmpty()) {
                    file = session.getWorkspace().getName() + ".zip";
                } else if (file.endsWith("/") || file.endsWith("\\")) {
                    file = file + session.getWorkspace().getName() + ".zip";
                } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                    file = file + File.separator + session.getWorkspace().getName() + ".zip";
                }
                if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0) {
                    file = file + ".zip";
                }
                NCompress cmp = NCompress.of();
                for (String s : all) {
                    cmp.addSource(NPath.of(s));
                }
                cmp.to(file).run();
            }
            return true;
        }
        if (cmdLine.next("restore").isPresent()) {
            cmdLine.setCommandName("settings restore");
            String file = null;
            String ws = null;
            while (cmdLine.hasNext()) {
                NArg a = cmdLine.nextEntry("--file", "-f").orNull();
                if (a != null) {
                    file = a.getValue().asString().orElse("");
                    continue;
                }
                a = cmdLine.nextEntry("--workspace", "-w").orNull();
                if (a != null) {
                    ws = a.getValue().asString().orElse("");
                    continue;
                }
                if (cmdLine.peek().get().isNonOption()) {
                    file = cmdLine.nextEntry().get().getValue().asString().orElse("");
                    continue;
                }
                session.configureLast(cmdLine);
            }
            if (file == null || file.isEmpty()) {
                file = session.getWorkspace().getName() + ".zip";
            } else if (file.endsWith("/") || file.endsWith("\\")) {
                file = file + session.getWorkspace().getName() + ".zip";
            } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + File.separator + session.getWorkspace().getName() + ".zip";
            }
            if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0 && !Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + ".zip";
            }
            if (!Files.isRegularFile(Paths.get(file, new String[0]), new LinkOption[0])) {
                cmdLine.throwMissingArgument(NMsg.ofC("not a valid file : %s", file));
            }
            if (cmdLine.isExecMode()) {
                final NObjectElement[] nutsWorkspaceConfigRef = new NObjectElement[1];
                NUncompress.of().from(NPath.of(file)).visit(new NUncompressVisitor(){

                    @Override
                    public boolean visitFolder(String path) {
                        return true;
                    }

                    @Override
                    public boolean visitFile(String path, InputStream inputStream) {
                        if ("/nuts-workspace.json".equals(path)) {
                            NObjectElement e;
                            nutsWorkspaceConfigRef[0] = e = NElementParser.ofJson().parse(inputStream, NObjectElement.class).asObject().get();
                            return false;
                        }
                        return true;
                    }
                }).run();
                if (nutsWorkspaceConfigRef[0] == null) {
                    cmdLine.throwMissingArgument(NMsg.ofC("not a valid file : %s", file));
                }
                if (ws == null || ws.isEmpty()) {
                    ws = nutsWorkspaceConfigRef[0].getStringValue("name").get();
                }
                if (ws == null || ws.isEmpty()) {
                    cmdLine.throwMissingArgument(NMsg.ofC("not a valid file : %s", file));
                }
                String platformHomeFolder = NPlatformHome.of(null, NWorkspace.of().getStoredConfig().isSystem()).getWorkspaceLocation(ws);
                NUncompress.of().from(NPath.of(file)).to(NPath.of(platformHomeFolder)).setSkipRoot(true).run();
                if (session.isPlainTrace()) {
                    NOut.println(NMsg.ofC("restore %s to %s", file, platformHomeFolder));
                }
            }
            return true;
        }
        return false;
    }
}

