/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NCmdExecOptions;
import net.thevpc.nuts.command.NCommandConfig;
import net.thevpc.nuts.command.NCustomCmd;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;

public class DefaultNCustomCommand
implements NCustomCmd {
    private String name;
    private NId owner;
    private String factoryId;
    private List<String> command;
    private List<String> helpCommand;
    private String helpText;
    private List<String> executorOptions;

    protected NLog _LOG() {
        return NLog.of(DefaultNCustomCommand.class);
    }

    @Override
    public String getFactoryId() {
        return this.factoryId;
    }

    @Override
    public NId getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultNCustomCommand setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public int exec(String[] args, NCmdExecOptions options) {
        NSession session = NSession.of();
        if (session.isDry()) {
            ArrayList<String> executorOptions = new ArrayList<String>(options.getExecutorOptions());
            executorOptions.addAll(this.getExecutorOptions());
            ArrayList<String> r = new ArrayList<String>(this.getCommand());
            r.addAll(Arrays.asList(args));
            args = r.toArray(new String[0]);
            return NExecCmd.of().addCommand(args).addExecutorOptions(executorOptions).setDirectory(options.getDirectory()).failFast().setEnv(options.getEnv()).setExecutionType(options.getExecutionType()).run().getResultCode();
        }
        ArrayList<String> executorOptions = new ArrayList<String>(options.getExecutorOptions());
        executorOptions.addAll(this.getExecutorOptions());
        ArrayList<String> r = new ArrayList<String>(this.getCommand());
        r.addAll(Arrays.asList(args));
        args = r.toArray(new String[0]);
        return NExecCmd.of().addCommand(args).addExecutorOptions(executorOptions).setDirectory(options.getDirectory()).failFast().setEnv(options.getEnv()).setExecutionType(options.getExecutionType()).run().getResultCode();
    }

    @Override
    public NText getHelpText() throws NExecutionException {
        if (!NBlankable.isBlank(this.helpText)) {
            return NText.ofPlain(this.helpText);
        }
        if (this.helpCommand != null && this.helpCommand.size() > 0) {
            try {
                return NText.ofPlain(NExecCmd.of().addCommand(this.helpCommand).setFailFast(false).run().getGrabbedAllString());
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofC("failed to retrieve help for %s", this.getName()).asFine(ex));
                return NText.ofStyled("failed to retrieve help for " + this.getName(), NTextStyle.error());
            }
        }
        return null;
    }

    @Override
    public List<String> getCommand() {
        return NCollections.unmodifiableList(this.command);
    }

    public DefaultNCustomCommand setCommand(List<String> command) {
        this.command = NCollections.nonNullList(command);
        return this;
    }

    public DefaultNCustomCommand setCommand(String[] command) {
        this.command = NCollections.nonNullListFromArray(command);
        return this;
    }

    @Override
    public List<String> getExecutorOptions() {
        return NCollections.unmodifiableList(this.executorOptions);
    }

    public DefaultNCustomCommand setExecutorOptions(List<String> executorOptions) {
        this.executorOptions = NCollections.nonNullList(executorOptions);
        return this;
    }

    public DefaultNCustomCommand setExecutorOptions(String[] executorOptions) {
        this.executorOptions = NCollections.nonNullListFromArray(executorOptions);
        return this;
    }

    @Override
    public NCommandConfig toCommandConfig() {
        return new NCommandConfig().setCommand(this.getCommand()).setFactoryId(this.getFactoryId()).setOwner(this.getOwner()).setExecutorOptions(this.getExecutorOptions()).setName(this.getName()).setHelpCommand(this.helpCommand).setHelpText(this.helpText);
    }

    public DefaultNCustomCommand setOwner(NId owner) {
        this.owner = owner;
        return this;
    }

    public DefaultNCustomCommand setFactoryId(String factoryId) {
        this.factoryId = factoryId;
        return this;
    }

    public DefaultNCustomCommand setHelpCommand(List<String> helpCommand) {
        this.helpCommand = helpCommand;
        return this;
    }

    public DefaultNCustomCommand setHelpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    public String toString() {
        return "NWorkspaceCommand{name=" + this.name + ", owner=" + this.owner + ", factoryId=" + this.factoryId + ", command=" + this.command + ", executorOptions=" + this.executorOptions + '}';
    }
}

